/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.util;

import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final char CHAR_CHINESE_SPACE = '\u3000';

    public static boolean checkMobile(String str) {
        Pattern p = Pattern.compile("1[34578][0-9]{9}");
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static boolean checkEmail(String emailStr) {
        String check = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
        Pattern regex = Pattern.compile(check);
        Matcher matcher = regex.matcher(emailStr.trim());
        boolean isMatched = matcher.matches();
        return isMatched;
    }

    public static String md5(String s) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            byte[] strTemp = s.getBytes();
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(strTemp);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte b = md[i];
                str[k++] = hexDigits[b >> 4 & 0xF];
                str[k++] = hexDigits[b & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String trim(String input) {
        if (input == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == ' ') continue;
            sb.append(input.charAt(i));
        }
        return sb.toString();
    }

    public static String mid(String s, String startToken, String endToken) {
        return StringUtils.mid(s, startToken, endToken, 0);
    }

    public static String mid(String s, String startToken, String endToken, int fromStart) {
        if (startToken == null || endToken == null) {
            return null;
        }
        int start = s.indexOf(startToken, fromStart);
        if (start == -1) {
            return null;
        }
        int end = s.indexOf(endToken, start + startToken.length());
        if (end == -1) {
            return null;
        }
        String sub = s.substring(start + startToken.length(), end);
        return sub.trim();
    }

    public static String compact(String s) {
        char[] cs = new char[s.length()];
        int len = 0;
        for (int n = 0; n < cs.length; ++n) {
            char c = s.charAt(n);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u3000') continue;
            cs[len] = c;
            ++len;
        }
        return new String(cs, 0, len);
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "").toLowerCase();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isBlank(Object obj) {
        if (null == obj) {
            return true;
        }
        String str = obj.toString();
        int strLen = str.length();
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(Object obj) {
        return !StringUtils.isBlank(obj);
    }

    public static boolean isNotBlank(Object ... objs) {
        if (objs == null || objs.length == 0) {
            return false;
        }
        for (Object obj : objs) {
            if (StringUtils.isNotBlank(obj)) continue;
            return false;
        }
        return true;
    }

    public static String nullToBlank(String str) {
        return str == null ? "" : str;
    }

    public static String[] union(String[] arr1, String[] arr2) {
        HashSet<String> set = new HashSet<String>();
        for (String str : arr1) {
            set.add(str);
        }
        for (String str : arr2) {
            set.add(str);
        }
        String[] result = new String[]{};
        return set.toArray(result);
    }

    public static String[] intersect(String[] arr1, String[] arr2) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        LinkedList list = new LinkedList();
        for (String str : arr1) {
            if (map.containsKey(str)) continue;
            map.put(str, Boolean.FALSE);
        }
        for (String str : arr2) {
            if (!map.containsKey(str)) continue;
            map.put(str, Boolean.TRUE);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!((Boolean)entry.getValue()).equals(Boolean.TRUE)) continue;
            list.add(entry.getKey());
        }
        String[] result = new String[]{};
        return list.toArray(result);
    }

    public static String[] minus(String[] arr1, String[] arr2) {
        LinkedList<String> list = new LinkedList<String>();
        LinkedList<String> history = new LinkedList<String>();
        String[] longerArr = arr1;
        String[] shorterArr = arr2;
        if (arr1.length > arr2.length) {
            longerArr = arr2;
            shorterArr = arr1;
        }
        for (String str : longerArr) {
            if (list.contains(str)) continue;
            list.add(str);
        }
        for (String str : shorterArr) {
            if (list.contains(str)) {
                history.add(str);
                list.remove(str);
                continue;
            }
            if (history.contains(str)) continue;
            list.add(str);
        }
        String[] result = new String[]{};
        return list.toArray(result);
    }

    public static String reverse(String str) {
        return new StringBuffer(str).reverse().toString();
    }

    public static String[] reverse(String[] strs) {
        for (int i = 0; i < strs.length; ++i) {
            String top = strs[0];
            for (int j = 1; j < strs.length - i; ++j) {
                strs[j - 1] = strs[j];
            }
            strs[strs.length - i - 1] = top;
        }
        return strs;
    }

    public static String htmlEscapeCharsToString(String html) {
        if (StringUtils.isEmpty(html)) {
            return html;
        }
        return html.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&").replaceAll("&quot;", "\"");
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[.\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static boolean isNumber(String str) {
        if (StringUtils.isLong(str)) {
            return true;
        }
        Pattern pattern = Pattern.compile("(-)?(\\d*)\\.{0,1}(\\d*)");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static boolean isLong(String str) {
        if ("0".equals(str.trim())) {
            return true;
        }
        Pattern pattern = Pattern.compile("^[^0]\\d*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static boolean isFloat(String str) {
        if (StringUtils.isLong(str)) {
            return true;
        }
        Pattern pattern = Pattern.compile("\\d*\\.{1}\\d+");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }
}

