/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.http.request;

import cc.livvy.framework.http.OkHttpUtils;
import cc.livvy.framework.http.builder.PostFormBuilder;
import cc.livvy.framework.http.callback.Callback;
import cc.livvy.framework.http.request.CountingRequestBody;
import cc.livvy.framework.http.request.OkHttpRequest;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.io.File;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;

public class PostFormRequest
extends OkHttpRequest {
    private List<PostFormBuilder.FileInput> files;

    public PostFormRequest(String url, Object tag, Map<String, String> params, Map<String, String> headers, List<PostFormBuilder.FileInput> files) {
        super(url, tag, params, headers);
        this.files = files;
    }

    @Override
    protected RequestBody buildRequestBody() {
        if (this.files == null || this.files.isEmpty()) {
            FormEncodingBuilder builder = new FormEncodingBuilder();
            this.addParams(builder);
            return builder.build();
        }
        MultipartBuilder builder = new MultipartBuilder().type(MultipartBuilder.FORM);
        this.addParams(builder);
        for (int i = 0; i < this.files.size(); ++i) {
            PostFormBuilder.FileInput fileInput = this.files.get(i);
            RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)this.guessMimeType(fileInput.filename)), (File)fileInput.file);
            builder.addFormDataPart(fileInput.key, fileInput.filename, fileBody);
        }
        return builder.build();
    }

    @Override
    protected RequestBody wrapRequestBody(RequestBody requestBody, final Callback callback) {
        if (callback == null) {
            return requestBody;
        }
        CountingRequestBody countingRequestBody = new CountingRequestBody(requestBody, new CountingRequestBody.Listener(){

            @Override
            public void onRequestProgress(final long bytesWritten, final long contentLength) {
                OkHttpUtils.getInstance().getDelivery().post(new Runnable(){

                    @Override
                    public void run() {
                        callback.inProgress((float)bytesWritten * 1.0f / (float)contentLength);
                    }
                });
            }
        });
        return countingRequestBody;
    }

    @Override
    protected Request buildRequest(Request.Builder builder, RequestBody requestBody) {
        return builder.post(requestBody).build();
    }

    private String guessMimeType(String path) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentTypeFor = fileNameMap.getContentTypeFor(path);
        if (contentTypeFor == null) {
            contentTypeFor = "application/octet-stream";
        }
        return contentTypeFor;
    }

    private void addParams(MultipartBuilder builder) {
        if (this.params != null && !this.params.isEmpty()) {
            for (String key : this.params.keySet()) {
                builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + key + "\""}), RequestBody.create(null, (String)((String)this.params.get(key))));
            }
        }
    }

    private void addParams(FormEncodingBuilder builder) {
        if (this.params == null || this.params.isEmpty()) {
            builder.add("1", "1");
            return;
        }
        for (String key : this.params.keySet()) {
            builder.add(key, (String)this.params.get(key));
        }
    }
}

