package cc.livvy.framework.widget.repeater;

/**
 * 单元格类名选择器
 */
public abstract class DataCellSelector {
	/**
	 * 当前单元格选择器中所有的类名清单
	 */
	public final Class<?> mCellClasses[] = getCellClasses();

	/**
	 * 当前单元格选择器中单元格类型总数
	 * @return int
	 */
	public final int getCellTypeCount(){
		return mCellClasses.length;
	}

	/**
	 * 获取指定位置的单元格对应的类型编号
	 * 
	 * @param adapter 单元格对应的数据适配器
	 * @param position 单元格在 ListView 中的位置
	 * @return int 单元格对应的类型编号
	 */
	public final int getCellType(DataAdapter adapter, int position){
		Class<?> cls = getCellClass(adapter, position);

		for(int i=0; i<mCellClasses.length;i++){
			if(mCellClasses[i].equals(cls)){
				return i;
			}
		}

		return 0;
	}

	/**
	 * 返回单元格选择器中所有的类名清单 (由子类是实现)
	 * 该方法只会在单元格类名选择器初始化时被调用一次。
	 */
	protected abstract Class<?>[] getCellClasses();

	/**
	 * 返回指定位置单元格对应的类名
	 * 返回的类名必须在 mCellClasses 中有对应的值
	 * 
	 * @param adapter 单元格对应的数据适配器
	 * @param position 单元格在 ListView 中的位置
	 */
	public abstract Class<?> getCellClass(DataAdapter adapter, int position);
}
