package cc.livvy.framework.widget.grid;

import cc.livvy.framework.widget.list.DataListDefaultCellProvider;
import cc.livvy.framework.widget.list.cells.DataListDefaultCell;
import cc.livvy.framework.widget.list.cells.DataListEmptyCell;
import cc.livvy.framework.widget.list.cells.DataListErrorCell;
import cc.livvy.framework.widget.list.cells.DataListLoadingCell;
import cc.livvy.framework.widget.list.cells.DataListMoreCell;
import cc.livvy.framework.widget.repeater.DataCellOrganizer;

/**
 * Created by livvym on 16-3-16.
 */
public class DataGridCellCenter {

    /**
     * 获取默认单元格的配置器
     */
    private static DataListDefaultCellProvider mDefaultCellProvider = null;

    /**
     * 设置默认单元格的配置器
     */
    public static void setDefaultCellProvider(DataListDefaultCellProvider provider){
        mDefaultCellProvider = provider;
    }

    /**
     * 获取出错单元格的配置器
     * 配置器中会被设上默认的出错单元格
     *
     * @return DataCellOrganizer
     */
    public static DataCellOrganizer errorOrganizer(DataGridAdapter adapter) {
        Class<?> cellClass = null == mDefaultCellProvider ? null : mDefaultCellProvider.getDefaultErrorCellClass();

        if(null == cellClass){
            cellClass = DataListErrorCell.class;
        }

        return new DataCellOrganizer(adapter, cellClass);
    }

    /**
     * 获取数据为空单元格的配置器
     * 配置器中会被设上默认的数据为空单元格
     *
     * @return DataCellOrganizer
     */
    public static DataCellOrganizer emptyOrganizer(DataGridAdapter adapter) {
        Class<?> cellClass = null == mDefaultCellProvider ? null : mDefaultCellProvider.getDefaultEmptyCellClass();

        if(null == cellClass){
            cellClass = DataListEmptyCell.class;
        }

        return new DataCellOrganizer(adapter, cellClass);
    }

    /**
     * 获取加载中单元格的配置器
     * 配置器中会被设上默认的加载中单元格
     *
     * @return DataCellOrganizer
     */
    public static DataCellOrganizer loadingOrganizer(DataGridAdapter adapter) {
        Class<?> cellClass = null == mDefaultCellProvider ? null : mDefaultCellProvider.getDefaultLoadingCellClass();

        if(null == cellClass){
            cellClass = DataListLoadingCell.class;
        }

        return new DataCellOrganizer(adapter, cellClass);
    }

    /**
     * 获取下一页单元格的配置器
     * 配置器中会被设上默认的下一页单元格
     *
     * @return DataCellOrganizer
     */
    public static DataCellOrganizer moreOrganizer(DataGridAdapter adapter) {
        Class<?> cellClass = null == mDefaultCellProvider ? null : mDefaultCellProvider.getDefaultMoreCellClass();

        if(null == cellClass){
            cellClass = DataListMoreCell.class;
        }

        return new DataCellOrganizer(adapter, cellClass);
    }

    /**
     * 获取数据单元格的配置器
     * 配置器中会被设上默认的数据单元格
     *
     * @return DataCellOrganizer
     */
    public static DataCellOrganizer dataOrganizer(DataGridAdapter adapter) {
        Class<?> cellClass = null == mDefaultCellProvider ? null : mDefaultCellProvider.getDefaultDataCellClass();

        if(null == cellClass){
            cellClass = DataListDefaultCell.class;
        }

        return new DataCellOrganizer(adapter, cellClass);
    }

}
