/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget.repeater;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.LinearLayout;
import android.widget.TextView;
import cc.livvy.framework.data.model.DataItem;
import cc.livvy.framework.util.DeviceUtil;
import cc.livvy.framework.widget.repeater.DataAdapter;
import cc.livvy.framework.widget.repeater.DataView;

public abstract class DataCell {
    protected DataAdapter mAdapter;
    private View mCellView;
    protected int mPosition;
    protected DataItem mDetail;
    protected boolean isTag;

    public DataView getDataView() {
        return this.mAdapter.getDataView();
    }

    public Context getContext() {
        return this.mAdapter.getContext();
    }

    public final void initAdapterAndCellViewForOnce(DataAdapter adapter, int position) {
        this.mAdapter = adapter;
        this.updateCellData(position);
        try {
            int cellID = this.getCellViewLayoutID();
            this.mCellView = cellID != 0 ? LayoutInflater.from((Context)adapter.getContext()).inflate(cellID, null) : this.createCellView();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (null == this.mCellView) {
            this.mCellView = this.createDefaultCellView();
        }
        this.mCellView.setTag((Object)this);
        this.bindView();
        this.bindData();
    }

    public final void updateCellData(int position) {
        this.mPosition = position;
        this.mDetail = this.mAdapter.getDataItem(position);
    }

    public final int getPosition() {
        return this.mPosition;
    }

    public final DataItem getCellData() {
        return this.mDetail;
    }

    private View createDefaultCellView() {
        LinearLayout rootLayout = new LinearLayout(this.mAdapter.getContext());
        AbsListView.LayoutParams rootParams = new AbsListView.LayoutParams(-1, -2);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)rootParams);
        rootLayout.setGravity(48);
        rootLayout.setBackgroundColor(Color.parseColor((String)"#E5E5E5"));
        TextView textViewLayout = new TextView(this.mAdapter.getContext());
        ViewGroup.LayoutParams textViewParams = new ViewGroup.LayoutParams(-1, -2);
        int textViewPadding = DeviceUtil.dip2px(20.0f);
        textViewLayout.setLayoutParams(textViewParams);
        textViewLayout.setGravity(8388627);
        textViewLayout.setPadding(textViewPadding, textViewPadding, textViewPadding, textViewPadding);
        textViewLayout.setTextColor(ColorStateList.valueOf((int)Color.parseColor((String)"#FF0000")));
        textViewLayout.setTextSize(14.0f);
        textViewLayout.setText((CharSequence)"Default cell view.");
        rootLayout.addView((View)textViewLayout);
        return rootLayout;
    }

    public final View getCellView() {
        return this.mCellView;
    }

    public final View findViewById(int id2) {
        return this.mCellView.findViewById(id2);
    }

    public View createCellView() {
        return null;
    }

    public abstract int getCellViewLayoutID();

    public abstract void bindView();

    public abstract void bindData();
}

