/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget.observablescrollview;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import cc.livvy.framework.widget.observablescrollview.ObservableScrollViewCallbacks;
import cc.livvy.framework.widget.observablescrollview.ScrollState;
import cc.livvy.framework.widget.observablescrollview.Scrollable;
import java.util.ArrayList;
import java.util.List;

public class ObservableRecyclerView
extends RecyclerView
implements Scrollable {
    private static int recyclerViewLibraryVersion = 22;
    private int mPrevFirstVisiblePosition;
    private int mPrevFirstVisibleChildHeight = -1;
    private int mPrevScrolledChildrenHeight;
    private int mPrevScrollY;
    private int mScrollY;
    private SparseIntArray mChildrenHeights;
    private ObservableScrollViewCallbacks mCallbacks;
    private List<ObservableScrollViewCallbacks> mCallbackCollection;
    private ScrollState mScrollState;
    private boolean mFirstScroll;
    private boolean mDragging;
    private boolean mIntercepted;
    private MotionEvent mPrevMoveEvent;
    private ViewGroup mTouchInterceptionViewGroup;

    public ObservableRecyclerView(Context context) {
        super(context);
        this.init();
    }

    public ObservableRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ObservableRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.mPrevFirstVisiblePosition = ss.prevFirstVisiblePosition;
        this.mPrevFirstVisibleChildHeight = ss.prevFirstVisibleChildHeight;
        this.mPrevScrolledChildrenHeight = ss.prevScrolledChildrenHeight;
        this.mPrevScrollY = ss.prevScrollY;
        this.mScrollY = ss.scrollY;
        this.mChildrenHeights = ss.childrenHeights;
        super.onRestoreInstanceState(ss.getSuperState());
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.prevFirstVisiblePosition = this.mPrevFirstVisiblePosition;
        ss.prevFirstVisibleChildHeight = this.mPrevFirstVisibleChildHeight;
        ss.prevScrolledChildrenHeight = this.mPrevScrolledChildrenHeight;
        ss.prevScrollY = this.mPrevScrollY;
        ss.scrollY = this.mScrollY;
        ss.childrenHeights = this.mChildrenHeights;
        return ss;
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if ((this.mCallbacks != null || this.mCallbackCollection != null) && this.getChildCount() > 0) {
            int firstVisiblePosition = this.getChildAdapterPosition(this.getChildAt(0));
            int lastVisiblePosition = this.getChildAdapterPosition(this.getChildAt(this.getChildCount() - 1));
            int i = firstVisiblePosition;
            int j = 0;
            while (i <= lastVisiblePosition) {
                int childHeight = 0;
                View child = this.getChildAt(j);
                if (child != null && (this.mChildrenHeights.indexOfKey(i) < 0 || child.getHeight() != this.mChildrenHeights.get(i))) {
                    childHeight = child.getHeight();
                }
                this.mChildrenHeights.put(i, childHeight);
                ++i;
                ++j;
            }
            View firstVisibleChild = this.getChildAt(0);
            if (firstVisibleChild != null) {
                int i2;
                int skippedChildrenHeight;
                if (this.mPrevFirstVisiblePosition < firstVisiblePosition) {
                    skippedChildrenHeight = 0;
                    if (firstVisiblePosition - this.mPrevFirstVisiblePosition != 1) {
                        for (i2 = firstVisiblePosition - 1; i2 > this.mPrevFirstVisiblePosition; --i2) {
                            if (0 < this.mChildrenHeights.indexOfKey(i2)) {
                                skippedChildrenHeight += this.mChildrenHeights.get(i2);
                                continue;
                            }
                            skippedChildrenHeight += firstVisibleChild.getHeight();
                        }
                    }
                    this.mPrevScrolledChildrenHeight += this.mPrevFirstVisibleChildHeight + skippedChildrenHeight;
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                } else if (firstVisiblePosition < this.mPrevFirstVisiblePosition) {
                    skippedChildrenHeight = 0;
                    if (this.mPrevFirstVisiblePosition - firstVisiblePosition != 1) {
                        for (i2 = this.mPrevFirstVisiblePosition - 1; i2 > firstVisiblePosition; --i2) {
                            if (0 < this.mChildrenHeights.indexOfKey(i2)) {
                                skippedChildrenHeight += this.mChildrenHeights.get(i2);
                                continue;
                            }
                            skippedChildrenHeight += firstVisibleChild.getHeight();
                        }
                    }
                    this.mPrevScrolledChildrenHeight -= firstVisibleChild.getHeight() + skippedChildrenHeight;
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                } else if (firstVisiblePosition == 0) {
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                    this.mPrevScrolledChildrenHeight = 0;
                }
                if (this.mPrevFirstVisibleChildHeight < 0) {
                    this.mPrevFirstVisibleChildHeight = 0;
                }
                this.mScrollY = this.mPrevScrolledChildrenHeight - firstVisibleChild.getTop();
                this.mPrevFirstVisiblePosition = firstVisiblePosition;
                this.dispatchOnScrollChanged(this.mScrollY, this.mFirstScroll, this.mDragging);
                if (this.mFirstScroll) {
                    this.mFirstScroll = false;
                }
                this.mScrollState = this.mPrevScrollY < this.mScrollY ? ScrollState.UP : (this.mScrollY < this.mPrevScrollY ? ScrollState.DOWN : ScrollState.STOP);
                this.mPrevScrollY = this.mScrollY;
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mCallbacks != null || this.mCallbackCollection != null) {
            switch (ev.getActionMasked()) {
                case 0: {
                    this.mDragging = true;
                    this.mFirstScroll = true;
                    this.dispatchOnDownMotionEvent();
                }
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mCallbacks != null || this.mCallbackCollection != null) {
            switch (ev.getActionMasked()) {
                case 1: 
                case 3: {
                    this.mIntercepted = false;
                    this.mDragging = false;
                    this.dispatchOnUpOrCancelMotionEvent(this.mScrollState);
                    break;
                }
                case 2: {
                    if (this.mPrevMoveEvent == null) {
                        this.mPrevMoveEvent = ev;
                    }
                    float diffY = ev.getY() - this.mPrevMoveEvent.getY();
                    this.mPrevMoveEvent = MotionEvent.obtainNoHistory((MotionEvent)ev);
                    if (!((float)this.getCurrentScrollY() - diffY <= 0.0f)) break;
                    if (this.mIntercepted) {
                        return false;
                    }
                    final ViewGroup parent = this.mTouchInterceptionViewGroup == null ? (ViewGroup)this.getParent() : this.mTouchInterceptionViewGroup;
                    float offsetX = 0.0f;
                    float offsetY = 0.0f;
                    for (ObservableRecyclerView v = this; v != null && v != parent; v = (View)v.getParent()) {
                        offsetX += (float)(v.getLeft() - v.getScrollX());
                        offsetY += (float)(v.getTop() - v.getScrollY());
                    }
                    final MotionEvent event = MotionEvent.obtainNoHistory((MotionEvent)ev);
                    event.offsetLocation(offsetX, offsetY);
                    if (parent.onInterceptTouchEvent(event)) {
                        this.mIntercepted = true;
                        event.setAction(0);
                        this.post(new Runnable(){

                            @Override
                            public void run() {
                                parent.dispatchTouchEvent(event);
                            }
                        });
                        return false;
                    }
                    return super.onTouchEvent(ev);
                }
            }
        }
        return super.onTouchEvent(ev);
    }

    @Override
    public void setScrollViewCallbacks(ObservableScrollViewCallbacks listener) {
        this.mCallbacks = listener;
    }

    @Override
    public void addScrollViewCallbacks(ObservableScrollViewCallbacks listener) {
        if (this.mCallbackCollection == null) {
            this.mCallbackCollection = new ArrayList<ObservableScrollViewCallbacks>();
        }
        this.mCallbackCollection.add(listener);
    }

    @Override
    public void removeScrollViewCallbacks(ObservableScrollViewCallbacks listener) {
        if (this.mCallbackCollection != null) {
            this.mCallbackCollection.remove(listener);
        }
    }

    @Override
    public void clearScrollViewCallbacks() {
        if (this.mCallbackCollection != null) {
            this.mCallbackCollection.clear();
        }
    }

    @Override
    public void setTouchInterceptionViewGroup(ViewGroup viewGroup) {
        this.mTouchInterceptionViewGroup = viewGroup;
    }

    @Override
    public void scrollVerticallyTo(int y) {
        View firstVisibleChild = this.getChildAt(0);
        if (firstVisibleChild != null) {
            int baseHeight = firstVisibleChild.getHeight();
            int position = y / baseHeight;
            this.scrollVerticallyToPosition(position);
        }
    }

    public void scrollVerticallyToPosition(int position) {
        RecyclerView.LayoutManager lm = this.getLayoutManager();
        if (lm != null && lm instanceof LinearLayoutManager) {
            ((LinearLayoutManager)lm).scrollToPositionWithOffset(position, 0);
        } else {
            this.scrollToPosition(position);
        }
    }

    @Override
    public int getCurrentScrollY() {
        return this.mScrollY;
    }

    public int getChildAdapterPosition(View child) {
        if (22 <= recyclerViewLibraryVersion) {
            return super.getChildAdapterPosition(child);
        }
        return this.getChildPosition(child);
    }

    private void init() {
        this.mChildrenHeights = new SparseIntArray();
        this.checkLibraryVersion();
    }

    private void checkLibraryVersion() {
        try {
            super.getChildAdapterPosition(null);
        }
        catch (NoSuchMethodError e) {
            recyclerViewLibraryVersion = 21;
        }
    }

    private void dispatchOnDownMotionEvent() {
        if (this.mCallbacks != null) {
            this.mCallbacks.onDownMotionEvent();
        }
        if (this.mCallbackCollection != null) {
            for (int i = 0; i < this.mCallbackCollection.size(); ++i) {
                ObservableScrollViewCallbacks callbacks = this.mCallbackCollection.get(i);
                callbacks.onDownMotionEvent();
            }
        }
    }

    private void dispatchOnScrollChanged(int scrollY, boolean firstScroll, boolean dragging) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onScrollChanged(scrollY, firstScroll, dragging);
        }
        if (this.mCallbackCollection != null) {
            for (int i = 0; i < this.mCallbackCollection.size(); ++i) {
                ObservableScrollViewCallbacks callbacks = this.mCallbackCollection.get(i);
                callbacks.onScrollChanged(scrollY, firstScroll, dragging);
            }
        }
    }

    private void dispatchOnUpOrCancelMotionEvent(ScrollState scrollState) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onUpOrCancelMotionEvent(scrollState);
        }
        if (this.mCallbackCollection != null) {
            for (int i = 0; i < this.mCallbackCollection.size(); ++i) {
                ObservableScrollViewCallbacks callbacks = this.mCallbackCollection.get(i);
                callbacks.onUpOrCancelMotionEvent(scrollState);
            }
        }
    }

    static class SavedState
    implements Parcelable {
        public static final SavedState EMPTY_STATE = new SavedState(){};
        int prevFirstVisiblePosition;
        int prevFirstVisibleChildHeight = -1;
        int prevScrolledChildrenHeight;
        int prevScrollY;
        int scrollY;
        SparseIntArray childrenHeights;
        Parcelable superState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState() {
            this.superState = null;
        }

        SavedState(Parcelable superState) {
            this.superState = superState != EMPTY_STATE ? superState : null;
        }

        private SavedState(Parcel in) {
            Parcelable superState = in.readParcelable(RecyclerView.class.getClassLoader());
            this.superState = superState != null ? superState : EMPTY_STATE;
            this.prevFirstVisiblePosition = in.readInt();
            this.prevFirstVisibleChildHeight = in.readInt();
            this.prevScrolledChildrenHeight = in.readInt();
            this.prevScrollY = in.readInt();
            this.scrollY = in.readInt();
            this.childrenHeights = new SparseIntArray();
            int numOfChildren = in.readInt();
            if (0 < numOfChildren) {
                for (int i = 0; i < numOfChildren; ++i) {
                    int key = in.readInt();
                    int value = in.readInt();
                    this.childrenHeights.put(key, value);
                }
            }
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeParcelable(this.superState, flags);
            out.writeInt(this.prevFirstVisiblePosition);
            out.writeInt(this.prevFirstVisibleChildHeight);
            out.writeInt(this.prevScrolledChildrenHeight);
            out.writeInt(this.prevScrollY);
            out.writeInt(this.scrollY);
            int numOfChildren = this.childrenHeights == null ? 0 : this.childrenHeights.size();
            out.writeInt(numOfChildren);
            if (0 < numOfChildren) {
                for (int i = 0; i < numOfChildren; ++i) {
                    out.writeInt(this.childrenHeights.keyAt(i));
                    out.writeInt(this.childrenHeights.valueAt(i));
                }
            }
        }

        public Parcelable getSuperState() {
            return this.superState;
        }
    }
}

