/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget.observablescrollview;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.util.SparseArray;
import android.view.ViewGroup;

public abstract class CacheFragmentStatePagerAdapter
extends FragmentStatePagerAdapter {
    private static final String STATE_SUPER_STATE = "superState";
    private static final String STATE_PAGES = "pages";
    private static final String STATE_PAGE_INDEX_PREFIX = "pageIndex:";
    private static final String STATE_PAGE_KEY_PREFIX = "page:";
    private FragmentManager mFm;
    private SparseArray<Fragment> mPages = new SparseArray();

    public CacheFragmentStatePagerAdapter(FragmentManager fm) {
        super(fm);
        this.mFm = fm;
    }

    public Parcelable saveState() {
        Parcelable p = super.saveState();
        Bundle bundle = new Bundle();
        bundle.putParcelable(STATE_SUPER_STATE, p);
        bundle.putInt(STATE_PAGES, this.mPages.size());
        if (0 < this.mPages.size()) {
            for (int i = 0; i < this.mPages.size(); ++i) {
                int position = this.mPages.keyAt(i);
                bundle.putInt(this.createCacheIndex(i), position);
                Fragment f = (Fragment)this.mPages.get(position);
                this.mFm.putFragment(bundle, this.createCacheKey(position), f);
            }
        }
        return bundle;
    }

    public void restoreState(Parcelable state, ClassLoader loader) {
        Bundle bundle = (Bundle)state;
        int pages = bundle.getInt(STATE_PAGES);
        if (0 < pages) {
            for (int i = 0; i < pages; ++i) {
                int position = bundle.getInt(this.createCacheIndex(i));
                Fragment f = this.mFm.getFragment(bundle, this.createCacheKey(position));
                this.mPages.put(position, (Object)f);
            }
        }
        Parcelable p = bundle.getParcelable(STATE_SUPER_STATE);
        super.restoreState(p, loader);
    }

    public Fragment getItem(int position) {
        Fragment f = this.createItem(position);
        this.mPages.put(position, (Object)f);
        return f;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (0 <= this.mPages.indexOfKey(position)) {
            this.mPages.remove(position);
        }
        super.destroyItem(container, position, object);
    }

    public Fragment getItemAt(int position) {
        return (Fragment)this.mPages.get(position);
    }

    protected abstract Fragment createItem(int var1);

    protected String createCacheIndex(int index) {
        return STATE_PAGE_INDEX_PREFIX + index;
    }

    protected String createCacheKey(int position) {
        return STATE_PAGE_KEY_PREFIX + position;
    }
}

