/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget.list;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import cc.livvy.framework.data.model.DataItem;
import cc.livvy.framework.data.model.DataResult;
import cc.livvy.framework.util.DeviceUtil;
import cc.livvy.framework.widget.list.DataListAdapter;
import cc.livvy.framework.widget.repeater.DataAdapter;
import cc.livvy.framework.widget.repeater.DataCellSelector;
import cc.livvy.framework.widget.repeater.DataLoader;
import cc.livvy.framework.widget.repeater.DataView;
import cc.livvy.framework.widget.repeater.OnDataLoadFinishListener;
import cc.livvy.framework.widget.repeater.OnDataRefreshedListener;

public class DataListView
extends ListView
implements DataView {
    protected DataListAdapter mDataAdapter = null;
    protected boolean mEnableAutoHeight = false;
    private int mListViewMaxItemCount = 0;
    private boolean mAllowAutoTurnPage = false;
    private boolean mListViewEnableScroll = true;
    private long mLastAutoTurnPageTime = 0L;
    protected int mListViewScrollState;
    private AbsListView.OnScrollListener mOnScrollListener;

    public DataListView(Context context) {
        super(context);
        this.init(context);
    }

    public DataListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
        this.init(context);
    }

    public DataListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttrs(context, attrs);
        this.init(context);
    }

    protected void initAttrs(Context context, AttributeSet attrs) {
    }

    protected void init(Context context) {
        this.setDividerHeight(0);
        this.setFooterDividersEnabled(false);
        this.setCacheColorHint(Color.parseColor((String)"#00000000"));
        DataListAdapter adapter = new DataListAdapter(this);
        this.setDataAdapter(adapter);
        this.initAutoTurnPageListener();
        adapter.initEditModeData();
    }

    public final void setEnableAutoHeight(boolean enable) {
        this.mEnableAutoHeight = enable;
    }

    public final void statusChangedNotify() {
        this.mDataAdapter.getDataLoadControl().statusChangedNotify();
    }

    public final boolean getEnableAutoHeight() {
        return this.mEnableAutoHeight;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener, boolean is_listview_real_listener) {
        if (is_listview_real_listener) {
            super.setOnItemClickListener(listener);
        } else {
            this.mDataAdapter.setOnItemClickListener(listener);
        }
    }

    public void setOnHeaderClickListener(AdapterView.OnItemClickListener listener) {
        this.mDataAdapter.setOnHeaderClickListener(listener);
    }

    public void setOnFooterClickListener(AdapterView.OnItemClickListener listener) {
        this.mDataAdapter.setOnFooterClickListener(listener);
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        this.setOnItemClickListener(listener, false);
    }

    public void setDataListViewOnScrollListener(AbsListView.OnScrollListener listener) {
        this.mOnScrollListener = listener;
    }

    public void setPageSize(int size) {
        this.mDataAdapter.getDataLoadControl().setPageSize(size);
    }

    public void setDataLoadFinishListener(OnDataLoadFinishListener listener) {
        this.mDataAdapter.setOnDataLoadFinishListener(listener);
    }

    public final void appendData(DataResult result) {
        this.mDataAdapter.getDataLoadControl().appendDataAndRefreshView(result, true);
    }

    public final void calculateCurrentPage() {
        this.mDataAdapter.getDataLoadControl().calculateCurrentPage();
    }

    public final void setEmptyCellClass(Class<?> cls, Object cellClassConstructorParameter) {
        this.mDataAdapter.mEmptyOrganizer.setCellClass(cls, cellClassConstructorParameter);
    }

    public final void setEmptyCellClass(Class<?> cls) {
        this.setEmptyCellClass(cls, null);
    }

    public final void setErrorCellClass(Class<?> cls, Object cellClassConstructorParameter) {
        this.mDataAdapter.mErrorOrganizer.setCellClass(cls, cellClassConstructorParameter);
    }

    public final void setErrorCellClass(Class<?> cls) {
        this.setErrorCellClass(cls, null);
    }

    public final void setMoreCellClass(Class<?> cls, Object cellClassConstructorParameter) {
        this.mDataAdapter.mMoreOrganizer.setCellClass(cls, cellClassConstructorParameter);
    }

    public final void setMoreCellClass(Class<?> cls) {
        this.setMoreCellClass(cls, null);
    }

    public final void setLoadingCellClass(Class<?> cls, Object cellClassConstructorParameter) {
        this.mDataAdapter.mLoadingOrganizer.setCellClass(cls, cellClassConstructorParameter);
    }

    public final void setLoadingCellClass(Class<?> cls) {
        this.setLoadingCellClass(cls, null);
    }

    public final void autoSetHeight() {
        int totalHeight = 0;
        int dataCount = this.mDataAdapter.getCount();
        int itemWidth = this.getWidth();
        if (itemWidth < 1) {
            itemWidth = DeviceUtil.getScreenPixelsWidth();
        }
        for (int i = 0; i < dataCount; ++i) {
            try {
                View listItem = this.mDataAdapter.getView(i, null, (ViewGroup)this);
                try {
                    ViewGroup.LayoutParams params = listItem.getLayoutParams();
                    if (null == params) {
                        if (listItem instanceof LinearLayout) {
                            listItem.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(itemWidth, -1));
                        } else if (listItem instanceof RelativeLayout) {
                            listItem.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(itemWidth, -1));
                        }
                    } else {
                        params.width = itemWidth;
                        listItem.setLayoutParams(params);
                    }
                }
                catch (Throwable params) {
                    // empty catch block
                }
                listItem.measure(0, 0);
                int height = listItem.getMeasuredHeight();
                totalHeight += height;
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ViewGroup.LayoutParams params = this.getLayoutParams();
        params.height = totalHeight + this.getDividerHeight() * dataCount;
        this.setLayoutParams(params);
    }

    public void setAllowAutoTurnPage(boolean allow) {
        this.mAllowAutoTurnPage = allow;
    }

    private void tryAutoTurnPage() {
        if (!this.mAllowAutoTurnPage) {
            return;
        }
        long curTime = System.currentTimeMillis();
        if (curTime - this.mLastAutoTurnPageTime < 500L) {
            return;
        }
        this.mLastAutoTurnPageTime = curTime;
        if (!this.mDataAdapter.getDataLoadControl().getDataLoadNoError()) {
            return;
        }
        if (this.mDataAdapter.getDataLoadControl().getDataLoadCompleted()) {
            return;
        }
        this.mDataAdapter.prepareToLoadData();
    }

    public void restoreStateFromBundle(Bundle bundle) {
        this.mDataAdapter.restoreStateFromBundle(bundle);
    }

    public void saveStateToBundle(Bundle bundle) {
        this.mDataAdapter.saveStateToBundle(bundle);
    }

    void initAutoTurnPageListener() {
        this.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView listView, int state) {
                DataListView.this.mListViewScrollState = state;
                if (null != DataListView.this.mOnScrollListener) {
                    DataListView.this.mOnScrollListener.onScrollStateChanged(listView, state);
                }
                if (DataListView.this.mListViewMaxItemCount >= DataListView.this.getDataCount() && 0 == state) {
                    DataListView.this.tryAutoTurnPage();
                }
                if (state == 0) {
                    DataListView.this.listViewStateIdle();
                } else if (state == 1) {
                    DataListView.this.listViewStateTouchScroll();
                } else if (state == 2) {
                    DataListView.this.listViewStateFling();
                }
            }

            public void onScroll(AbsListView listView, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                DataListView.this.doScrollAction(listView, DataListView.this.mListViewScrollState);
                if (null != DataListView.this.mOnScrollListener) {
                    DataListView.this.mOnScrollListener.onScroll(listView, firstVisibleItem, visibleItemCount, totalItemCount);
                }
                if (firstVisibleItem + visibleItemCount >= totalItemCount) {
                    DataListView.this.tryAutoTurnPage();
                } else {
                    DataListView.this.mListViewMaxItemCount = firstVisibleItem + visibleItemCount;
                }
            }
        });
    }

    public void doScrollAction(AbsListView listView, int scrollState) {
    }

    public boolean getScrollEnable() {
        return this.mListViewEnableScroll;
    }

    public DataListView setKeepDataWhenOnRefresh(boolean keepData) {
        if (null != this.mDataAdapter) {
            this.mDataAdapter.getDataLoadControl().setKeepDataWhenOnRefresh(keepData);
        }
        return this;
    }

    public void setScrollEnable(boolean enable) {
        this.mListViewEnableScroll = enable;
        if (this.mListViewEnableScroll) {
            this.setOnTouchListener(null);
        } else {
            this.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    return event.getAction() == 2;
                }
            });
        }
    }

    public void setOnRefreshedListener(OnDataRefreshedListener listener) {
        this.mDataAdapter.getDataLoadControl().setOnDataRefreshedListener(listener);
    }

    protected void listViewStateIdle() {
    }

    protected void listViewStateTouchScroll() {
    }

    protected void listViewStateFling() {
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (gainFocus && previouslyFocusedRect != null) {
            ListAdapter listAdapter = this.getAdapter();
            int adapterCount = listAdapter.getCount();
            block0 : switch (direction) {
                case 130: {
                    for (int i = 0; i < adapterCount; ++i) {
                        if (!listAdapter.isEnabled(i)) continue;
                        this.setSelection(i);
                        break block0;
                    }
                    break;
                }
                case 33: {
                    for (int i = adapterCount - 1; i >= 0; --i) {
                        if (!listAdapter.isEnabled(i)) continue;
                        this.setSelection(i);
                        break block0;
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void setDataAdapter(DataAdapter adapter) {
        if (adapter instanceof DataListAdapter) {
            this.mDataAdapter = (DataListAdapter)adapter;
            this.setAdapter((ListAdapter)this.mDataAdapter);
        }
    }

    @Override
    public DataAdapter getDataAdapter() {
        return this.mDataAdapter;
    }

    @Override
    public DataItem getDataItem(int position) {
        return this.mDataAdapter.getDataItem(position);
    }

    @Override
    public int getDataCount() {
        return this.mDataAdapter.getDataCount();
    }

    @Override
    public DataResult getDataList() {
        return this.mDataAdapter.getDataList();
    }

    @Override
    public void setDataCellClass(Class<?> cls, Object cellClassConstructorParameter) {
        this.mDataAdapter.setDataCellClass(cls, cellClassConstructorParameter);
    }

    @Override
    public void setDataCellClass(Class<?> cls) {
        this.mDataAdapter.setDataCellClass(cls);
    }

    @Override
    public void setDataCellSelector(DataCellSelector selector, Object cellClassConstructorParameter) {
        this.mDataAdapter.setDataCellSelector(selector, cellClassConstructorParameter);
    }

    @Override
    public void setDataCellSelector(DataCellSelector selector) {
        this.mDataAdapter.setDataCellSelector(selector);
    }

    @Override
    public void setupData(DataResult result) {
        this.mDataAdapter.setupData(result);
    }

    @Override
    public void refreshData() {
        this.mLastAutoTurnPageTime = 0L;
        this.mDataAdapter.refreshData();
    }

    @Override
    public void prepareToLoadData() {
        this.mDataAdapter.prepareToLoadData();
    }

    @Override
    public DataLoader getDataLoader() {
        return this.mDataAdapter.getDataLoader();
    }

    @Override
    public void setDataLoader(DataLoader dataLoader, boolean autoStartLoadData) {
        this.mDataAdapter.setDataLoader(dataLoader, autoStartLoadData);
    }

    @Override
    public void notifySyncDataSet(boolean onlyStatusChanged) {
        this.mDataAdapter.notifyDataSetChanged();
    }

    @Override
    public void callEventsBeforeLoadData(@NonNull DataAdapter adapter) {
        this.setAllowAutoTurnPage(false);
    }

    @Override
    public void callEventsAfterLoadData(@NonNull DataAdapter adapter) {
        this.setAllowAutoTurnPage(true);
    }
}

