/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget.grid;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.SimpleAdapter;
import cc.livvy.framework.data.model.DataItem;
import cc.livvy.framework.data.model.DataResult;
import cc.livvy.framework.widget.grid.DataGridCellCenter;
import cc.livvy.framework.widget.grid.DataGridView;
import cc.livvy.framework.widget.repeater.DataAdapter;
import cc.livvy.framework.widget.repeater.DataCellOrganizer;
import cc.livvy.framework.widget.repeater.DataCellSelector;
import cc.livvy.framework.widget.repeater.DataLoadControl;
import cc.livvy.framework.widget.repeater.DataLoader;
import cc.livvy.framework.widget.repeater.DataView;
import cc.livvy.framework.widget.repeater.OnDataLoadFinishListener;

public class DataGridAdapter
extends SimpleAdapter
implements AdapterView.OnItemClickListener,
DataAdapter {
    private DataGridView mListView = null;
    private Context mContext = null;
    private DataLoadControl mDataControl = new DataLoadControl(this);
    protected final DataCellOrganizer mErrorOrganizer = DataGridCellCenter.errorOrganizer(this);
    protected final DataCellOrganizer mLoadingOrganizer = DataGridCellCenter.loadingOrganizer(this);
    protected final DataCellOrganizer mEmptyOrganizer = DataGridCellCenter.emptyOrganizer(this);
    protected final DataCellOrganizer mMoreOrganizer = DataGridCellCenter.moreOrganizer(this);
    protected final DataCellOrganizer mDataOrganizer = DataGridCellCenter.dataOrganizer(this);
    private AdapterView.OnItemClickListener mItemClickListener = null;
    private AdapterView.OnItemClickListener mHeaderClickListener = null;
    private AdapterView.OnItemClickListener mFooterClickListener = null;
    private OnDataLoadFinishListener<DataGridAdapter> mOnDataLoadFinishListener = null;
    private int mMaxDataCount = 0;
    private int mDataColumn = 1;

    public DataGridAdapter(DataGridView listView) {
        super(listView.getContext(), null, 0, null, null);
        this.mListView = listView;
        this.mListView.setOnItemClickListener(this);
        this.mContext = this.mListView.getContext();
        this.mDataColumn = this.mListView.getNumColumns();
    }

    public DataGridAdapter(Context context) {
        super(context, null, 0, null, null);
        this.mContext = context;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        this.mItemClickListener = listener;
    }

    public void setOnHeaderClickListener(AdapterView.OnItemClickListener listener) {
        this.mHeaderClickListener = listener;
    }

    public void setOnFooterClickListener(AdapterView.OnItemClickListener listener) {
        this.mFooterClickListener = listener;
    }

    public void restoreStateFromBundle(Bundle bundle) {
        if (null == bundle) {
            return;
        }
        DataResult listData = (DataResult)bundle.getParcelable("listData");
        if (null != listData) {
            this.mDataControl.appendDataAndRefreshView(listData, true);
            int selectedItemPosition = bundle.getInt("selectedItemPosition");
            if (selectedItemPosition > 0) {
                this.mListView.setSelection(selectedItemPosition);
            }
        }
    }

    public Bundle saveStateToBundle(Bundle bundle) {
        if (null == bundle) {
            bundle = new Bundle();
        }
        bundle.putParcelable("listData", (Parcelable)this.mDataControl.getDataList());
        bundle.putInt("selectedItemPosition", this.mListView.getSelectedItemPosition());
        return bundle;
    }

    public void setOnDataLoadFinishListener(OnDataLoadFinishListener listener) {
        this.mOnDataLoadFinishListener = listener;
    }

    private void calculateItemsCount() {
        if (this.mDataControl.getDataCount() < 1) {
            this.mMaxDataCount = 1;
            return;
        }
        if (this.mDataControl.getTotalCount() == this.mDataControl.getDataCount()) {
            this.mMaxDataCount = this.mDataControl.getTotalCount();
            return;
        }
        this.mMaxDataCount = this.mDataControl.getDataCount() + (this.mDataControl.getMaxPageCount() > this.mDataControl.getPageAt() ? 1 : 0);
    }

    private DataCellOrganizer getItemOrganizer(int position) {
        if (this.mDataControl.getDataCount() < 1) {
            if (this.mDataControl.getDataLoadProcessing() || !this.mDataControl.getDataHasSetup()) {
                return this.mLoadingOrganizer;
            }
            if (!this.mDataControl.getDataLoadNoError()) {
                return this.mErrorOrganizer;
            }
            if (this.mDataControl.getPageSize() * this.mDataControl.getPageAt() < this.mDataControl.getTotalCount()) {
                return this.mMoreOrganizer;
            }
            return this.mEmptyOrganizer;
        }
        if (position < this.mDataControl.getDataCount()) {
            return this.mDataOrganizer;
        }
        if (this.mDataControl.getDataLoadProcessing()) {
            return this.mLoadingOrganizer;
        }
        if (!this.mDataControl.getDataLoadNoError()) {
            return this.mErrorOrganizer;
        }
        return this.mMoreOrganizer;
    }

    public void notifyDataSetChanged() {
        this.calculateItemsCount();
        if (null != this.mListView) {
            super.notifyDataSetChanged();
        }
        if (null != this.mOnDataLoadFinishListener && this.mDataControl.getDataLoadCompleted()) {
            this.mOnDataLoadFinishListener.onLoadFinished(this);
        }
    }

    public void onItemClick(AdapterView<?> adapter, View viewGroup, int position, long id2) {
        if (null == this.mListView) {
            return;
        }
        if (position < this.mDataControl.getDataCount()) {
            if (null != this.mItemClickListener) {
                this.mItemClickListener.onItemClick(adapter, (View)this.mListView, position, id2);
            }
        } else if (!this.mDataControl.getDataLoadProcessing()) {
            this.prepareToLoadData();
        }
    }

    public int getCount() {
        return this.mMaxDataCount;
    }

    public Object getItem(int position) {
        return this.mDataControl.getDataItem(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        DataCellOrganizer organizer = this.getItemOrganizer(position);
        int startViewType = 0;
        if (!organizer.equals(this.mLoadingOrganizer)) {
            startViewType += this.mLoadingOrganizer.getCellTypeCount();
            if (!organizer.equals(this.mErrorOrganizer)) {
                startViewType += this.mErrorOrganizer.getCellTypeCount();
                if (!organizer.equals(this.mMoreOrganizer)) {
                    startViewType += this.mMoreOrganizer.getCellTypeCount();
                    if (!organizer.equals(this.mEmptyOrganizer)) {
                        startViewType += this.mEmptyOrganizer.getCellTypeCount();
                    }
                }
            }
        }
        return startViewType + organizer.getCellType(position);
    }

    public int getViewTypeCount() {
        return this.mLoadingOrganizer.getCellTypeCount() + this.mErrorOrganizer.getCellTypeCount() + this.mMoreOrganizer.getCellTypeCount() + this.mEmptyOrganizer.getCellTypeCount() + this.mDataOrganizer.getCellTypeCount();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        DataCellOrganizer organizer = this.getItemOrganizer(position);
        if (organizer.equals(this.mLoadingOrganizer) || organizer.equals(this.mErrorOrganizer) || organizer.equals(this.mMoreOrganizer) || organizer.equals(this.mEmptyOrganizer)) {
            this.mListView.setNumColumns(1);
        } else {
            this.mListView.setNumColumns(this.mDataColumn);
        }
        return organizer.getCellView(convertView, position);
    }

    @Override
    public DataView getDataView() {
        return this.mListView;
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public DataLoadControl getDataLoadControl() {
        return this.mDataControl;
    }

    @Override
    public DataItem getDataItem(int position) {
        return this.mDataControl.getDataItem(position);
    }

    @Override
    public int getDataCount() {
        return this.mDataControl.getDataCount();
    }

    @Override
    public DataResult getDataList() {
        return this.mDataControl.getDataList();
    }

    @Override
    public DataLoader getDataLoader() {
        return this.mDataControl.getDataLoader();
    }

    @Override
    public void setDataLoader(DataLoader dataLoader, boolean autoStartLoadData) {
        this.mDataControl.setDataLoader(dataLoader, autoStartLoadData);
    }

    @Override
    public void setDataCellClass(Class<?> cls, Object cellClassConstructorParameter) {
        this.mDataOrganizer.setCellClass(cls, cellClassConstructorParameter);
    }

    @Override
    public void setDataCellClass(Class<?> cls) {
        this.mDataOrganizer.setCellClass(cls, null);
    }

    @Override
    public void setDataCellSelector(DataCellSelector selector, Object cellClassConstructorParameter) {
        this.mDataOrganizer.setCellSelector(selector, cellClassConstructorParameter);
    }

    @Override
    public void setDataCellSelector(DataCellSelector selector) {
        this.mDataOrganizer.setCellSelector(selector, null);
    }

    @Override
    public void setupData(DataResult result) {
        this.mDataControl.getDataList().clear();
        this.mDataControl.appendDataAndRefreshView(result, true);
    }

    @Override
    public void refreshData() {
        this.mDataControl.refreshData();
    }

    @Override
    public void prepareToLoadData() {
        this.mDataControl.prepareToLoadData();
    }

    @Override
    public void notifySyncDataSet(boolean onlyStatusChanged) {
        if (null != this.mListView) {
            this.mListView.notifySyncDataSet(onlyStatusChanged);
        }
    }

    @Override
    public void initEditModeData() {
        if (null == this.mListView || !this.mListView.isInEditMode()) {
            return;
        }
        this.mDataControl.getDataList().clear();
        for (int i = 0; i < 4; ++i) {
            DataItem item = new DataItem();
            item.setString("title", "Item " + i);
            this.mDataControl.getDataList().addItem(item);
        }
        this.notifyDataSetChanged();
    }
}

