/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget.cycleview.view;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import cc.livvy.framework.widget.cycleview.adapter.CrystalPageAdapter;

public class CrystalLoopViewPager
extends ViewPager {
    ViewPager.OnPageChangeListener mOuterPageChangeListener;
    private CrystalPageAdapter mAdapter;
    private boolean isCanScroll = true;
    private int START_POSITION_MULTIPLE = 100;
    private boolean canLoop = true;
    private ViewPager.OnPageChangeListener onPageChangeListener = new ViewPager.OnPageChangeListener(){
        private float mPreviousPosition = -1.0f;

        public void onPageSelected(int position) {
            int realPosition = CrystalLoopViewPager.this.mAdapter.toRealPosition(position);
            if (this.mPreviousPosition != (float)realPosition) {
                this.mPreviousPosition = realPosition;
                if (CrystalLoopViewPager.this.mOuterPageChangeListener != null) {
                    CrystalLoopViewPager.this.mOuterPageChangeListener.onPageSelected(realPosition);
                }
            }
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            int realPosition = position;
            if (CrystalLoopViewPager.this.mOuterPageChangeListener != null) {
                if (realPosition != CrystalLoopViewPager.this.mAdapter.getRealCount() - 1) {
                    CrystalLoopViewPager.this.mOuterPageChangeListener.onPageScrolled(realPosition, positionOffset, positionOffsetPixels);
                } else if ((double)positionOffset > 0.5) {
                    CrystalLoopViewPager.this.mOuterPageChangeListener.onPageScrolled(0, 0.0f, 0);
                } else {
                    CrystalLoopViewPager.this.mOuterPageChangeListener.onPageScrolled(realPosition, 0.0f, 0);
                }
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (CrystalLoopViewPager.this.mOuterPageChangeListener != null) {
                CrystalLoopViewPager.this.mOuterPageChangeListener.onPageScrollStateChanged(state);
            }
        }
    };

    public void setAdapter(PagerAdapter adapter) {
        this.mAdapter = (CrystalPageAdapter)adapter;
        this.mAdapter.setCanLoop(this.canLoop);
        super.setAdapter((PagerAdapter)this.mAdapter);
        this.setCurrentItem(this.getFristItem(), false);
    }

    public int getFristItem() {
        return this.canLoop ? this.mAdapter.getRealCount() * this.START_POSITION_MULTIPLE : 0;
    }

    public boolean isCanScroll() {
        return this.isCanScroll;
    }

    public void setCanScroll(boolean isCanScroll) {
        this.isCanScroll = isCanScroll;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.isCanScroll) {
            return super.onTouchEvent(ev);
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.isCanScroll) {
            return super.onInterceptTouchEvent(ev);
        }
        return false;
    }

    public CrystalPageAdapter getAdapter() {
        return this.mAdapter;
    }

    public int getRealItem() {
        return this.mAdapter != null ? this.mAdapter.toRealPosition(super.getCurrentItem()) : 0;
    }

    public void setCurrentItem(int item) {
        super.setCurrentItem(item + this.mAdapter.getRealCount() * (this.canLoop ? this.START_POSITION_MULTIPLE : 1));
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mOuterPageChangeListener = listener;
    }

    public CrystalLoopViewPager(Context context) {
        super(context);
        this.init();
    }

    public CrystalLoopViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        super.setOnPageChangeListener(this.onPageChangeListener);
    }

    public boolean isCanLoop() {
        return this.canLoop;
    }

    public void setCanLoop(boolean canLoop) {
        this.canLoop = canLoop;
    }
}

