/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget.cycleview;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import cc.livvy.fragment.R;
import cc.livvy.framework.widget.cycleview.ViewPagerScroller;
import cc.livvy.framework.widget.cycleview.adapter.CrystalPageAdapter;
import cc.livvy.framework.widget.cycleview.adapter.CrystalViewHolderCreator;
import cc.livvy.framework.widget.cycleview.listener.CrystalPageChangeListener;
import cc.livvy.framework.widget.cycleview.listener.OnItemClickListener;
import cc.livvy.framework.widget.cycleview.view.CrystalLoopViewPager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class CrystalCycleView<T>
extends LinearLayout {
    private List<T> mDatas;
    private int[] page_indicatorId;
    private ArrayList<ImageView> mPointViews = new ArrayList();
    private CrystalPageChangeListener pageChangeListener;
    private ViewPager.OnPageChangeListener onPageChangeListener;
    private OnItemClickListener listener;
    private CrystalLoopViewPager viewPager;
    private ViewPagerScroller scroller;
    private ViewGroup loPageTurningPoint;
    private long autoTurningTime;
    private boolean turning;
    private boolean canTurn = false;
    private boolean manualPageable = true;
    private boolean canLoop = true;
    public static int SCROLLDURATIONDEFAULT = 800;
    private Handler timeHandler = new Handler();
    private Runnable adSwitchTask = new Runnable(){

        @Override
        public void run() {
            if (CrystalCycleView.this.viewPager != null && CrystalCycleView.this.turning) {
                int page = CrystalCycleView.this.viewPager.getCurrentItem() + 1;
                if (page >= CrystalCycleView.this.viewPager.getAdapter().getCount()) {
                    page = CrystalCycleView.this.viewPager.getFristItem();
                    CrystalCycleView.this.viewPager.setCurrentItem(page, false);
                } else {
                    CrystalCycleView.this.viewPager.setCurrentItem(page, true);
                }
                CrystalCycleView.this.timeHandler.postDelayed(CrystalCycleView.this.adSwitchTask, CrystalCycleView.this.autoTurningTime);
            }
        }
    };

    public CrystalCycleView(Context context) {
        this(context, null);
    }

    public CrystalCycleView(Context context, boolean canLoop) {
        this(context, null);
        this.canLoop = canLoop;
    }

    public CrystalCycleView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CrystalCycleView);
        this.canLoop = a.getBoolean(R.styleable.CrystalCycleView_canLoop, true);
        this.init(context);
    }

    private void init(Context context) {
        View hView = LayoutInflater.from((Context)context).inflate(R.layout.include_viewpager, (ViewGroup)this, true);
        this.viewPager = (CrystalLoopViewPager)hView.findViewById(R.id.cbLoopViewPager);
        this.loPageTurningPoint = (ViewGroup)hView.findViewById(R.id.loPageTurningPoint);
        this.initViewPagerScroll();
    }

    public CrystalCycleView setPages(CrystalViewHolderCreator holderCreator, List<T> datas) {
        this.mDatas = datas;
        this.viewPager.setCanLoop(this.canLoop);
        this.viewPager.setAdapter(new CrystalPageAdapter<T>(holderCreator, this.mDatas));
        if (this.page_indicatorId != null) {
            this.setPageIndicator(this.page_indicatorId);
        }
        return this;
    }

    public void notifyDataSetChanged() {
        this.viewPager.getAdapter().notifyDataSetChanged();
        if (this.page_indicatorId != null) {
            this.setPageIndicator(this.page_indicatorId);
        }
    }

    public CrystalCycleView setPointViewVisible(boolean visible) {
        this.loPageTurningPoint.setVisibility(visible ? 0 : 8);
        return this;
    }

    public CrystalCycleView setPageIndicator(int[] page_indicatorId) {
        this.loPageTurningPoint.removeAllViews();
        this.mPointViews.clear();
        this.page_indicatorId = page_indicatorId;
        if (this.mDatas == null) {
            return this;
        }
        for (int count = 0; count < this.mDatas.size(); ++count) {
            ImageView pointView = new ImageView(this.getContext());
            pointView.setPadding(5, 0, 5, 0);
            if (this.mPointViews.isEmpty()) {
                pointView.setImageResource(page_indicatorId[1]);
            } else {
                pointView.setImageResource(page_indicatorId[0]);
            }
            this.mPointViews.add(pointView);
            this.loPageTurningPoint.addView((View)pointView);
        }
        this.pageChangeListener = new CrystalPageChangeListener(this.mPointViews, page_indicatorId);
        this.viewPager.setOnPageChangeListener(this.pageChangeListener);
        this.pageChangeListener.onPageSelected(this.viewPager.getRealItem());
        if (this.onPageChangeListener != null) {
            this.pageChangeListener.setOnPageChangeListener(this.onPageChangeListener);
        }
        return this;
    }

    public CrystalCycleView setPageIndicatorAlign(PageIndicatorAlign align) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.loPageTurningPoint.getLayoutParams();
        layoutParams.addRule(9, align == PageIndicatorAlign.ALIGN_PARENT_LEFT ? -1 : 0);
        layoutParams.addRule(11, align == PageIndicatorAlign.ALIGN_PARENT_RIGHT ? -1 : 0);
        layoutParams.addRule(14, align == PageIndicatorAlign.CENTER_HORIZONTAL ? -1 : 0);
        this.loPageTurningPoint.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return this;
    }

    public boolean isTurning() {
        return this.turning;
    }

    public CrystalCycleView startTurning(long autoTurningTime) {
        if (this.turning) {
            this.stopTurning();
        }
        this.canTurn = true;
        this.autoTurningTime = autoTurningTime;
        this.turning = true;
        this.timeHandler.postDelayed(this.adSwitchTask, autoTurningTime);
        return this;
    }

    public void stopTurning() {
        this.turning = false;
        this.timeHandler.removeCallbacks(this.adSwitchTask);
    }

    public CrystalCycleView setPageTransformer(ViewPager.PageTransformer transformer) {
        this.viewPager.setPageTransformer(true, transformer);
        return this;
    }

    public CrystalCycleView setPageTransformer(Transformer transformer) {
        try {
            String pkName = ((Object)((Object)this)).getClass().getPackage().getName();
            this.viewPager.setPageTransformer(true, (ViewPager.PageTransformer)Class.forName(pkName + ".transforms." + transformer.getClassName()).newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    private void initViewPagerScroll() {
        try {
            Field mScroller = null;
            mScroller = ViewPager.class.getDeclaredField("mScroller");
            mScroller.setAccessible(true);
            this.scroller = new ViewPagerScroller(this.viewPager.getContext());
            mScroller.set((Object)this.viewPager, (Object)this.scroller);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public boolean isManualPageable() {
        return this.viewPager.isCanScroll();
    }

    public void setManualPageable(boolean manualPageable) {
        this.viewPager.setCanScroll(manualPageable);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 1 || action == 3 || action == 4) {
            if (this.canTurn) {
                this.startTurning(this.autoTurningTime);
            }
        } else if (action == 0 && this.canTurn) {
            this.stopTurning();
        }
        return super.dispatchTouchEvent(ev);
    }

    public int getCurrentItem() {
        if (this.viewPager != null) {
            return this.viewPager.getRealItem();
        }
        return -1;
    }

    public void setcurrentitem(int index) {
        if (this.viewPager != null) {
            this.viewPager.setCurrentItem(index);
        }
    }

    public ViewPager.OnPageChangeListener getOnPageChangeListener() {
        return this.onPageChangeListener;
    }

    public CrystalCycleView setOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        this.onPageChangeListener = onPageChangeListener;
        if (this.pageChangeListener != null) {
            this.pageChangeListener.setOnPageChangeListener(onPageChangeListener);
        } else {
            this.viewPager.setOnPageChangeListener(onPageChangeListener);
        }
        return this;
    }

    public boolean isCanLoop() {
        return this.viewPager.isCanLoop();
    }

    public CrystalCycleView setOnItemClickListener(OnItemClickListener onItemClickListener) {
        if (onItemClickListener == null) {
            this.viewPager.setOnClickListener(null);
            return this;
        }
        this.listener = onItemClickListener;
        this.viewPager.getAdapter().setOnItemClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CrystalCycleView.this.listener.onItemClick(CrystalCycleView.this.getCurrentItem());
            }
        });
        return this;
    }

    public void setScrollDuration(int scrollDuration) {
        this.scroller.setScrollDuration(scrollDuration);
    }

    public int getScrollDuration() {
        return this.scroller.getScrollDuration();
    }

    public static enum Transformer {
        DefaultTransformer("DefaultTransformer"),
        AccordionTransformer("AccordionTransformer"),
        BackgroundToForegroundTransformer("BackgroundToForegroundTransformer"),
        CubeInTransformer("CubeInTransformer"),
        CubeOutTransformer("CubeOutTransformer"),
        DepthPageTransformer("DepthPageTransformer"),
        FlipHorizontalTransformer("FlipHorizontalTransformer"),
        FlipVerticalTransformer("FlipVerticalTransformer"),
        ForegroundToBackgroundTransformer("ForegroundToBackgroundTransformer"),
        RotateDownTransformer("RotateDownTransformer"),
        RotateUpTransformer("RotateUpTransformer"),
        StackTransformer("StackTransformer"),
        TabletTransformer("TabletTransformer"),
        ZoomInTransformer("ZoomInTransformer"),
        ZoomOutSlideTransformer("ZoomOutSlideTransformer"),
        ZoomOutTranformer("ZoomOutTranformer");

        private final String className;

        private Transformer(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }
    }

    public static enum PageIndicatorAlign {
        ALIGN_PARENT_LEFT,
        ALIGN_PARENT_RIGHT,
        CENTER_HORIZONTAL;

    }
}

