/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;

public class RecyclerView
extends android.support.v7.widget.RecyclerView {
    private OnLackDataListener onLackDataListener;
    private RecyclerView.OnScrollListener onScrollListener;
    private RecyclerView.OnScrollListener onScrollDefaultListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(android.support.v7.widget.RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            if (RecyclerView.this.onScrollListener != null) {
                RecyclerView.this.onScrollListener.onScrollStateChanged(recyclerView, newState);
            }
        }

        public void onScrolled(android.support.v7.widget.RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            if (RecyclerView.this.onLackDataListener != null) {
                try {
                    LinearLayoutManager manager = (LinearLayoutManager)RecyclerView.this.getLayoutManager();
                    if (manager.findLastVisibleItemPosition() >= manager.getItemCount() - RecyclerView.this.onLackDataListener.minNumber() && dy > 0 && !RecyclerView.this.onLackDataListener.isLoading()) {
                        RecyclerView.this.onLackDataListener.onLackData();
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("this RecyclerView's LayoutManager isn't a LinearLayoutManager.");
                }
            }
            if (RecyclerView.this.onScrollListener != null) {
                RecyclerView.this.onScrollListener.onScrolled(recyclerView, dx, dy);
            }
        }
    };

    public RecyclerView(Context context) {
        this(context, null);
    }

    public RecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        super.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        super.addOnScrollListener(this.onScrollDefaultListener);
    }

    public void setOnLackDataListener(OnLackDataListener onLackDataListener) {
        this.onLackDataListener = onLackDataListener;
    }

    public void setOnScrollListener(RecyclerView.OnScrollListener onScrollListener) {
        this.onScrollListener = onScrollListener;
    }

    public static interface OnLackDataListener {
        public void onLackData();

        public boolean isLoading();

        public int minNumber();
    }
}

