/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import cc.livvy.framework.util.DeviceUtil;

public class AlertDialog {
    private final int MATCH_PARENT = -1;
    private final int WRAP_CONTENT = -2;
    private final int radius = 8;
    private final float[] outerR = new float[]{8.0f, 8.0f, 8.0f, 8.0f, 8.0f, 8.0f, 8.0f, 8.0f};
    private String title = "\u6807\u9898\u6587\u5b57\u53ef\u4f7f\u7528setTitle()\u8bbe\u7f6e";
    private String cancelTitle = "\u53d6\u6d88";
    private String actionTitle = "\u6267\u884c";
    private boolean canceledOnTouchOutside = true;
    private Context context;
    private android.app.AlertDialog dialog;
    private Typeface typeface;
    private float scale;
    private int screenWidth;
    private TextView titleTextView;
    private Button cancelButton;
    private Button actionButton;
    private View.OnClickListener cancelClickListener;
    private View.OnClickListener actionClickListener;
    private int backgroundColor = Color.parseColor((String)"#FFFFFFFF");
    private int titleColor = Color.parseColor((String)"#CC444444");
    private int lineHorizontalColor = Color.parseColor((String)"#55888888");
    private int lineVerticalColor = Color.parseColor((String)"#55888888");
    private int cancelTitleColor = Color.parseColor((String)"#CC444444");
    private int actionTitleColor = Color.parseColor((String)"#CC444444");
    private int cancelBackgroundColor = Color.parseColor((String)"#00000000");
    private int actionBackgroundColor = Color.parseColor((String)"#00000000");

    public AlertDialog(Context context) {
        this.context = context;
        this.scale = context.getResources().getDisplayMetrics().density;
        this.screenWidth = ((Activity)context).getWindowManager().getDefaultDisplay().getWidth();
    }

    public AlertDialog setTitle(String title) {
        this.title = title;
        return this;
    }

    public AlertDialog setTypeface(Typeface typeface) {
        this.typeface = typeface;
        return this;
    }

    public AlertDialog setCancelButton(String title) {
        this.cancelTitle = title;
        return this;
    }

    public AlertDialog setActionTitleColor(int actionTitleColor) {
        this.actionTitleColor = actionTitleColor;
        return this;
    }

    public AlertDialog setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public AlertDialog setTitleColor(int titleColor) {
        this.titleColor = titleColor;
        return this;
    }

    public AlertDialog setLineHorizontalColor(int lineHorizontalColor) {
        this.lineHorizontalColor = lineHorizontalColor;
        return this;
    }

    public AlertDialog setLineVerticalColor(int lineVerticalColor) {
        this.lineVerticalColor = lineVerticalColor;
        return this;
    }

    public AlertDialog setCancelTitleColor(int cancelTitleColor) {
        this.cancelTitleColor = cancelTitleColor;
        return this;
    }

    public AlertDialog setCancelBackgroundColor(int cancelBackgroundColor) {
        this.cancelBackgroundColor = cancelBackgroundColor;
        return this;
    }

    public AlertDialog setActionBackgroundColor(int actionBackgroundColor) {
        this.actionBackgroundColor = actionBackgroundColor;
        return this;
    }

    public AlertDialog setCancelButton(String title, View.OnClickListener listener) {
        this.cancelTitle = title;
        this.cancelClickListener = listener;
        return this;
    }

    public AlertDialog setActionButton(String title, View.OnClickListener listener) {
        this.actionTitle = title;
        this.actionClickListener = listener;
        return this;
    }

    public void show() {
        this.dialog = new AlertDialog.Builder(this.context).create();
        RoundRectShape roundRectShape = new RoundRectShape(this.outerR, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)roundRectShape);
        shapeDrawable.getPaint().setColor(this.backgroundColor);
        shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
        final LinearLayout windowLayout = new LinearLayout(this.context);
        windowLayout.setLayoutParams((ViewGroup.LayoutParams)this.getParams(-1, -2));
        windowLayout.setOrientation(1);
        windowLayout.setBackgroundDrawable((Drawable)shapeDrawable);
        windowLayout.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(AlertDialog.this.screenWidth - AlertDialog.this.dp2px(60.0f), -2);
                params.leftMargin = AlertDialog.this.dp2px(20.0f);
                params.rightMargin = AlertDialog.this.dp2px(20.0f);
                windowLayout.setLayoutParams((ViewGroup.LayoutParams)params);
                windowLayout.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                return false;
            }
        });
        this.titleTextView = new TextView(this.context);
        if (DeviceUtil.getDeviceScreen(this.context) >= 720) {
            this.titleTextView.setLayoutParams((ViewGroup.LayoutParams)this.getParams(-1, this.dp2px(120.0f)));
        } else {
            this.titleTextView.setLayoutParams((ViewGroup.LayoutParams)this.getParams(-1, this.dp2px(100.0f)));
        }
        this.titleTextView.setTextColor(this.titleColor);
        this.titleTextView.setGravity(17);
        this.titleTextView.setTextSize(16.0f);
        this.titleTextView.setText((CharSequence)this.title);
        View lineHorizontal = new View(this.context);
        lineHorizontal.setLayoutParams((ViewGroup.LayoutParams)this.getParams(-1, this.dp2px(0.5f)));
        lineHorizontal.setBackgroundColor(this.lineHorizontalColor);
        LinearLayout buttonLayout = new LinearLayout(this.context);
        if (DeviceUtil.getDeviceScreen(this.context) >= 720) {
            buttonLayout.setLayoutParams((ViewGroup.LayoutParams)this.getParams(-1, this.dp2px(52.0f)));
        } else {
            buttonLayout.setLayoutParams((ViewGroup.LayoutParams)this.getParams(-1, this.dp2px(40.0f)));
        }
        buttonLayout.setOrientation(0);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.dp2px(0.0f), -1, 1.0f);
        this.cancelButton = new Button(this.context);
        this.cancelButton.setLayoutParams((ViewGroup.LayoutParams)params);
        this.cancelButton.setTextColor(this.cancelTitleColor);
        this.cancelButton.setTextSize(16.0f);
        this.cancelButton.setText((CharSequence)this.cancelTitle);
        this.cancelButton.setBackgroundColor(this.cancelBackgroundColor);
        if (this.cancelClickListener == null) {
            this.cancelButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    AlertDialog.this.dialog.dismiss();
                }
            });
        } else {
            this.cancelButton.setOnClickListener(this.cancelClickListener);
        }
        View lineVertical = new View(this.context);
        lineVertical.setLayoutParams((ViewGroup.LayoutParams)this.getParams(this.dp2px(0.5f), -1));
        lineVertical.setBackgroundColor(this.lineVerticalColor);
        this.actionButton = new Button(this.context);
        this.actionButton.setLayoutParams((ViewGroup.LayoutParams)params);
        this.actionButton.setTextColor(this.actionTitleColor);
        this.actionButton.setTextSize(16.0f);
        this.actionButton.setText((CharSequence)this.actionTitle);
        this.actionButton.setBackgroundColor(this.actionBackgroundColor);
        if (this.actionClickListener == null) {
            this.actionButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Toast.makeText((Context)AlertDialog.this.context, (CharSequence)"\u672a\u8bbe\u7f6e\u52a8\u4f5c", (int)0).show();
                }
            });
        } else {
            this.actionButton.setOnClickListener(this.actionClickListener);
        }
        buttonLayout.addView((View)this.cancelButton);
        buttonLayout.addView(lineVertical);
        buttonLayout.addView((View)this.actionButton);
        windowLayout.addView((View)this.titleTextView);
        windowLayout.addView(lineHorizontal);
        windowLayout.addView((View)buttonLayout);
        if (this.typeface != null) {
            this.titleTextView.setTypeface(this.typeface);
            this.cancelButton.setTypeface(this.typeface);
            this.actionButton.setTypeface(this.typeface);
        }
        this.dialog.setCanceledOnTouchOutside(this.canceledOnTouchOutside);
        this.dialog.show();
        this.dialog.setContentView((View)windowLayout);
    }

    private LinearLayout.LayoutParams getParams(int width, int height) {
        return new LinearLayout.LayoutParams(width, height);
    }

    private int dp2px(float dp) {
        return (int)(dp * this.scale + 0.5f);
    }

    public void dismiss() {
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
    }

    public boolean isCanceledOnTouchOutside() {
        return this.canceledOnTouchOutside;
    }

    public void setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
        this.canceledOnTouchOutside = canceledOnTouchOutside;
    }
}

