/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.format.Formatter;
import android.util.DisplayMetrics;
import android.util.Log;
import cc.livvy.framework.base.BaseApp;
import cc.livvy.framework.util.Md5;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceUtil {
    public static final int SCREEN_240P = 240;
    public static final int SCREEN_360P = 360;
    public static final int SCREEN_480P = 480;
    public static final int SCREEN_720P = 720;
    public static final int SCREEN_1080P = 1080;
    public static final int SCREEN_1280P = 1280;
    private static String mDeviceUUID = null;
    private static String mDeviceUDID = null;

    public static String getOSMainVersion() {
        int version = Build.VERSION.SDK_INT;
        switch (version) {
            case 1: {
                return "1.0";
            }
            case 2: {
                return "1.1";
            }
            case 3: {
                return "1.5";
            }
            case 4: {
                return "1.6";
            }
            case 5: {
                return "2.0";
            }
            case 6: {
                return "2.0.1";
            }
            case 7: {
                return "2.1";
            }
            case 8: {
                return "2.2";
            }
            case 9: {
                return "2.3";
            }
        }
        return Build.VERSION.RELEASE;
    }

    public static int getDeviceScreen(Context context) {
        DisplayMetrics dm = null;
        dm = context.getResources().getDisplayMetrics();
        if (dm == null) {
            return -1;
        }
        int screenWidth = dm.widthPixels;
        if (screenWidth <= 240) {
            return 240;
        }
        if (screenWidth > 240 && screenWidth <= 360) {
            return 360;
        }
        if (screenWidth > 360 && screenWidth <= 480) {
            return 480;
        }
        if (screenWidth > 480 && screenWidth <= 720) {
            return 720;
        }
        if (screenWidth > 720 && screenWidth <= 1080) {
            return 1080;
        }
        return 1280;
    }

    public static String getImeiID() {
        String imeiID;
        try {
            TelephonyManager telephonyManager = (TelephonyManager)BaseApp.getAppContext().getSystemService("phone");
            imeiID = telephonyManager.getDeviceId();
        }
        catch (Throwable e) {
            imeiID = "";
        }
        return imeiID == null ? "" : imeiID;
    }

    public static String getSubscriberId() {
        String IMSI;
        try {
            TelephonyManager telephonyManager = (TelephonyManager)BaseApp.getAppContext().getSystemService("phone");
            if (null == telephonyManager) {
                return "";
            }
            IMSI = telephonyManager.getSubscriberId();
            if (null == IMSI || "".equals(IMSI)) {
                return "";
            }
        }
        catch (Throwable e) {
            IMSI = "";
        }
        return IMSI;
    }

    public static String getAndroidID() {
        String Android_ID;
        try {
            Android_ID = Settings.Secure.getString((ContentResolver)BaseApp.getAppContext().getContentResolver(), (String)"android_id");
        }
        catch (Throwable e) {
            Android_ID = "";
        }
        return Android_ID == null ? "" : Android_ID;
    }

    public static synchronized String getUDID() {
        if (null == mDeviceUDID) {
            Matcher matcher;
            mDeviceUDID = DeviceUtil.getImeiID();
            if (mDeviceUDID.length() < 1) {
                mDeviceUDID = DeviceUtil.getAndroidID();
            }
            if (mDeviceUDID.length() < 1) {
                mDeviceUDID = DeviceUtil.getSubscriberId();
            }
            if ((mDeviceUDID = mDeviceUDID.trim()).length() > 0 && (matcher = Pattern.compile("^0+$").matcher(mDeviceUDID)).find()) {
                mDeviceUDID = "";
            }
            if (mDeviceUDID.length() < 1) {
                mDeviceUDID = DeviceUtil.getLocalUUID();
            }
        }
        return mDeviceUDID;
    }

    public static synchronized String getLocalUUID() {
        String chk;
        String uuid;
        SharedPreferences sharedPreferences;
        try {
            sharedPreferences = BaseApp.getAppContext().getSharedPreferences("uuid", 0);
        }
        catch (Throwable e) {
            sharedPreferences = null;
        }
        if (null != sharedPreferences) {
            try {
                uuid = sharedPreferences.getString("uuid", "");
                if (!Pattern.matches("^AUTO_[0-9a-fA-F]{32}$", uuid)) {
                    uuid = null;
                } else {
                    chk = sharedPreferences.getString("chk", "");
                    if (!chk.equalsIgnoreCase(Md5.md5(uuid))) {
                        uuid = null;
                    }
                }
            }
            catch (Throwable e) {
                uuid = null;
            }
        } else {
            uuid = null;
        }
        if (null == uuid) {
            uuid = "AUTO_" + Md5.md5(UUID.randomUUID().toString() + "-" + UUID.randomUUID().toString() + "-" + UUID.randomUUID().toString() + "-" + UUID.randomUUID().toString());
            if (null != sharedPreferences) {
                chk = Md5.md5(uuid);
                try {
                    SharedPreferences.Editor editor = sharedPreferences.edit();
                    editor.putString("uuid", uuid);
                    editor.putString("chk", chk);
                    editor.commit();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return uuid;
    }

    public static synchronized String getUUID() {
        if (null == mDeviceUUID) {
            mDeviceUUID = Md5.md5(DeviceUtil.getUDID().getBytes());
        }
        return mDeviceUUID;
    }

    public static String getChannel(String fileName) {
        String channel;
        SharedPreferences sharedPreferences;
        try {
            sharedPreferences = BaseApp.getAppContext().getSharedPreferences("channel", 0);
        }
        catch (Throwable e) {
            sharedPreferences = null;
        }
        if (null != sharedPreferences) {
            channel = sharedPreferences.getString("channel", "");
            if (channel.equals("") && null != (channel = DeviceUtil.getFromAssets(fileName))) {
                try {
                    SharedPreferences.Editor editor = sharedPreferences.edit();
                    editor.putString("channel", channel);
                    editor.commit();
                }
                catch (Throwable throwable) {}
            }
        } else {
            channel = null;
        }
        return channel;
    }

    public static String getFromAssets(String fileName) {
        try {
            InputStreamReader inputReader = new InputStreamReader(BaseApp.getAppContext().getResources().getAssets().open(fileName));
            BufferedReader bufReader = new BufferedReader(inputReader);
            String line = "";
            String Result2 = "";
            while ((line = bufReader.readLine()) != null) {
                Result2 = Result2 + line;
            }
            return Result2;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static synchronized String getGUID() {
        String guid;
        block8: {
            SharedPreferences sharedPreferences;
            try {
                sharedPreferences = BaseApp.getAppContext().getSharedPreferences("guid", 0);
            }
            catch (Throwable e) {
                sharedPreferences = null;
            }
            if (null != sharedPreferences) {
                try {
                    guid = sharedPreferences.getString("guid", "");
                    if (!guid.equals("") || null == (guid = DeviceUtil.readFileData("guid.txt"))) break block8;
                    try {
                        SharedPreferences.Editor editor = sharedPreferences.edit();
                        editor.putString("guid", guid);
                        editor.commit();
                    }
                    catch (Throwable editor) {
                    }
                }
                catch (Throwable e) {
                    guid = null;
                }
            } else {
                guid = null;
            }
        }
        return guid;
    }

    public static void saveGuidToFile(String guid) {
        SharedPreferences sharedPreferences;
        try {
            sharedPreferences = BaseApp.getAppContext().getSharedPreferences("guid", 0);
        }
        catch (Throwable tx) {
            sharedPreferences = null;
        }
        if (null != sharedPreferences) {
            try {
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putString("guid", guid);
                editor.commit();
                DeviceUtil.writeFileData("guid.txt", guid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void writeFileData(String fileName, String message) {
        try {
            FileOutputStream fout = BaseApp.getAppContext().openFileOutput(fileName, 0);
            byte[] bytes = message.getBytes();
            fout.write(bytes);
            fout.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String readFileData(String fileName) {
        String res;
        try {
            FileInputStream fin = BaseApp.getAppContext().openFileInput(fileName);
            int length = fin.available();
            byte[] buffer = new byte[length];
            fin.read(buffer);
            res = buffer.toString();
            fin.close();
        }
        catch (Exception e) {
            res = null;
        }
        return res;
    }

    public static float getScreenScale() {
        return DeviceUtil.getScreenScale(BaseApp.getAppContext());
    }

    public static float getScreenScale(Context context) {
        try {
            return context.getResources().getDisplayMetrics().density;
        }
        catch (Throwable e) {
            return 1.0f;
        }
    }

    public static int px2sp(float pxValue) {
        return DeviceUtil.px2sp(BaseApp.getAppContext(), pxValue);
    }

    public static int px2sp(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int sp2px(float spValue) {
        return DeviceUtil.sp2px(BaseApp.getAppContext(), spValue);
    }

    public static int sp2px(Context context, float spValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(spValue * scale + 0.5f);
    }

    public static int dip2px(float dipValue) {
        return DeviceUtil.dip2px(BaseApp.getAppContext(), dipValue);
    }

    public static int dip2px(Context context, float dipValue) {
        return (int)(dipValue * DeviceUtil.getScreenScale(context) + 0.5f);
    }

    public static int px2dip(float pxValue) {
        return DeviceUtil.px2dip(BaseApp.getAppContext(), pxValue);
    }

    public static int px2dip(Context context, float pxValue) {
        return (int)(pxValue / DeviceUtil.getScreenDensity(context) + 0.5f);
    }

    public static int getScreenPixelsWidth() {
        return DeviceUtil.getScreenPixelsWidth(BaseApp.getAppContext());
    }

    public static int getScreenPixelsWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getScreenDpHeight() {
        float density = BaseApp.getAppContext().getResources().getDisplayMetrics().density;
        int height = BaseApp.getAppContext().getResources().getDisplayMetrics().heightPixels;
        return (int)Math.ceil((float)height / density);
    }

    public static int getScreenDpWidth() {
        return DeviceUtil.getScreenDpWidth(BaseApp.getAppContext());
    }

    public static int getScreenDpWidth(Context context) {
        float density = context.getResources().getDisplayMetrics().density;
        int width = context.getResources().getDisplayMetrics().widthPixels;
        return (int)Math.ceil((float)width / density);
    }

    public static int getScreenPixelsHeight() {
        return DeviceUtil.getScreenPixelsHeight(BaseApp.getAppContext());
    }

    public static int getScreenPixelsHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static float getScreenDensity() {
        return DeviceUtil.getScreenDensity(BaseApp.getAppContext());
    }

    public static float getScreenDensity(Context context) {
        try {
            return context.getResources().getDisplayMetrics().density;
        }
        catch (Throwable e) {
            return 1.0f;
        }
    }

    public static int getScreenDpi() {
        try {
            return BaseApp.getAppContext().getResources().getDisplayMetrics().densityDpi;
        }
        catch (Throwable e) {
            return 160;
        }
    }

    public static String getSimOperatorName() {
        TelephonyManager telManager = (TelephonyManager)BaseApp.getAppContext().getSystemService("phone");
        String imsi = telManager.getSubscriberId();
        if (imsi != null) {
            if (imsi.startsWith("46000") || imsi.startsWith("46002")) {
                return "ChinaMobile";
            }
            if (imsi.startsWith("46001")) {
                return "ChinaUnicom";
            }
            if (imsi.startsWith("46003")) {
                return "ChinaTelecom";
            }
        }
        return "unKnown";
    }

    public static String getNetType() {
        String strNetworkType = "";
        NetworkInfo networkInfo = ((ConnectivityManager)BaseApp.getAppContext().getSystemService("connectivity")).getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (networkInfo.getType() == 1) {
                strNetworkType = "WIFI";
            } else if (networkInfo.getType() == 0) {
                String _strSubTypeName = networkInfo.getSubtypeName();
                Log.e((String)"cocos2d-x", (String)("Network getSubtypeName : " + _strSubTypeName));
                int networkType = networkInfo.getSubtype();
                switch (networkType) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        strNetworkType = "2G";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        strNetworkType = "3G";
                        break;
                    }
                    case 13: {
                        strNetworkType = "4G";
                        break;
                    }
                    default: {
                        strNetworkType = _strSubTypeName.equalsIgnoreCase("TD-SCDMA") || _strSubTypeName.equalsIgnoreCase("WCDMA") || _strSubTypeName.equalsIgnoreCase("CDMA2000") ? "3G" : _strSubTypeName;
                    }
                }
                Log.e((String)"cocos2d-x", (String)("Network getSubtype : " + Integer.valueOf(networkType).toString()));
            }
        }
        Log.e((String)"cocos2d-x", (String)("Network Type : " + strNetworkType));
        return strNetworkType;
    }

    public static String getHostIp() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress().toString();
                }
            }
        }
        catch (SocketException ex) {
            return "\u83b7\u53d6\u5931\u8d25";
        }
        return "\u83b7\u53d6\u5931\u8d25";
    }

    public static String getDeviceType() {
        boolean isTablet;
        boolean bl = isTablet = (BaseApp.getAppContext().getResources().getConfiguration().screenLayout & 0xF) >= 3;
        if (isTablet) {
            return "pad";
        }
        return "phone";
    }

    public static String getDeviceMac() {
        WifiManager wifi = (WifiManager)BaseApp.getAppContext().getSystemService("wifi");
        WifiInfo info = wifi.getConnectionInfo();
        return info.getMacAddress();
    }

    public static long ip2int(String ip) {
        String[] items = ip.split("\\.");
        return Long.valueOf(items[0]) << 24 | Long.valueOf(items[1]) << 16 | Long.valueOf(items[2]) << 8 | Long.valueOf(items[3]);
    }

    public static String int2ip(long ipInt) {
        StringBuilder sb = new StringBuilder();
        sb.append(ipInt & 0xFFL).append(".");
        sb.append(ipInt >> 8 & 0xFFL).append(".");
        sb.append(ipInt >> 16 & 0xFFL).append(".");
        sb.append(ipInt >> 24 & 0xFFL);
        return sb.toString();
    }

    public static String getTotalMemory() {
        String str1 = "/proc/meminfo";
        long initial_memory = 0L;
        try {
            String[] arrayOfString;
            FileReader localFileReader = new FileReader(str1);
            BufferedReader localBufferedReader = new BufferedReader(localFileReader, 8192);
            String str2 = localBufferedReader.readLine();
            for (String num : arrayOfString = str2.split("\\s+")) {
                Log.i((String)str2, (String)(num + "\t"));
            }
            initial_memory = Integer.valueOf(arrayOfString[1]) * 1024;
            localBufferedReader.close();
        }
        catch (IOException e) {
            return "";
        }
        return Formatter.formatFileSize((Context)BaseApp.getAppContext(), (long)initial_memory);
    }
}

