/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.manager;

import android.app.Activity;
import cc.livvy.framework.util.AppUtil;
import java.util.Stack;

public class ActivityManager {
    private static String mActivityPath = "";
    private static Activity mCurActivity = null;
    private static final Stack<Activity> mActivityStack = new Stack();

    public static synchronized void setCurrentActivity(Activity activity) {
        mCurActivity = activity;
    }

    public static synchronized Activity getCurrentActivity() {
        return mCurActivity;
    }

    public static synchronized void finishAllActivities() {
        Activity curActivity;
        while (mActivityStack.size() >= 1 && (curActivity = (Activity)mActivityStack.lastElement()) != null) {
            curActivity.finish();
            mActivityStack.remove(curActivity);
        }
        ActivityManager.buildActivityPath();
    }

    public static synchronized void popToActivity(Class<?> cls) {
        Activity curActivity;
        if (null == cls) {
            return;
        }
        while (mActivityStack.size() >= 1 && (curActivity = (Activity)mActivityStack.lastElement()) != null && !curActivity.getClass().equals(cls)) {
            curActivity.finish();
            mActivityStack.remove(curActivity);
        }
        ActivityManager.buildActivityPath();
    }

    public static synchronized void popToActivity(Activity activity) {
        Activity curActivity;
        if (null == activity) {
            return;
        }
        while (mActivityStack.size() >= 1 && (curActivity = (Activity)mActivityStack.lastElement()) != null && !curActivity.equals(activity)) {
            curActivity.finish();
            mActivityStack.remove(curActivity);
        }
        ActivityManager.buildActivityPath();
    }

    public static synchronized String getActivityPath() {
        return mActivityPath;
    }

    private static synchronized void buildActivityPath() {
        if (mActivityStack.size() < 1) {
            mActivityPath = "/";
        } else {
            StringBuilder message = new StringBuilder();
            for (Activity x : mActivityStack) {
                message.append(String.format("/%s", AppUtil.getClassName(x)));
            }
            mActivityPath = message.toString();
        }
    }

    public static synchronized void pushActivity(Activity activity) {
        if (null == activity) {
            return;
        }
        if (mActivityStack.contains(activity)) {
            mActivityStack.remove(activity);
        }
        mActivityStack.add(activity);
        ActivityManager.buildActivityPath();
    }

    public static synchronized void popLastActivity(Class<?> cls) {
        Activity curActivity;
        if (null == cls) {
            return;
        }
        if (mActivityStack.size() < 1) {
            return;
        }
        while ((curActivity = (Activity)mActivityStack.lastElement()) != null && curActivity.getClass().equals(cls)) {
            curActivity.finish();
            mActivityStack.remove(curActivity);
        }
        ActivityManager.buildActivityPath();
    }

    public static synchronized void removeActivity(Activity activity) {
        if (mActivityStack.size() < 1 || null == activity) {
            return;
        }
        for (Activity x : mActivityStack) {
            if (!x.equals(activity)) continue;
            mActivityStack.remove(x);
            break;
        }
        ActivityManager.buildActivityPath();
    }

    public static synchronized Activity getTopTaskActivity() {
        if (mActivityStack.size() < 1) {
            return null;
        }
        return (Activity)mActivityStack.lastElement();
    }
}

