/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.http.request;

import cc.livvy.framework.http.OkHttpUtils;
import cc.livvy.framework.http.callback.Callback;
import cc.livvy.framework.http.request.OkHttpRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class RequestCall {
    private OkHttpRequest okHttpRequest;
    private Request request;
    private Call call;
    private long readTimeOut;
    private long writeTimeOut;
    private long connTimeOut;
    private OkHttpClient clone;

    public RequestCall(OkHttpRequest request) {
        this.okHttpRequest = request;
    }

    public RequestCall readTimeOut(long readTimeOut) {
        this.readTimeOut = readTimeOut;
        return this;
    }

    public RequestCall writeTimeOut(long writeTimeOut) {
        this.writeTimeOut = writeTimeOut;
        return this;
    }

    public RequestCall connTimeOut(long connTimeOut) {
        this.connTimeOut = connTimeOut;
        return this;
    }

    public Call generateCall(Callback callback) {
        this.request = this.generateRequest(callback);
        if (this.readTimeOut > 0L || this.writeTimeOut > 0L || this.connTimeOut > 0L) {
            this.cloneClient();
            this.readTimeOut = this.readTimeOut > 0L ? this.readTimeOut : 10000L;
            this.writeTimeOut = this.writeTimeOut > 0L ? this.writeTimeOut : 10000L;
            this.connTimeOut = this.connTimeOut > 0L ? this.connTimeOut : 10000L;
            this.clone.setReadTimeout(this.readTimeOut, TimeUnit.MILLISECONDS);
            this.clone.setWriteTimeout(this.writeTimeOut, TimeUnit.MILLISECONDS);
            this.clone.setConnectTimeout(this.connTimeOut, TimeUnit.MILLISECONDS);
            this.call = this.clone.newCall(this.request);
        } else {
            this.call = OkHttpUtils.getInstance().getOkHttpClient().newCall(this.request);
        }
        return this.call;
    }

    private Request generateRequest(Callback callback) {
        return this.okHttpRequest.generateRequest(callback);
    }

    public void execute(Callback callback) {
        this.generateCall(callback);
        if (callback != null) {
            callback.onBefore(this.request);
        }
        OkHttpUtils.getInstance().execute(this, callback);
    }

    public Call getCall() {
        return this.call;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response execute() throws IOException {
        this.generateCall(null);
        return this.call.execute();
    }

    private void cloneClient() {
        this.clone = OkHttpUtils.getInstance().getOkHttpClient().clone();
    }

    public void cancel() {
        if (this.call != null) {
            this.call.cancel();
        }
    }
}

