/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.http.request;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.RequestBody;
import java.io.IOException;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class CountingRequestBody
extends RequestBody {
    protected RequestBody delegate;
    protected Listener listener;
    protected CountingSink countingSink;

    public CountingRequestBody(RequestBody delegate, Listener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    public MediaType contentType() {
        return this.delegate.contentType();
    }

    public long contentLength() {
        try {
            return this.delegate.contentLength();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public void writeTo(BufferedSink sink) throws IOException {
        this.countingSink = new CountingSink((Sink)sink);
        BufferedSink bufferedSink = Okio.buffer((Sink)this.countingSink);
        this.delegate.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    public static interface Listener {
        public void onRequestProgress(long var1, long var3);
    }

    protected final class CountingSink
    extends ForwardingSink {
        private long bytesWritten;

        public CountingSink(Sink delegate) {
            super(delegate);
            this.bytesWritten = 0L;
        }

        public void write(Buffer source, long byteCount) throws IOException {
            super.write(source, byteCount);
            this.bytesWritten += byteCount;
            CountingRequestBody.this.listener.onRequestProgress(this.bytesWritten, CountingRequestBody.this.contentLength());
        }
    }
}

