/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.http;

import android.os.Handler;
import android.os.Looper;
import cc.livvy.framework.base.BaseApp;
import cc.livvy.framework.http.builder.GetBuilder;
import cc.livvy.framework.http.builder.PostFileBuilder;
import cc.livvy.framework.http.builder.PostFormBuilder;
import cc.livvy.framework.http.builder.PostStringBuilder;
import cc.livvy.framework.http.callback.Callback;
import cc.livvy.framework.http.cookie.PersistentCookieStore;
import cc.livvy.framework.http.https.HttpsUtils;
import cc.livvy.framework.http.request.RequestCall;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;

public class OkHttpUtils {
    public static final long DEFAULT_MILLISECONDS = 10000L;
    private static OkHttpUtils mInstance;
    private OkHttpClient mOkHttpClient = new OkHttpClient();
    private Handler mDelivery;

    public OkHttpUtils() {
        if (BaseApp.getAppContext() != null) {
            this.mOkHttpClient.setCookieHandler((CookieHandler)new CookieManager(new PersistentCookieStore(BaseApp.getAppContext()), CookiePolicy.ACCEPT_ORIGINAL_SERVER));
        } else {
            this.mOkHttpClient.setCookieHandler((CookieHandler)new CookieManager(null, CookiePolicy.ACCEPT_ORIGINAL_SERVER));
        }
        this.mDelivery = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpUtils getInstance() {
        if (mInstance != null) return mInstance;
        Class<OkHttpUtils> clazz = OkHttpUtils.class;
        synchronized (OkHttpUtils.class) {
            if (mInstance != null) return mInstance;
            mInstance = new OkHttpUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public Handler getDelivery() {
        return this.mDelivery;
    }

    public OkHttpClient getOkHttpClient() {
        return this.mOkHttpClient;
    }

    public static GetBuilder get() {
        return new GetBuilder();
    }

    public static PostStringBuilder postString() {
        return new PostStringBuilder();
    }

    public static PostFileBuilder postFile() {
        return new PostFileBuilder();
    }

    public static PostFormBuilder post() {
        return new PostFormBuilder();
    }

    public void execute(final RequestCall requestCall, Callback callback) {
        if (callback == null) {
            callback = Callback.CALLBACK_DEFAULT;
        }
        final Callback finalCallback = callback;
        requestCall.getCall().enqueue(new com.squareup.okhttp.Callback(){

            public void onFailure(Request request, IOException e) {
                OkHttpUtils.this.sendFailResultCallback(request, e, finalCallback);
            }

            public void onResponse(Response response) {
                if (response.code() >= 400 && response.code() <= 599) {
                    try {
                        OkHttpUtils.this.sendFailResultCallback(requestCall.getRequest(), new RuntimeException(response.body().string()), finalCallback);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                try {
                    Object o = finalCallback.parseNetworkResponse(response);
                    OkHttpUtils.this.sendSuccessResultCallback(o, finalCallback);
                }
                catch (IOException e) {
                    OkHttpUtils.this.sendFailResultCallback(response.request(), e, finalCallback);
                }
            }
        });
    }

    public void sendFailResultCallback(final Request request, final Exception e, final Callback callback) {
        if (callback == null) {
            return;
        }
        this.mDelivery.post(new Runnable(){

            @Override
            public void run() {
                callback.onError(request, e);
                callback.onAfter();
            }
        });
    }

    public void sendSuccessResultCallback(final Object object, final Callback callback) {
        if (callback == null) {
            return;
        }
        this.mDelivery.post(new Runnable(){

            @Override
            public void run() {
                callback.onResponse(object);
                callback.onAfter();
            }
        });
    }

    public void cancelTag(Object tag) {
        this.mOkHttpClient.cancel(tag);
    }

    public void setCertificates(InputStream ... certificates) {
        HttpsUtils.setCertificates(this.getOkHttpClient(), certificates, null, null);
    }
}

