/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.data.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import cc.livvy.framework.data.encoding.UrlEncode;
import cc.livvy.framework.data.model.DataItemArray;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public final class DataItem
implements Parcelable {
    private static final int CURRENT_PARCEL_VERSION = 1;
    private final LinkedHashMap<String, Object> mNameValuePairs = new LinkedHashMap();
    public static final Parcelable.Creator<DataItem> CREATOR = new Parcelable.Creator<DataItem>(){

        public DataItem createFromParcel(Parcel in) {
            return new DataItem(in);
        }

        public DataItem[] newArray(int size) {
            return new DataItem[size];
        }
    };

    public DataItem() {
    }

    public DataItem(JSONObject jsonObject) {
        this.appendJSONObject(jsonObject);
    }

    public DataItem(Parcel in) {
        this.fromParcel(in);
    }

    public final boolean fromParcel(Parcel in) {
        try {
            int parcelVersion = in.readInt();
            if (parcelVersion != 1) {
                throw new Exception("DataItem.fromParcel(in): unkown parcel version: " + parcelVersion);
            }
            this.fromParcelV1(in);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public final Set<String> keySet() {
        return this.mNameValuePairs.keySet();
    }

    public boolean isEmpty() {
        return this.mNameValuePairs.size() < 1;
    }

    public String toUriString() {
        StringBuilder str = new StringBuilder();
        for (String key : this.mNameValuePairs.keySet()) {
            if (str.length() > 1) {
                str.append("&");
            }
            str.append(UrlEncode.encode(key));
            str.append("=");
            str.append(UrlEncode.encode(this.getString(key)));
        }
        return str.toString();
    }

    public byte[] toUriBytes() {
        String uriString = this.toUriString();
        return uriString.getBytes();
    }

    public DataItem makeCopy() {
        DataItem newCopy = new DataItem();
        for (String key : this.mNameValuePairs.keySet()) {
            Object newO = this.mNameValuePairs.get(key);
            if (newO instanceof DataItem) {
                newCopy.mNameValuePairs.put(key, ((DataItem)newO).makeCopy());
                continue;
            }
            if (newO instanceof DataItemArray) {
                newCopy.mNameValuePairs.put(key, ((DataItemArray)newO).makeCopy());
                continue;
            }
            newCopy.mNameValuePairs.put(key, newO);
        }
        return newCopy;
    }

    public synchronized DataItem syncDataFromKey(String fromKey, String toKey) {
        if (TextUtils.isEmpty((CharSequence)fromKey) || TextUtils.isEmpty((CharSequence)toKey) || fromKey.equals(toKey)) {
            return this;
        }
        if (!this.mNameValuePairs.containsKey(fromKey)) {
            this.mNameValuePairs.remove(toKey);
        } else {
            this.mNameValuePairs.put(toKey, this.mNameValuePairs.get(fromKey));
        }
        return this;
    }

    public Object remove(String name) {
        if (null == name || !this.mNameValuePairs.containsKey(name)) {
            return null;
        }
        return this.mNameValuePairs.remove(name);
    }

    public DataItem clear() {
        this.mNameValuePairs.clear();
        return this;
    }

    public double getDouble(String name) {
        if (null == name) {
            return 0.0;
        }
        Object object = this.mNameValuePairs.get(name);
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            try {
                return Double.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    public boolean setDouble(String name, double value) {
        if (null == name) {
            return false;
        }
        this.mNameValuePairs.put(name, value);
        return true;
    }

    public <T> T getObject(String name) {
        if (null == name) {
            return null;
        }
        Object object = this.mNameValuePairs.get(name);
        if (null != object) {
            try {
                return (T)object;
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }

    public boolean setObject(String name, Object object) {
        if (null == name || null == object) {
            return false;
        }
        this.mNameValuePairs.put(name, object);
        return true;
    }

    public long getLong(String name) {
        if (null == name) {
            return 0L;
        }
        Object object = this.mNameValuePairs.get(name);
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            try {
                return (long)Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public boolean setLong(String name, long value) {
        if (null == name) {
            return false;
        }
        this.mNameValuePairs.put(name, value);
        return true;
    }

    public DataItemArray getDataItemArray(String name) {
        if (null == name) {
            return null;
        }
        Object object = this.mNameValuePairs.get(name);
        if (object instanceof DataItemArray) {
            return (DataItemArray)object;
        }
        return null;
    }

    public boolean setDataItemArray(String name, DataItemArray value) {
        if (null == name || null == value) {
            return false;
        }
        this.mNameValuePairs.put(name, value);
        return true;
    }

    public DataItem getDataItem(String name) {
        if (null == name) {
            return null;
        }
        Object object = this.mNameValuePairs.get(name);
        if (object instanceof DataItem) {
            return (DataItem)object;
        }
        return null;
    }

    public boolean setDataItem(String name, DataItem value) {
        if (null == name || null == value) {
            return false;
        }
        this.mNameValuePairs.put(name, value);
        return true;
    }

    public boolean setString(String name, String value) {
        if (null == name) {
            return false;
        }
        if (null == value) {
            this.remove(name);
        } else {
            this.mNameValuePairs.put(name, value);
        }
        return true;
    }

    public boolean setInt(String name, int value) {
        if (null == name) {
            return false;
        }
        this.mNameValuePairs.put(name, value);
        return true;
    }

    public boolean setBool(String name, boolean value) {
        if (null == name) {
            return false;
        }
        this.mNameValuePairs.put(name, value);
        return true;
    }

    public int getInt(String name) {
        if (null == name) {
            return 0;
        }
        if (!this.mNameValuePairs.containsKey(name)) {
            return 0;
        }
        Object object = this.mNameValuePairs.get(name);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return (int)Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean containsKey(String key) {
        if (key == null) {
            return false;
        }
        return this.mNameValuePairs.containsKey(key);
    }

    public boolean getBool(String name) {
        if (null == name) {
            return false;
        }
        if (!this.mNameValuePairs.containsKey(name)) {
            return false;
        }
        Object object = this.mNameValuePairs.get(name);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            String stringValue = (String)object;
            return !TextUtils.isEmpty((CharSequence)stringValue) && !"false".equalsIgnoreCase(stringValue) && !"off".equalsIgnoreCase(stringValue) && !"0".equalsIgnoreCase(stringValue);
        }
        if (object instanceof Integer) {
            return (Integer)object != 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() != 0;
        }
        return false;
    }

    public boolean has(String name) {
        return !TextUtils.isEmpty((CharSequence)name) && this.mNameValuePairs.containsKey(name);
    }

    public boolean matches(String name, String value) {
        return !TextUtils.isEmpty((CharSequence)name) && null != value && this.mNameValuePairs.containsKey(name) && value.equals(this.getString(name));
    }

    public boolean matches(String name, boolean value) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        if (!this.mNameValuePairs.containsKey(name)) {
            return false;
        }
        return value == this.getBool(name);
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataItem)) {
            return false;
        }
        LinkedHashMap<String, Object> oNameValuePairs = ((DataItem)o).mNameValuePairs;
        if (oNameValuePairs.size() != this.mNameValuePairs.size()) {
            return false;
        }
        for (String key : this.mNameValuePairs.keySet()) {
            if (!oNameValuePairs.containsKey(key)) {
                return false;
            }
            Object oo = oNameValuePairs.get(key);
            Object om = this.mNameValuePairs.get(key);
            if (!oo.getClass().equals(om.getClass())) {
                return false;
            }
            if (oo.equals(om)) continue;
            return false;
        }
        return true;
    }

    public String getString(String name) {
        if (null == name) {
            return "";
        }
        if (!this.mNameValuePairs.containsKey(name)) {
            return "";
        }
        Object object = this.mNameValuePairs.get(name);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? "1" : "0";
        }
        if (object != null) {
            return String.valueOf(object);
        }
        return "";
    }

    public final int size() {
        return this.mNameValuePairs.size();
    }

    public DataItem append(DataItem item) {
        if (null != item) {
            for (String key : item.mNameValuePairs.keySet()) {
                this.mNameValuePairs.put(key, item.mNameValuePairs.get(key));
            }
        }
        return this;
    }

    public void Dump() {
        for (String key : this.mNameValuePairs.keySet()) {
            Log.v((String)"Dump", (String)("  [" + key + "] => " + this.mNameValuePairs.get(key).toString()));
        }
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    private void fromParcelV1(Parcel in) throws Throwable {
        int itemCount = in.readInt();
        block10: for (int i = 0; i < itemCount; ++i) {
            String key = in.readString();
            byte keyType = in.readByte();
            switch (keyType) {
                case 111: {
                    DataItem item = new DataItem();
                    if (!item.fromParcel(in)) {
                        throw new Exception("DataItem.fromParcelV1(in): read DataItem type error!");
                    }
                    this.mNameValuePairs.put(key, item);
                    continue block10;
                }
                case 97: {
                    DataItemArray items = new DataItemArray();
                    if (!items.fromParcel(in)) {
                        throw new Exception("DataItem.fromParcelV1(in): read DataItemArray type error!");
                    }
                    this.mNameValuePairs.put(key, items);
                    continue block10;
                }
                case 115: {
                    this.mNameValuePairs.put(key, in.readString());
                    continue block10;
                }
                case 108: {
                    this.mNameValuePairs.put(key, in.readLong());
                    continue block10;
                }
                case 105: {
                    this.mNameValuePairs.put(key, in.readInt());
                    continue block10;
                }
                case 100: {
                    this.mNameValuePairs.put(key, in.readDouble());
                    continue block10;
                }
                case 110: {
                    Number number = (Number)in.readSerializable();
                    this.mNameValuePairs.put(key, number);
                    continue block10;
                }
                case 98: {
                    Boolean bool = (Boolean)in.readSerializable();
                    this.mNameValuePairs.put(key, bool);
                    continue block10;
                }
                default: {
                    throw new Exception("DataItem.fromParcelV1(in): unkown value type: " + keyType);
                }
            }
        }
    }

    public byte[] toBytes() {
        byte[] data;
        try {
            Parcel out = Parcel.obtain();
            this.writeToParcel(out, 0);
            out.setDataPosition(0);
            data = out.marshall();
            out.recycle();
        }
        catch (Throwable e) {
            data = null;
        }
        return data;
    }

    public static DataItem fromJSONString(String jsonString) {
        DataItem item = new DataItem();
        item.appendJSONString(jsonString);
        return item;
    }

    public static DataItem fromBytes(byte[] bytesData) {
        if (null == bytesData) {
            return new DataItem();
        }
        try {
            Parcel in = Parcel.obtain();
            in.unmarshall(bytesData, 0, bytesData.length);
            in.setDataPosition(0);
            return (DataItem)CREATOR.createFromParcel(in);
        }
        catch (Throwable throwable) {
            return new DataItem();
        }
    }

    public final void appendJSONString(String jsonString) {
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            this.appendJSONObject(jsonObject);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void appendJSONObject(JSONObject jsonObject) {
        if (null != jsonObject) {
            Iterator iter = jsonObject.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object jo = jsonObject.opt(key);
                if (jo instanceof JSONObject) {
                    this.mNameValuePairs.put(key, new DataItem((JSONObject)jo));
                    continue;
                }
                if (jo instanceof JSONArray) {
                    this.mNameValuePairs.put(key, new DataItemArray((JSONArray)jo));
                    continue;
                }
                if (!(jo instanceof String) && !(jo instanceof Long) && !(jo instanceof Integer) && !(jo instanceof Double) && !(jo instanceof Number) && !(jo instanceof Boolean)) continue;
                this.mNameValuePairs.put(key, jo);
            }
        }
    }

    public final JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            for (String key : this.mNameValuePairs.keySet()) {
                Object jo = this.mNameValuePairs.get(key);
                if (jo instanceof DataItem) {
                    jsonObject.put(key, (Object)((DataItem)jo).toJSONObject());
                    continue;
                }
                if (jo instanceof DataItemArray) {
                    jsonObject.put(key, (Object)((DataItemArray)jo).toJSONArray());
                    continue;
                }
                if (!(jo instanceof String) && !(jo instanceof Long) && !(jo instanceof Integer) && !(jo instanceof Double) && !(jo instanceof Number) && !(jo instanceof Boolean)) continue;
                jsonObject.put(key, jo);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return jsonObject;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(1);
        dest.writeInt(this.mNameValuePairs.size());
        for (String key : this.mNameValuePairs.keySet()) {
            byte keyType;
            Object jo = this.mNameValuePairs.get(key);
            dest.writeString(key);
            if (jo instanceof DataItem) {
                keyType = 111;
                dest.writeByte(keyType);
                ((DataItem)jo).writeToParcel(dest, flags);
                continue;
            }
            if (jo instanceof DataItemArray) {
                keyType = 97;
                dest.writeByte(keyType);
                ((DataItemArray)jo).writeToParcel(dest, flags);
                continue;
            }
            if (jo instanceof String) {
                keyType = 115;
                dest.writeByte(keyType);
                dest.writeString((String)jo);
                continue;
            }
            if (jo instanceof Long) {
                keyType = 108;
                dest.writeByte(keyType);
                dest.writeLong(((Long)jo).longValue());
                continue;
            }
            if (jo instanceof Integer) {
                keyType = 105;
                dest.writeByte(keyType);
                dest.writeInt(((Integer)jo).intValue());
                continue;
            }
            if (jo instanceof Double) {
                keyType = 100;
                dest.writeByte(keyType);
                dest.writeDouble(((Double)jo).doubleValue());
                continue;
            }
            if (jo instanceof Number) {
                keyType = 110;
                dest.writeByte(keyType);
                dest.writeSerializable((Serializable)((Number)jo));
                continue;
            }
            if (jo instanceof Boolean) {
                keyType = 98;
                dest.writeByte(keyType);
                dest.writeSerializable((Serializable)((Boolean)jo));
                continue;
            }
            keyType = 115;
            dest.writeByte(keyType);
            dest.writeString("");
        }
    }
}

