/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.crash;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import android.widget.Toast;
import cc.livvy.framework.data.model.DataResult;
import cc.livvy.framework.http.UnifyHttpClient;
import cc.livvy.framework.manager.ActivityManager;
import cc.livvy.framework.util.AppUtil;
import cc.livvy.framework.util.CpuUtil;
import cc.livvy.framework.util.DeviceUtil;
import cc.livvy.framework.util.Md5;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = "CrashHandler";
    private static CrashHandler INSTANCE;
    private Context mContext;
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private HashMap<String, String> mInfos = new HashMap();
    private DateFormat mFormatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.CHINA);
    private String mCrashLogPath = "/sdcard/base/crashLog/";
    private boolean isUpload = false;
    protected String mCrashLogUrl = "http://192.168.1.97:8080/ekz-wkss/app/dt/crash";
    private HashMap<Object, Object> mCrashDeal;

    private CrashHandler() {
    }

    public static CrashHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CrashHandler();
        }
        return INSTANCE;
    }

    public void setCrashLogPath(String path) {
        if (path.equals("") || path.length() < 5) {
            Log.e((String)TAG, (String)"\u8f93\u51faCrashLog\u7684\u5730\u5740\u9519\u8bef");
            return;
        }
        this.mCrashLogPath = path;
    }

    public void init(Context context) {
        this.mContext = context;
        this.mCrashDeal = new HashMap();
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (!this.handleException(ex) && this.mDefaultHandler != null) {
            this.mDefaultHandler.uncaughtException(thread, ex);
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)"error : ", (Throwable)e);
            }
            ActivityManager.finishAllActivities();
            Process.killProcess((int)Process.myPid());
            System.exit(1);
        }
    }

    private boolean handleException(Throwable ex) {
        if (ex == null) {
            return false;
        }
        if (this.mCrashDeal.size() > 0) {
            return true;
        }
        this.mCrashDeal.put(ex.getCause(), ex);
        new Thread(){

            @Override
            public void run() {
                Looper.prepare();
                Toast.makeText((Context)CrashHandler.this.mContext, (CharSequence)"\u5f88\u62b1\u6b49\uff0c\u7a0b\u5e8f\u51fa\u73b0\u5f02\u5e38\uff0c\u5373\u5c06\u9000\u51fa\u3002", (int)1).show();
                Looper.loop();
            }
        }.start();
        this.collectDeviceInfo(ex);
        if (this.isUpload) {
            this.uploadCrashLogToServer();
        }
        return true;
    }

    public void collectDeviceInfo(Throwable ex) {
        this.mInfos.put("ip", DeviceUtil.getHostIp());
        this.mInfos.put("deviceType", DeviceUtil.getDeviceType());
        this.mInfos.put("clientType", "1");
        this.mInfos.put("os", Build.VERSION.RELEASE);
        this.mInfos.put("sign", Md5.md5(AppUtil.appSignatures()));
        this.mInfos.put("path", ActivityManager.getActivityPath());
        this.mInfos.put("memory", DeviceUtil.getTotalMemory());
        this.mInfos.put("cpu", "max :" + CpuUtil.getMaxCpuFreq() + "min :" + CpuUtil.getMinCpuFreq() + "current:" + CpuUtil.getCurCpuFreq());
        this.mInfos.put("resolution", DeviceUtil.getScreenDpWidth() + "*" + DeviceUtil.getScreenDpHeight());
        this.mInfos.put("description", ex.getCause().toString());
        this.mInfos.put("detail", this.getStackTraceDetail(ex));
    }

    private String getStackTraceDetail(Throwable ex) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        ex.printStackTrace(printWriter);
        Throwable cause = ex.getCause();
        if (cause != null) {
            cause.printStackTrace(printWriter);
        }
        printWriter.close();
        return ((Object)writer).toString();
    }

    public void isUploadCrashLogToServer(boolean isUpload) {
        this.isUpload = isUpload;
    }

    private void uploadCrashLogToServer() {
        UnifyHttpClient.execute(this.mCrashLogUrl, this.mInfos, new UnifyHttpClient.UnifyHttpCallback(){

            @Override
            public void onResponse(DataResult response) {
            }
        });
    }

    public void setUploadCrashLogParams(HashMap<String, String> params) {
        if (params.size() > 0) {
            this.mInfos.putAll(params);
        }
    }

    private String saveCrashInfo2File(Throwable ex) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : this.mInfos.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append(key + "=" + value + "\n");
        }
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        ex.printStackTrace(printWriter);
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        printWriter.close();
        String result = ((Object)writer).toString();
        sb.append(result);
        try {
            long timestamp = System.currentTimeMillis();
            String time = this.mFormatter.format(new Date());
            String fileName = "crash-" + time + "-" + timestamp + ".log";
            if (Environment.getExternalStorageState().equals("mounted")) {
                File dir = new File(this.mCrashLogPath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(this.mCrashLogPath + fileName);
                fos.write(sb.toString().getBytes());
                fos.close();
            }
            return fileName;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"an error occured while writing file...", (Throwable)e);
            return null;
        }
    }
}

