/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.base;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import cc.livvy.framework.base.BaseApp;
import cc.livvy.framework.util.ToastUtil;

public abstract class BaseFragment
extends Fragment {
    public Activity mContext;
    public Handler mLoadHandler;
    protected boolean isVisible;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mContext = this.getActivity();
        this.mLoadHandler = new Handler();
    }

    public void loadData() {
        long time = 500L;
        this.mLoadHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                BaseFragment.this.onLoadData();
            }
        }, time);
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        if (this.getUserVisibleHint()) {
            this.isVisible = true;
            this.onVisible();
        } else {
            this.isVisible = false;
            this.onInvisible();
        }
    }

    protected void onVisible() {
        this.loadData();
    }

    protected void onInvisible() {
    }

    protected abstract void onLoadData();

    protected void toast(String message) {
        ToastUtil.showShort((Activity)this.getActivity(), message);
    }

    protected void toast(int resId) {
        ToastUtil.showShort((Activity)this.getActivity(), resId);
    }

    public String getStrings(int resId) {
        return BaseApp.getAppContext().getResources().getString(resId);
    }
}

