/*
 * Decompiled with CFR 0.152.
 */
package cc.ecore.spring.jfinal.javassist;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;

class JavassistKit {
    static ClassPool defaultPool = new ClassPool();

    static {
        defaultPool.insertClassPath((ClassPath)new ClassClassPath(JavassistKit.class));
    }

    JavassistKit() {
    }

    public static CtClass get(String classname) {
        try {
            return defaultPool.get(classname);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(String.valueOf(classname) + " is in a parent ClassPool.  Use the parent.");
        }
    }

    public static CtClass makeClass(byte[] bytecode) {
        return JavassistKit.makeClass(new ByteArrayInputStream(bytecode));
    }

    public static CtClass makeClass(InputStream classfile) {
        InputStream input = classfile;
        try {
            CtClass ctClass = defaultPool.makeClass(input);
            return ctClass;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static CtClass[] asArray(String ... args) {
        int length = args.length;
        CtClass[] classes = new CtClass[length];
        int i = 0;
        while (i < length) {
            classes[i] = JavassistKit.get(args[i]);
            ++i;
        }
        return classes;
    }
}

