/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CP;
import ca.uhn.hl7v2.model.v26.datatype.CQ;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ADJ
extends AbstractSegment {
    public ADJ(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 73, new Object[]{this.getMessage()}, "Provider Adjustment Number");
            this.add(EI.class, true, 1, 73, new Object[]{this.getMessage()}, "Payer Adjustment Number");
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Adjustment Sequence Number");
            this.add(IS.class, true, 1, 4, new Object[]{this.getMessage(), new Integer(564)}, "Adjustment Category");
            this.add(CP.class, false, 1, 254, new Object[]{this.getMessage()}, "Adjustment Amount");
            this.add(CQ.class, false, 1, 222, new Object[]{this.getMessage()}, "Adjustment Quantity");
            this.add(CWE.class, false, 1, 211, new Object[]{this.getMessage()}, "Adjustment Reason PA");
            this.add(ST.class, false, 1, 250, new Object[]{this.getMessage()}, "Adjustment Description");
            this.add(NM.class, false, 1, 250, new Object[]{this.getMessage()}, "Original Value");
            this.add(NM.class, false, 1, 250, new Object[]{this.getMessage()}, "Substitute Value");
            this.add(IS.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(569)}, "Adjustment Action");
            this.add(EI.class, false, 1, 73, new Object[]{this.getMessage()}, "Provider Adjustment Number Cross Reference");
            this.add(EI.class, false, 1, 73, new Object[]{this.getMessage()}, "Provider Product/Service Line Item Number Cross Reference");
            this.add(DTM.class, true, 1, 26, new Object[]{this.getMessage()}, "Adjustment Date");
            this.add(XON.class, false, 1, 183, new Object[]{this.getMessage()}, "Responsible Organization");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADJ - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getProviderAdjustmentNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getAdj1_ProviderAdjustmentNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getPayerAdjustmentNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getAdj2_PayerAdjustmentNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public SI getAdjustmentSequenceNumber() {
        SI retVal = (SI)this.getTypedField(3, 0);
        return retVal;
    }

    public SI getAdj3_AdjustmentSequenceNumber() {
        SI retVal = (SI)this.getTypedField(3, 0);
        return retVal;
    }

    public IS getAdjustmentCategory() {
        IS retVal = (IS)this.getTypedField(4, 0);
        return retVal;
    }

    public IS getAdj4_AdjustmentCategory() {
        IS retVal = (IS)this.getTypedField(4, 0);
        return retVal;
    }

    public CP getAdjustmentAmount() {
        CP retVal = (CP)this.getTypedField(5, 0);
        return retVal;
    }

    public CP getAdj5_AdjustmentAmount() {
        CP retVal = (CP)this.getTypedField(5, 0);
        return retVal;
    }

    public CQ getAdjustmentQuantity() {
        CQ retVal = (CQ)this.getTypedField(6, 0);
        return retVal;
    }

    public CQ getAdj6_AdjustmentQuantity() {
        CQ retVal = (CQ)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getAdjustmentReasonPA() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getAdj7_AdjustmentReasonPA() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getAdjustmentDescription() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getAdj8_AdjustmentDescription() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getOriginalValue() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getAdj9_OriginalValue() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getSubstituteValue() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getAdj10_SubstituteValue() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public IS getAdjustmentAction() {
        IS retVal = (IS)this.getTypedField(11, 0);
        return retVal;
    }

    public IS getAdj11_AdjustmentAction() {
        IS retVal = (IS)this.getTypedField(11, 0);
        return retVal;
    }

    public EI getProviderAdjustmentNumberCrossReference() {
        EI retVal = (EI)this.getTypedField(12, 0);
        return retVal;
    }

    public EI getAdj12_ProviderAdjustmentNumberCrossReference() {
        EI retVal = (EI)this.getTypedField(12, 0);
        return retVal;
    }

    public EI getProviderProductServiceLineItemNumberCrossReference() {
        EI retVal = (EI)this.getTypedField(13, 0);
        return retVal;
    }

    public EI getAdj13_ProviderProductServiceLineItemNumberCrossReference() {
        EI retVal = (EI)this.getTypedField(13, 0);
        return retVal;
    }

    public DTM getAdjustmentDate() {
        DTM retVal = (DTM)this.getTypedField(14, 0);
        return retVal;
    }

    public DTM getAdj14_AdjustmentDate() {
        DTM retVal = (DTM)this.getTypedField(14, 0);
        return retVal;
    }

    public XON getResponsibleOrganization() {
        XON retVal = (XON)this.getTypedField(15, 0);
        return retVal;
    }

    public XON getAdj15_ResponsibleOrganization() {
        XON retVal = (XON)this.getTypedField(15, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new SI(this.getMessage());
            }
            case 3: {
                return new IS(this.getMessage(), new Integer(564));
            }
            case 4: {
                return new CP(this.getMessage());
            }
            case 5: {
                return new CQ(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new IS(this.getMessage(), new Integer(569));
            }
            case 11: {
                return new EI(this.getMessage());
            }
            case 12: {
                return new EI(this.getMessage());
            }
            case 13: {
                return new DTM(this.getMessage());
            }
            case 14: {
                return new XON(this.getMessage());
            }
        }
        return null;
    }
}

