/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.segment.PCE;
import ca.uhn.hl7v2.model.v26.segment.PKG;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFN_M16_PACKAGING
extends AbstractGroup {
    public MFN_M16_PACKAGING(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PKG.class, true, false, false);
            this.add(PCE.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M16_PACKAGING - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public PKG getPKG() {
        PKG retVal = (PKG)this.getTyped("PKG", PKG.class);
        return retVal;
    }

    public PCE getPCE() {
        PCE retVal = (PCE)this.getTyped("PCE", PCE.class);
        return retVal;
    }

    public PCE getPCE(int rep) {
        PCE retVal = (PCE)this.getTyped("PCE", rep, PCE.class);
        return retVal;
    }

    public int getPCEReps() {
        return this.getReps("PCE");
    }

    public List<PCE> getPCEAll() throws HL7Exception {
        return this.getAllAsList("PCE", PCE.class);
    }

    public void insertPCE(PCE structure, int rep) throws HL7Exception {
        super.insertRepetition("PCE", (Structure)structure, rep);
    }

    public PCE insertPCE(int rep) throws HL7Exception {
        return (PCE)super.insertRepetition("PCE", rep);
    }

    public PCE removePCE(int rep) throws HL7Exception {
        return (PCE)super.removeRepetition("PCE", rep);
    }
}

