/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class LAN
extends AbstractSegment {
    public LAN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 60, new Object[]{this.getMessage()}, "Set ID - LAN");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Language Code");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Language Ability Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Language Proficiency Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating LAN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDLAN() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getLan1_SetIDLAN() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getLanguageCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getLan2_LanguageCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE[] getLanguageAbilityCode() {
        CE[] retVal = (CE[])this.getTypedField(3, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getLan3_LanguageAbilityCode() {
        CE[] retVal = (CE[])this.getTypedField(3, (Type[])new CE[0]);
        return retVal;
    }

    public int getLanguageAbilityCodeReps() {
        return this.getReps(3);
    }

    public CE getLanguageAbilityCode(int rep) {
        CE retVal = (CE)this.getTypedField(3, rep);
        return retVal;
    }

    public CE getLan3_LanguageAbilityCode(int rep) {
        CE retVal = (CE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getLan3_LanguageAbilityCodeReps() {
        return this.getReps(3);
    }

    public CE insertLanguageAbilityCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(3, rep);
    }

    public CE insertLan3_LanguageAbilityCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(3, rep);
    }

    public CE removeLanguageAbilityCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(3, rep);
    }

    public CE removeLan3_LanguageAbilityCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(3, rep);
    }

    public CE getLanguageProficiencyCode() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getLan4_LanguageProficiencyCode() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

