/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.ORF_R04_QUERY_RESPONSE;
import ca.uhn.hl7v2.model.v23.segment.DSC;
import ca.uhn.hl7v2.model.v23.segment.MSA;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.QRD;
import ca.uhn.hl7v2.model.v23.segment.QRF;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORF_R04
extends AbstractMessage {
    public ORF_R04() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public ORF_R04(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(ORF_R04_QUERY_RESPONSE.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ORF_R04 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public QRD getQRD() {
        return (QRD)this.getTyped("QRD", QRD.class);
    }

    public QRF getQRF() {
        return (QRF)this.getTyped("QRF", QRF.class);
    }

    public ORF_R04_QUERY_RESPONSE getQUERY_RESPONSE() {
        return (ORF_R04_QUERY_RESPONSE)this.getTyped("QUERY_RESPONSE", ORF_R04_QUERY_RESPONSE.class);
    }

    public ORF_R04_QUERY_RESPONSE getQUERY_RESPONSE(int rep) {
        return (ORF_R04_QUERY_RESPONSE)this.getTyped("QUERY_RESPONSE", rep, ORF_R04_QUERY_RESPONSE.class);
    }

    public int getQUERY_RESPONSEReps() {
        return this.getReps("QUERY_RESPONSE");
    }

    public List<ORF_R04_QUERY_RESPONSE> getQUERY_RESPONSEAll() throws HL7Exception {
        return this.getAllAsList("QUERY_RESPONSE", ORF_R04_QUERY_RESPONSE.class);
    }

    public void insertQUERY_RESPONSE(ORF_R04_QUERY_RESPONSE structure, int rep) throws HL7Exception {
        super.insertRepetition("QUERY_RESPONSE", (Structure)structure, rep);
    }

    public ORF_R04_QUERY_RESPONSE insertQUERY_RESPONSE(int rep) throws HL7Exception {
        return (ORF_R04_QUERY_RESPONSE)super.insertRepetition("QUERY_RESPONSE", rep);
    }

    public ORF_R04_QUERY_RESPONSE removeQUERY_RESPONSE(int rep) throws HL7Exception {
        return (ORF_R04_QUERY_RESPONSE)super.removeRepetition("QUERY_RESPONSE", rep);
    }

    public DSC getDSC() {
        return (DSC)this.getTyped("DSC", DSC.class);
    }
}

