/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.model.v21.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class QRF
extends AbstractSegment {
    public QRF(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, true, 0, 20, new Object[]{this.getMessage()}, "WHERE SUBJECT FILTER");
            this.add(TS.class, false, 1, 19, new Object[]{this.getMessage()}, "WHEN DATA START DATE/TIME");
            this.add(TS.class, false, 1, 19, new Object[]{this.getMessage()}, "WHEN DATA END DATE/TIME");
            this.add(ST.class, false, 0, 20, new Object[]{this.getMessage()}, "WHAT USER QUALIFIER");
            this.add(ST.class, false, 0, 20, new Object[]{this.getMessage()}, "OTHER QRY SUBJECT FILTER");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating QRF - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST[] getWHERESUBJECTFILTER() {
        ST[] retVal = (ST[])this.getTypedField(1, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getQrf1_WHERESUBJECTFILTER() {
        ST[] retVal = (ST[])this.getTypedField(1, (Type[])new ST[0]);
        return retVal;
    }

    public int getWHERESUBJECTFILTERReps() {
        return this.getReps(1);
    }

    public ST getWHERESUBJECTFILTER(int rep) {
        ST retVal = (ST)this.getTypedField(1, rep);
        return retVal;
    }

    public ST getQrf1_WHERESUBJECTFILTER(int rep) {
        ST retVal = (ST)this.getTypedField(1, rep);
        return retVal;
    }

    public int getQrf1_WHERESUBJECTFILTERReps() {
        return this.getReps(1);
    }

    public ST insertWHERESUBJECTFILTER(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(1, rep);
    }

    public ST insertQrf1_WHERESUBJECTFILTER(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(1, rep);
    }

    public ST removeWHERESUBJECTFILTER(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(1, rep);
    }

    public ST removeQrf1_WHERESUBJECTFILTER(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(1, rep);
    }

    public TS getWHENDATASTARTDATETIME() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getQrf2_WHENDATASTARTDATETIME() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getWHENDATAENDDATETIME() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getQrf3_WHENDATAENDDATETIME() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public ST[] getWHATUSERQUALIFIER() {
        ST[] retVal = (ST[])this.getTypedField(4, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getQrf4_WHATUSERQUALIFIER() {
        ST[] retVal = (ST[])this.getTypedField(4, (Type[])new ST[0]);
        return retVal;
    }

    public int getWHATUSERQUALIFIERReps() {
        return this.getReps(4);
    }

    public ST getWHATUSERQUALIFIER(int rep) {
        ST retVal = (ST)this.getTypedField(4, rep);
        return retVal;
    }

    public ST getQrf4_WHATUSERQUALIFIER(int rep) {
        ST retVal = (ST)this.getTypedField(4, rep);
        return retVal;
    }

    public int getQrf4_WHATUSERQUALIFIERReps() {
        return this.getReps(4);
    }

    public ST insertWHATUSERQUALIFIER(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(4, rep);
    }

    public ST insertQrf4_WHATUSERQUALIFIER(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(4, rep);
    }

    public ST removeWHATUSERQUALIFIER(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(4, rep);
    }

    public ST removeQrf4_WHATUSERQUALIFIER(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(4, rep);
    }

    public ST[] getOTHERQRYSUBJECTFILTER() {
        ST[] retVal = (ST[])this.getTypedField(5, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getQrf5_OTHERQRYSUBJECTFILTER() {
        ST[] retVal = (ST[])this.getTypedField(5, (Type[])new ST[0]);
        return retVal;
    }

    public int getOTHERQRYSUBJECTFILTERReps() {
        return this.getReps(5);
    }

    public ST getOTHERQRYSUBJECTFILTER(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public ST getQrf5_OTHERQRYSUBJECTFILTER(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public int getQrf5_OTHERQRYSUBJECTFILTERReps() {
        return this.getReps(5);
    }

    public ST insertOTHERQRYSUBJECTFILTER(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST insertQrf5_OTHERQRYSUBJECTFILTER(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST removeOTHERQRYSUBJECTFILTER(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST removeQrf5_OTHERQRYSUBJECTFILTER(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new TS(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

