/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.encoder;

import ca.uhn.hl7v2.hoh.sign.ISigner;
import ca.uhn.hl7v2.hoh.util.StringUtils;
import ca.uhn.hl7v2.hoh.util.VersionLogger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;

abstract class AbstractHl7OverHttp {
    public static final String HTTP_HEADER_HL7_SIGNATURE = "HL7-Signature";
    public static final String HTTP_HEADER_HL7_SIGNATURE_LC = "HL7-Signature".toLowerCase();
    protected static final Charset ourDefaultCharset = StandardCharsets.UTF_8;
    private Charset myCharset = ourDefaultCharset;
    private boolean myCharsetExplicitlySet;
    private byte[] myData;
    private LinkedHashMap<String, String> myHeaders;
    private String myMessage;
    private String myPassword;
    private ISigner mySigner;
    private String myPath;
    private boolean myUsed;
    private String myUsername;

    public Charset getCharset() {
        return this.myCharset;
    }

    public byte[] getData() {
        return this.myData;
    }

    public Map<String, String> getHeaders() {
        return this.myHeaders;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public String getPassword() {
        return this.myPassword;
    }

    public ISigner getSigner() {
        return this.mySigner;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getPathRaw() {
        return this.myPath;
    }

    public String getUsername() {
        return this.myUsername;
    }

    public boolean isCharsetExplicitlySet() {
        return this.myCharsetExplicitlySet;
    }

    @Deprecated
    public void setCharset(Charset theCharset) {
        if (theCharset == null) {
            throw new NullPointerException("Charset can not be null");
        }
        this.myCharsetExplicitlySet = true;
        this.myCharset = theCharset;
    }

    protected void setData(byte[] theData) {
        this.myData = theData;
    }

    public void setHeaders(LinkedHashMap<String, String> theHeaders) {
        this.myHeaders = theHeaders;
    }

    public void setMessage(String theMessage) {
        this.myMessage = theMessage;
    }

    public void setPassword(String thePassword) {
        this.myPassword = thePassword;
    }

    public void setSigner(ISigner theSigner) {
        this.mySigner = theSigner;
    }

    public void setPath(String thePath) {
        this.myPath = thePath;
    }

    public void setUsername(String theUsername) {
        if (StringUtils.isNotBlank(theUsername) && theUsername.contains(":")) {
            throw new IllegalArgumentException("Username contains illegal characters");
        }
        this.myUsername = theUsername;
    }

    protected void verifyNotUsed() {
        if (this.myUsed) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " may not be reused");
        }
        this.myUsed = true;
    }

    public static Charset getDefaultCharset() {
        return ourDefaultCharset;
    }

    static {
        VersionLogger.init();
    }
}

