/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.raw.api;

import ca.uhn.hl7v2.hoh.api.IResponseSendable;
import ca.uhn.hl7v2.hoh.encoder.EncodingStyle;
import ca.uhn.hl7v2.hoh.encoder.ResponseCode;
import java.io.IOException;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawSendable
implements IResponseSendable<String> {
    private final String myRawMessage;
    private final EncodingStyle myEncodingStyle;
    private ResponseCode myResponseCode;

    public RawSendable(String theRawMessage) {
        if (theRawMessage == null) {
            throw new NullPointerException("Raw Message may not be null");
        }
        this.myRawMessage = theRawMessage;
        this.myEncodingStyle = EncodingStyle.detect(this.myRawMessage);
    }

    @Override
    public void writeMessage(Writer theWriter) throws IOException {
        theWriter.write(this.myRawMessage);
        theWriter.flush();
    }

    @Override
    public EncodingStyle getEncodingStyle() {
        return this.myEncodingStyle;
    }

    @Override
    public ResponseCode getResponseCode() {
        if (this.myResponseCode == null) {
            this.myResponseCode = ResponseCode.detect(this.myRawMessage);
        }
        return this.myResponseCode;
    }

    @Override
    public String getMessage() {
        return this.myRawMessage;
    }
}

