/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.llp;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionHub;
import ca.uhn.hl7v2.app.Initiator;
import ca.uhn.hl7v2.hoh.auth.SingleCredentialClientCallback;
import ca.uhn.hl7v2.hoh.auth.SingleCredentialServerCallback;
import ca.uhn.hl7v2.hoh.encoder.EncodingStyle;
import ca.uhn.hl7v2.hoh.llp.Hl7OverHttpLowerLayerProtocol;
import ca.uhn.hl7v2.hoh.llp.ServerSocketThreadForTesting;
import ca.uhn.hl7v2.hoh.util.RandomServerPortProvider;
import ca.uhn.hl7v2.hoh.util.ServerRoleEnum;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v25.message.ADT_A05;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlpClientTest {
    private static Hl7OverHttpLowerLayerProtocol ourLlp;
    private static final Logger ourLog;
    private static int ourPort;
    private static SingleCredentialServerCallback ourServerCallback;
    private static ServerSocketThreadForTesting ourServerSocketThread;
    private static ExecutorService ourExecutor;

    static {
        ourLog = LoggerFactory.getLogger(LlpClientTest.class);
    }

    @Test
    public void testSendMessageSimpl() throws Exception {
        Connection conn;
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        ADT_A05 msg = new ADT_A05();
        msg.parse(message);
        try {
            DefaultHapiContext context = new DefaultHapiContext();
            context.setExecutorService(ourExecutor);
            ConnectionHub connectionHub = context.getConnectionHub();
            PipeParser pipeParser = PipeParser.getInstanceWithNoValidation();
            conn = connectionHub.attach("localhost", ourPort, (Parser)pipeParser, (LowerLayerProtocol)ourLlp, false);
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(e.getMessage()) + " - " + RandomServerPortProvider.list().toString(), e);
        }
        Initiator initiator = conn.getInitiator();
        Message response = initiator.sendAndReceive((Message)msg);
        ourLog.info("Received response");
        Assert.assertEquals((Object)message, (Object)ourServerSocketThread.getMessage());
        Assert.assertEquals((Object)ourServerSocketThread.getReply().encode(), (Object)response.encode());
    }

    @Test
    public void testSendMessageSimpleXmlViaParser() throws Exception {
        Connection conn;
        String messageStr = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        Message msg = PipeParser.getInstanceWithNoValidation().parse(messageStr);
        msg.setParser((Parser)DefaultXMLParser.getInstanceWithNoValidation());
        messageStr = msg.encode();
        try {
            DefaultHapiContext context = new DefaultHapiContext();
            context.setExecutorService(ourExecutor);
            ConnectionHub connectionHub = context.getConnectionHub();
            DefaultXMLParser parser = DefaultXMLParser.getInstanceWithNoValidation();
            conn = connectionHub.attach("localhost", ourPort, (Parser)parser, (LowerLayerProtocol)ourLlp, false);
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(e.getMessage()) + " - " + RandomServerPortProvider.list().toString(), e);
        }
        Initiator initiator = conn.getInitiator();
        Message response = initiator.sendAndReceive(msg);
        ourLog.info("Received response");
        Assert.assertEquals((Object)messageStr, (Object)ourServerSocketThread.getMessage());
        Assert.assertEquals((Object)ourServerSocketThread.getReply().encode(), (Object)response.encode());
        Assert.assertEquals((Object)EncodingStyle.XML.getContentType(), (Object)ourServerSocketThread.getContentType());
        Assert.assertEquals((Object)((Object)EncodingStyle.XML), (Object)((Object)ourServerSocketThread.getEncoding()));
    }

    @AfterClass
    public static void afterClass() throws InterruptedException {
        ourLog.info("Marking done as true");
        ourServerSocketThread.done();
        ourExecutor.shutdown();
    }

    @BeforeClass
    public static void beforeClass() throws InterruptedException {
        ourPort = RandomServerPortProvider.findFreePort();
        ourLlp = new Hl7OverHttpLowerLayerProtocol(ServerRoleEnum.CLIENT);
        ourLlp.setAuthorizationCallback(new SingleCredentialClientCallback("hello", "hapiworld"));
        ourServerCallback = new SingleCredentialServerCallback("hello", "hapiworld");
        ourServerSocketThread = new ServerSocketThreadForTesting(ourPort, ourServerCallback);
        ourServerSocketThread.start();
        ourServerSocketThread.getLatch().await();
        ourExecutor = Executors.newCachedThreadPool();
        Thread.sleep(1000L);
    }

    @Test
    public void testSendMessageSimpleWithClientSigner() throws Exception {
        Connection conn;
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        ADT_A05 msg = new ADT_A05();
        msg.parse(message);
        try {
            DefaultHapiContext context = new DefaultHapiContext();
            context.setExecutorService(ourExecutor);
            ConnectionHub connectionHub = context.getConnectionHub();
            PipeParser pipeParser = PipeParser.getInstanceWithNoValidation();
            conn = connectionHub.attach("localhost", ourPort, (Parser)pipeParser, (LowerLayerProtocol)ourLlp, false);
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(e.getMessage()) + " - " + RandomServerPortProvider.list().toString(), e);
        }
        Initiator initiator = conn.getInitiator();
        Message response = initiator.sendAndReceive((Message)msg);
        ourLog.info("Received response");
        Assert.assertEquals((Object)message, (Object)ourServerSocketThread.getMessage());
        Assert.assertEquals((Object)ourServerSocketThread.getReply().encode(), (Object)response.encode());
    }
}

