/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.encoder;

import ca.uhn.hl7v2.hoh.api.EncodeException;
import ca.uhn.hl7v2.hoh.encoder.Hl7OverHttpRequestEncoder;
import ca.uhn.hl7v2.hoh.sign.BouncyCastleCmsMessageSigner;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Hl7OverHttpEncoderTest {
    private static BouncyCastleCmsMessageSigner mySigner;

    @Test
    public void testContentLengthCalculatedCorrectly() throws EncodeException, UnsupportedEncodingException {
        String message = "MSH|^~\\&|||||200803051508||ACK^A31|33|P|2.5\rMSA|AR|I\u2665HAPI\r";
        Hl7OverHttpRequestEncoder enc = new Hl7OverHttpRequestEncoder();
        enc.setCharset(Charset.forName("UTF-8"));
        enc.setMessage(message);
        enc.encode();
        Assert.assertEquals((Object)("" + message.getBytes("UTF-8").length), enc.getHeaders().get("Content-Length"));
    }

    @Test
    public void testContentLengthCalculation() throws EncodeException {
        String message = "MSH|^~\\&|||||200803051508||ACK^A31|33|P|2.5\rMSA|AR|2\r";
        Hl7OverHttpRequestEncoder enc = new Hl7OverHttpRequestEncoder();
        enc.setCharset(Charset.forName("ISO-8859-1"));
        enc.setUsername("hello");
        enc.setPassword("world");
        enc.setSigner(mySigner);
        enc.setMessage(message);
        enc.encode();
        for (Map.Entry next : enc.getHeaders().entrySet()) {
            System.out.println(String.valueOf((String)next.getKey()) + ": " + (String)next.getValue());
        }
    }

    @Test
    public void testEncode() throws EncodeException {
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        Hl7OverHttpRequestEncoder enc = new Hl7OverHttpRequestEncoder();
        enc.setCharset(Charset.forName("ISO-8859-1"));
        enc.setUsername("hello");
        enc.setPassword("world");
        enc.setSigner(mySigner);
        enc.setMessage(message);
        enc.encode();
        for (Map.Entry next : enc.getHeaders().entrySet()) {
            System.out.println(String.valueOf((String)next.getKey()) + ": " + (String)next.getValue());
        }
    }

    @BeforeClass
    public static void beforeClass() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        InputStream ksStream = BouncyCastleCmsMessageSigner.class.getResourceAsStream("/keystore.jks");
        keyStore.load(ksStream, "changeit".toCharArray());
        mySigner = new BouncyCastleCmsMessageSigner();
        mySigner.setKeyStore(keyStore);
        mySigner.setKeyAlias("testcert");
        mySigner.setAliasPassword("changeit");
    }
}

