/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hl7InputStreamMessageStringIterator
implements Iterator<String> {
    private static final Logger ourLog = LoggerFactory.getLogger(Hl7InputStreamMessageStringIterator.class);
    private final StringBuilder myBuffer = new StringBuilder();
    private boolean myFoundMessageInBuffer = false;
    private Boolean myHasNext;
    private boolean myIgnoreComments;
    private String myNext;
    private final Reader myReader;

    public Hl7InputStreamMessageStringIterator(InputStream theInputStream) {
        this(new InputStreamReader(theInputStream));
    }

    public Hl7InputStreamMessageStringIterator(Reader theReader) {
        this.myReader = new PushbackReader(theReader);
    }

    @Override
    public boolean hasNext() {
        if (this.myHasNext == null) {
            String msgString;
            int prev = -1;
            int endOfBuffer = -1;
            boolean inComment = false;
            while (true) {
                int next;
                try {
                    next = this.myReader.read();
                }
                catch (IOException e) {
                    throw new ParseFailureError("IOException reading from input", e);
                }
                if (next == -1) break;
                char nextChar = (char)next;
                if (nextChar == '#' && this.myIgnoreComments && (prev == -1 || prev == 10 || prev == 13)) {
                    inComment = true;
                    continue;
                }
                if (nextChar == '\n') {
                    if (this.myBuffer.length() > 0 && this.myBuffer.charAt(this.myBuffer.length() - 1) != '\r') {
                        this.myBuffer.append('\r');
                    }
                } else if (inComment) {
                    if (nextChar == '\r') {
                        inComment = false;
                    }
                } else {
                    this.myBuffer.append(nextChar);
                }
                prev = next;
                int bLength = this.myBuffer.length();
                if (nextChar != 'H' || bLength < 3 || this.myBuffer.charAt(bLength - 2) != 'S' || this.myBuffer.charAt(bLength - 3) != 'M') continue;
                if (this.myFoundMessageInBuffer) {
                    if (this.myBuffer.charAt(bLength - 4) >= ' ') continue;
                    endOfBuffer = bLength - 3;
                    break;
                }
                this.myBuffer.delete(0, bLength - 3);
                this.myFoundMessageInBuffer = true;
            }
            if (!this.myFoundMessageInBuffer) {
                this.myHasNext = false;
                return false;
            }
            if (endOfBuffer > -1) {
                msgString = this.myBuffer.substring(0, endOfBuffer);
                this.myBuffer.delete(0, endOfBuffer);
            } else {
                msgString = this.myBuffer.toString();
                this.myBuffer.setLength(0);
            }
            if (!msgString.startsWith("MSH")) {
                this.myHasNext = Boolean.FALSE;
                return false;
            }
            this.myNext = msgString;
            this.myHasNext = Boolean.TRUE;
        }
        return this.myHasNext;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new IllegalStateException();
        }
        String retVal = this.myNext;
        this.myNext = null;
        this.myHasNext = null;
        return retVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void setIgnoreComments(boolean theIgnoreComments) {
        this.myIgnoreComments = theIgnoreComments;
    }

    public static class ParseFailureError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseFailureError(String theMessage, Exception theCause) {
            super(theMessage, theCause);
        }
    }
}

