/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.protocol.TransportException;
import ca.uhn.hl7v2.protocol.TransportLayer;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.hl7v2.protocol.impl.AbstractTransport;
import ca.uhn.hl7v2.protocol.impl.IntRef;
import ca.uhn.hl7v2.protocol.impl.ReaderThread;
import ca.uhn.hl7v2.protocol.impl.TransportableImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLTransport
extends AbstractTransport
implements TransportLayer {
    private static final Logger log = LoggerFactory.getLogger(URLTransport.class);
    public static final String URL_KEY = "URL";
    private String myContentType = "application/hl7+doc+xml";
    private final URL myURL;
    private URLConnection myConnection;
    protected final int myBufferSize = 3000;
    private final boolean myConnectOnSend;
    private final boolean myConnectOnReceive;
    private final boolean myConnectOnConnect;

    public URLTransport(URL theURL, boolean connectOnSend, boolean connectOnReceive, boolean connectOnConnect) {
        this.myURL = theURL;
        this.getCommonMetadata().put(URL_KEY, theURL);
        this.myConnectOnSend = connectOnSend;
        this.myConnectOnReceive = connectOnReceive;
        this.myConnectOnConnect = connectOnConnect;
    }

    @Override
    public void doSend(Transportable theMessage) throws TransportException {
        if (this.myConnectOnSend) {
            this.makeConnection();
        }
        try {
            OutputStreamWriter out = new OutputStreamWriter(new BufferedOutputStream(this.myConnection.getOutputStream()));
            out.write(theMessage.getMessage());
            ((Writer)out).flush();
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public Transportable doReceive() throws TransportException {
        if (this.myConnectOnReceive) {
            this.makeConnection();
        }
        StringBuilder response = new StringBuilder();
        try {
            log.debug("Getting InputStream from URLConnection");
            InputStreamReader in = new InputStreamReader(new BufferedInputStream(this.myConnection.getInputStream()));
            log.debug("Got InputStream from URLConnection");
            char[] buf = new char[3000];
            int bytesRead = 0;
            IntRef bytesReadRef = new IntRef();
            while (bytesRead >= 0) {
                try {
                    ReaderThread readerThread = new ReaderThread(in, buf, bytesReadRef);
                    readerThread.start();
                    readerThread.join(10000L);
                    bytesRead = bytesReadRef.getValue();
                    if (bytesRead == 0) {
                        throw new TransportException("Timeout waiting for response");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (bytesRead <= 0) continue;
                response.append(buf, 0, bytesRead);
            }
            ((Reader)in).close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (response.length() == 0) {
            throw new TransportException("Timeout waiting for response");
        }
        return new TransportableImpl(response.toString());
    }

    @Override
    public void doConnect() throws TransportException {
        if (this.myConnectOnConnect) {
            this.makeConnection();
        }
    }

    private void makeConnection() throws TransportException {
        try {
            this.myConnection = this.myURL.openConnection();
            this.myConnection.setDoOutput(true);
            this.myConnection.setDoInput(true);
            this.myConnection.setRequestProperty("Content-Type", this.getContentType());
            this.myConnection.connect();
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
        log.debug("Made connection to {}", (Object)this.myURL.toExternalForm());
    }

    public String getContentType() {
        return this.myContentType;
    }

    public void setContentType(String theContentType) {
        this.myContentType = theContentType;
    }

    @Override
    public void doDisconnect() {
        this.myConnection = null;
    }
}

