/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.protocol.ApplicationRouter;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.hl7v2.protocol.impl.TransportableImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;

class Responder {
    private ApplicationRouter apps;
    private final Socket inboundSocket;

    public Responder(Socket theInboundSocket) {
        this.inboundSocket = theInboundSocket;
    }

    protected String processMessage(String incomingMessageString) throws HL7Exception {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        InetSocketAddress remoteSocketAddress = (InetSocketAddress)this.inboundSocket.getRemoteSocketAddress();
        metadata.put("SENDING_IP", remoteSocketAddress.getAddress().getHostAddress());
        metadata.put("SENDING_PORT", remoteSocketAddress.getPort());
        Transportable response = this.apps.processMessage(new TransportableImpl(incomingMessageString, metadata));
        return response.getMessage();
    }

    void setApplicationRouter(ApplicationRouter router) {
        this.apps = router;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: DefaultApplication message_file");
            System.exit(1);
        }
        try {
            File messageFile = new File(args[0]);
            BufferedReader in = new BufferedReader(new FileReader(messageFile));
            int fileLength = (int)messageFile.length();
            char[] cbuf = new char[fileLength];
            ((Reader)in).read(cbuf, 0, fileLength);
            String messageString = new String(cbuf);
            PipeParser parser = new PipeParser();
            Message inMessage = null;
            try {
                inMessage = ((Parser)parser).parse(messageString);
            }
            catch (HL7Exception e) {
                e.printStackTrace();
            }
            PipedInputStream initInbound = new PipedInputStream();
            PipedOutputStream initOutbound = new PipedOutputStream();
            PipedInputStream respInbound = new PipedInputStream(initOutbound);
            PipedOutputStream pipedOutputStream = new PipedOutputStream(initInbound);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

