/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.protocol.ReceivingApplication;
import ca.uhn.hl7v2.protocol.ReceivingApplicationException;
import ca.uhn.hl7v2.util.DeepCopy;
import java.io.IOException;
import java.util.Map;

public class DefaultApplication
implements ReceivingApplication<Message> {
    public static final String MSG_INTERNAL_ERROR = "Application internal error";
    public static final String MSG_NO_APPROPRIATE_DEST = "No appropriate destination could be found to which this message could be routed.";
    private final AcknowledgmentCode myAcknowledgmentCode;
    private final String myMessage;

    public DefaultApplication() {
        this(AcknowledgmentCode.AR);
    }

    public DefaultApplication(AcknowledgmentCode theAcknowledgmentCode) {
        this(theAcknowledgmentCode, DefaultApplication.defaultMessage(theAcknowledgmentCode));
    }

    public DefaultApplication(AcknowledgmentCode theAcknowledgmentCode, String theMessage) {
        if (theAcknowledgmentCode == null) {
            throw new NullPointerException("Acknowledgment code must not be null");
        }
        this.myAcknowledgmentCode = theAcknowledgmentCode;
        this.myMessage = theMessage;
    }

    private static String defaultMessage(AcknowledgmentCode theAr) {
        switch (theAr) {
            case AA: 
            case CA: {
                return null;
            }
            case AR: 
            case CR: {
                return MSG_NO_APPROPRIATE_DEST;
            }
        }
        return MSG_INTERNAL_ERROR;
    }

    @Override
    public boolean canProcess(Message in) {
        return true;
    }

    public static Message makeACK(Message message) throws HL7Exception, IOException {
        return message.generateACK();
    }

    public static Message makeACK(Segment inboundHeader) throws HL7Exception, IOException {
        DeepCopy.copy(inboundHeader, (Segment)inboundHeader.getMessage().get("MSH"));
        return inboundHeader.getMessage().generateACK();
    }

    @Override
    public Message processMessage(Message theMessage, Map<String, Object> theMetadata) throws ReceivingApplicationException {
        try {
            if (this.myMessage != null) {
                return theMessage.generateACK(this.myAcknowledgmentCode, new HL7Exception(this.myMessage));
            }
            return theMessage.generateACK(this.myAcknowledgmentCode, null);
        }
        catch (Exception e) {
            throw new ReceivingApplicationException("Couldn't create response message: " + e.getMessage());
        }
    }
}

