/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.validation.EncodingRule;
import ca.uhn.hl7v2.validation.MessageRule;
import ca.uhn.hl7v2.validation.PrimitiveTypeRule;
import ca.uhn.hl7v2.validation.Rule;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.builder.ValidationRuleBuilder;
import ca.uhn.hl7v2.validation.impl.EncodingRuleBinding;
import ca.uhn.hl7v2.validation.impl.MessageRuleBinding;
import ca.uhn.hl7v2.validation.impl.PrimitiveTypeRuleBinding;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationContextImpl
implements ValidationContext,
Serializable {
    private List<RuleBinding<PrimitiveTypeRule>> myPrimitiveRuleBindings = new ArrayList<RuleBinding<PrimitiveTypeRule>>();
    private List<RuleBinding<MessageRule>> myMessageRuleBindings = new ArrayList<RuleBinding<MessageRule>>();
    private List<RuleBinding<EncodingRule>> myEncodingRuleBindings = new ArrayList<RuleBinding<EncodingRule>>();

    public ValidationContextImpl() {
    }

    ValidationContextImpl(ValidationRuleBuilder builder) {
        this();
        for (RuleBinding<? extends Rule<?>> ruleBinding : builder.initialize()) {
            if (ruleBinding instanceof MessageRuleBinding) {
                this.myMessageRuleBindings.add((MessageRuleBinding)ruleBinding);
                continue;
            }
            if (ruleBinding instanceof EncodingRuleBinding) {
                this.myEncodingRuleBindings.add((EncodingRuleBinding)ruleBinding);
                continue;
            }
            if (!(ruleBinding instanceof PrimitiveTypeRuleBinding)) continue;
            this.myPrimitiveRuleBindings.add((PrimitiveTypeRuleBinding)ruleBinding);
        }
    }

    @Override
    public Collection<PrimitiveTypeRule> getPrimitiveRules(String theVersion, String theTypeName, Primitive theType) {
        return this.getRules(this.myPrimitiveRuleBindings, theVersion, theTypeName);
    }

    public List<RuleBinding<PrimitiveTypeRule>> getPrimitiveRuleBindings() {
        return this.myPrimitiveRuleBindings;
    }

    @Override
    public Collection<MessageRule> getMessageRules(String theVersion, String theMessageType, String theTriggerEvent) {
        return this.getRules(this.myMessageRuleBindings, theVersion, theMessageType + "^" + theTriggerEvent);
    }

    public List<RuleBinding<MessageRule>> getMessageRuleBindings() {
        return this.myMessageRuleBindings;
    }

    @Override
    public Collection<EncodingRule> getEncodingRules(String theVersion, String theEncoding) {
        return this.getRules(this.myEncodingRuleBindings, theVersion, theEncoding);
    }

    public List<RuleBinding<EncodingRule>> getEncodingRuleBindings() {
        return this.myEncodingRuleBindings;
    }

    private <T extends Rule<?>> Collection<T> getRules(List<RuleBinding<T>> bindings, String version, String scope) {
        ArrayList<T> active = new ArrayList<T>(bindings.size());
        for (RuleBinding<T> binding : bindings) {
            if (!this.applies(binding, version, scope)) continue;
            active.add(binding.getRule());
        }
        return active;
    }

    private boolean applies(RuleBinding<?> binding, String version, String scope) {
        return binding.getActive() && binding.appliesToVersion(version) && binding.appliesToScope(scope);
    }
}

