/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.Severity;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.util.DeepCopy;
import ca.uhn.hl7v2.validation.CollectingValidationExceptionHandler;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.ValidationExceptionHandler;
import ca.uhn.hl7v2.validation.ValidationExceptionHandlerFactory;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RespondingValidationExceptionHandler
extends CollectingValidationExceptionHandler<Message>
implements ValidationExceptionHandlerFactory<Message> {
    private AcknowledgmentCode successAcknowledgementCode = AcknowledgmentCode.AA;
    private AcknowledgmentCode errorAcknowledgementCode = AcknowledgmentCode.AE;

    public RespondingValidationExceptionHandler(HapiContext context) {
        super(context);
    }

    @Override
    public final Message result() throws HL7Exception {
        Object validationSubject = this.getValidationSubject();
        if (validationSubject == null) {
            throw new HL7Exception("Need non-null validation subject");
        }
        Message response = this.generateResponseMessage(validationSubject);
        this.populateResponseMessage(response);
        return response;
    }

    public void setSuccessAcknowledgementCode(AcknowledgmentCode successAcknowledgementCode) {
        this.successAcknowledgementCode = successAcknowledgementCode;
    }

    public void setErrorAcknowledgementCode(AcknowledgmentCode errorAcknowledgementCode) {
        this.errorAcknowledgementCode = errorAcknowledgementCode;
    }

    public AcknowledgmentCode getSuccessAcknowledgementCode() {
        return this.successAcknowledgementCode;
    }

    public AcknowledgmentCode getErrorAcknowledgementCode() {
        return this.errorAcknowledgementCode;
    }

    protected Message generateResponseMessage(Object request) throws HL7Exception {
        try {
            Message in;
            if (request instanceof String) {
                Segment s = this.getHapiContext().getGenericParser().getCriticalResponseData((String)request);
                in = s.getMessage();
                DeepCopy.copy(s, (Segment)in.get("MSH"));
            } else if (request instanceof Message) {
                in = (Message)request;
            } else {
                throw new HL7Exception("Validated message must be either Message or String");
            }
            return in.generateACK(this.getSuccessAcknowledgementCode(), null);
        }
        catch (IOException e) {
            throw new HL7Exception(e);
        }
    }

    protected void populateResponseMessage(Message response) throws HL7Exception {
        if (response == null) {
            return;
        }
        List<ValidationException> exceptions = this.getExceptions();
        for (int i = 0; i < exceptions.size(); ++i) {
            ValidationException ve = exceptions.get(i);
            if (ve.getSeverity() != Severity.ERROR) continue;
            ve.populateResponse(response, this.getErrorAcknowledgementCode(), i);
        }
    }

    @Override
    public ValidationExceptionHandler<Message> getNewInstance(HapiContext context) {
        return new RespondingValidationExceptionHandler(context);
    }
}

