/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util.idgenerator;

import ca.uhn.hl7v2.util.idgenerator.IDGenerator;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HiLoGenerator
extends IDGenerator.OrderedSupport {
    private static final Logger LOG = LoggerFactory.getLogger((String)HiLoGenerator.class.getName());
    private int lo = 0;
    private int base = -1;

    public synchronized String getID() throws IOException {
        if (this.base < 0) {
            LOG.debug("Obtain next hi ID");
            this.base = this.nextBase();
        }
        if (this.getNextLoId() >= this.getMaxLo()) {
            LOG.debug("Obtain next hi ID");
            this.base = this.nextBase();
        }
        return Integer.toString(this.base + this.lo);
    }

    private int nextBase() throws IOException {
        int base = this.getNextHiId();
        this.lo = 0;
        return base;
    }

    protected abstract int getNextHiId() throws IOException;

    protected abstract void resetHiId();

    protected int getNextLoId() {
        ++this.lo;
        return this.lo;
    }

    public void reset() {
        this.lo = 0;
        this.base = -1;
        this.resetHiId();
    }

    public abstract int getMaxLo();
}

