/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.protocol.AcceptValidator;
import ca.uhn.hl7v2.protocol.ApplicationRouter;
import ca.uhn.hl7v2.protocol.ProcessorContext;
import ca.uhn.hl7v2.protocol.SafeStorage;
import ca.uhn.hl7v2.protocol.TransportLayer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorContextImpl
implements ProcessorContext {
    private final ApplicationRouter myRouter;
    private final TransportLayer myLocallyDrivenTransport;
    private final TransportLayer myRemotelyDrivenTransport;
    private final SafeStorage mySafeStorage;
    private final List<AcceptValidator> myValidators;
    private final List<String> myMetadataFields;

    public ProcessorContextImpl(ApplicationRouter theRouter, TransportLayer theTransport, SafeStorage theStorage) {
        this.myRouter = theRouter;
        this.myRemotelyDrivenTransport = theTransport;
        this.myLocallyDrivenTransport = theTransport;
        this.mySafeStorage = theStorage;
        this.myValidators = new ArrayList<AcceptValidator>(8);
        this.myMetadataFields = new ArrayList<String>(30);
    }

    public ProcessorContextImpl(ApplicationRouter theRouter, TransportLayer theLocallyDrivenTransport, TransportLayer theRemotelyDrivenTransport, SafeStorage theStorage) {
        this.myRouter = theRouter;
        this.myRemotelyDrivenTransport = theRemotelyDrivenTransport;
        this.myLocallyDrivenTransport = theLocallyDrivenTransport;
        this.mySafeStorage = theStorage;
        this.myValidators = new ArrayList<AcceptValidator>(8);
        this.myMetadataFields = new ArrayList<String>(30);
    }

    @Override
    public ApplicationRouter getRouter() {
        return this.myRouter;
    }

    @Override
    public TransportLayer getRemotelyDrivenTransportLayer() {
        return this.myRemotelyDrivenTransport;
    }

    @Override
    public TransportLayer getLocallyDrivenTransportLayer() {
        return this.myLocallyDrivenTransport;
    }

    @Override
    public AcceptValidator[] getValidators() {
        return this.myValidators.toArray(new AcceptValidator[0]);
    }

    @Override
    public void addValidator(AcceptValidator theValidator) {
        this.myValidators.add(theValidator);
    }

    @Override
    public SafeStorage getSafeStorage() {
        return this.mySafeStorage;
    }

    @Override
    public List<String> getMetadataFields() {
        return this.myMetadataFields;
    }
}

