/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.preparser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.EncodingDetector;
import ca.uhn.hl7v2.preparser.DatumPath;
import ca.uhn.hl7v2.preparser.ER7;
import ca.uhn.hl7v2.preparser.XML;
import ca.uhn.hl7v2.util.Terser;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class PreParser {
    public static String[] getFields(String theMessageText, String ... thePathSpecs) throws HL7Exception {
        DatumPath[] paths = new DatumPath[thePathSpecs.length];
        for (int i = 0; i < thePathSpecs.length; ++i) {
            StringTokenizer tok = new StringTokenizer(thePathSpecs[i], "-", false);
            String segSpec = tok.nextToken();
            String segName = (tok = new StringTokenizer(segSpec, "()", false)).nextToken();
            if (segName.length() != 3) {
                throw new HL7Exception("In field path, " + segName + " is not a valid segment name");
            }
            int segRep = 0;
            if (tok.hasMoreTokens()) {
                String rep = tok.nextToken();
                try {
                    segRep = Integer.parseInt(rep);
                }
                catch (NumberFormatException e) {
                    throw new HL7Exception("In field path, segment rep" + rep + " is not valid", e);
                }
            }
            int[] indices = Terser.getIndices(thePathSpecs[i]);
            paths[i] = new DatumPath();
            paths[i].add(segName).add(segRep);
            paths[i].add(indices[0]).add(indices[1]).add(indices[2]).add(indices[3]);
        }
        return PreParser.getFields(theMessageText, paths);
    }

    private static String[] getFields(String theMessageText, DatumPath[] thePaths) throws HL7Exception {
        String[] fields = new String[thePaths.length];
        Properties props = new Properties();
        List<DatumPath> mask = Arrays.asList(thePaths);
        boolean OK = false;
        if (EncodingDetector.isEr7Encoded(theMessageText)) {
            OK = ER7.parseMessage(props, mask, theMessageText);
        } else if (EncodingDetector.isXmlEncoded(theMessageText)) {
            OK = XML.parseMessage(props, theMessageText, null);
        } else {
            throw new HL7Exception("Message encoding is not recognized");
        }
        if (!OK) {
            throw new HL7Exception("Parse failed");
        }
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = props.getProperty(thePaths[i].toString());
        }
        return fields;
    }
}

