/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.SuperStructure;
import ca.uhn.hl7v2.model.primitive.CommonTS;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.ArrayUtil;
import ca.uhn.hl7v2.util.ReflectionUtil;
import ca.uhn.hl7v2.util.StringUtil;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.ValidationContext;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractMessage
extends AbstractGroup
implements Message {
    private ValidationContext myContext;
    private static final Pattern ourVersionPattern = Pattern.compile("\\.(v2[0-9][0-9]?)\\.");
    private String myVersion;
    private transient Parser myParser;

    public AbstractMessage(ModelClassFactory theFactory) {
        super(null, theFactory);
    }

    public Message getMessage() {
        return this;
    }

    public Group getParent() {
        return this;
    }

    public String getVersion() {
        String verFolder;
        if (this.myVersion != null) {
            return this.myVersion;
        }
        String version = null;
        Pattern p = ourVersionPattern;
        Matcher m = p.matcher(this.getClass().getName());
        if (m.find() && (verFolder = m.group(1)).length() > 0) {
            char[] chars = verFolder.toCharArray();
            StringBuffer buf = new StringBuffer();
            for (int i = 1; i < chars.length; ++i) {
                buf.append(chars[i]);
                if (i >= chars.length - 1) continue;
                buf.append('.');
            }
            version = buf.toString();
        }
        if (version == null) {
            version = Version.lowestAvailableVersion().getVersion();
        }
        this.myVersion = version;
        return version;
    }

    public ValidationContext getValidationContext() {
        return this.myContext;
    }

    public void setValidationContext(ValidationContext theContext) {
        this.myContext = theContext;
    }

    public Character getFieldSeparatorValue() throws HL7Exception {
        Segment firstSegment = (Segment)this.get(this.getNames()[0]);
        Primitive value = (Primitive)firstSegment.getField(1, 0);
        String valueString = value.getValue();
        if (valueString == null || valueString.length() == 0) {
            return null;
        }
        return Character.valueOf(valueString.charAt(0));
    }

    public String getEncodingCharactersValue() throws HL7Exception {
        Segment firstSegment = (Segment)this.get(this.getNames()[0]);
        Primitive value = (Primitive)firstSegment.getField(2, 0);
        return value.getValue();
    }

    public void setParser(Parser parser) {
        if (parser == null) {
            throw new NullPointerException("Value may not be null");
        }
        this.myParser = parser;
    }

    public Parser getParser() {
        if (this.myParser == null) {
            this.myParser = new PipeParser();
        }
        return this.myParser;
    }

    public void parse(String string) throws HL7Exception {
        this.clear();
        this.getParser().parse(this, string);
    }

    public String encode() throws HL7Exception {
        return this.getParser().encode(this);
    }

    public Message generateACK() throws HL7Exception, IOException {
        return this.generateACK(AcknowledgmentCode.AA, null);
    }

    public Message generateACK(String theAcknowledgementCode, HL7Exception theException) throws HL7Exception, IOException {
        AcknowledgmentCode theCode = theAcknowledgementCode == null ? AcknowledgmentCode.AA : AcknowledgmentCode.valueOf(theAcknowledgementCode);
        return this.generateACK(theCode, theException);
    }

    public Message generateACK(AcknowledgmentCode theAcknowledgementCode, HL7Exception theException) throws HL7Exception, IOException {
        Message out = this.instantiateACK(theAcknowledgementCode);
        out.setParser(this.getParser());
        this.fillResponseHeader(out, theAcknowledgementCode);
        if (theException != null) {
            theException.populateResponse(out, theAcknowledgementCode, 0);
        }
        return out;
    }

    private Message instantiateACK(AcknowledgmentCode theAcknowledgementCode) throws HL7Exception {
        Class<? extends Message> clazz;
        ModelClassFactory mcf = this.getParser() != null ? this.getParser().getFactory() : new DefaultModelClassFactory();
        Version version = Version.versionOf(this.getVersion());
        Message out = null;
        if (version != null && version.available() && (clazz = mcf.getMessageClass("ACK", version.getVersion(), false)) != null) {
            out = ReflectionUtil.instantiateMessage(clazz, mcf);
        }
        if (out == null) {
            out = new GenericMessage.UnknownVersion(mcf);
        }
        if (out instanceof GenericMessage) {
            if (!ArrayUtil.contains(out.getNames(), "MSA")) {
                out.addNonstandardSegment("MSA");
            }
            if (!ArrayUtil.contains(out.getNames(), "ERR")) {
                out.addNonstandardSegment("ERR");
            }
        }
        return out;
    }

    public Message fillResponseHeader(Message out, AcknowledgmentCode code) throws HL7Exception, IOException {
        Version version;
        Segment mshIn = (Segment)this.get("MSH");
        Segment mshOut = (Segment)out.get("MSH");
        String fieldSep = Terser.get(mshIn, 1, 0, 1, 1);
        String encChars = Terser.get(mshIn, 2, 0, 1, 1);
        String procID = Terser.get(mshIn, 11, 0, 1, 1);
        Terser.set(mshOut, 1, 0, 1, 1, fieldSep);
        Terser.set(mshOut, 2, 0, 1, 1, encChars);
        GregorianCalendar now = new GregorianCalendar();
        now.setTime(new Date());
        Terser.set(mshOut, 7, 0, 1, 1, CommonTS.toHl7TSFormat(now));
        Terser.set(mshOut, 9, 0, 1, 1, "ACK");
        Terser.set(mshOut, 9, 0, 2, 1, Terser.get(mshIn, 9, 0, 2, 1));
        String v = mshOut.getMessage().getVersion();
        if (v != null && (version = Version.versionOf(v)) != null && !Version.V25.isGreaterThan(version)) {
            Terser.set(mshOut, 9, 0, 3, 1, "ACK");
        }
        Terser.set(mshOut, 10, 0, 1, 1, mshIn.getMessage().getParser().getParserConfiguration().getIdGenerator().getID());
        Terser.set(mshOut, 11, 0, 1, 1, procID);
        String versionId = Terser.get(mshIn, 12, 0, 1, 1);
        if (StringUtil.isBlank(versionId)) {
            versionId = Version.highestAvailableVersionOrDefault().getVersion();
        }
        Terser.set(mshOut, 12, 0, 1, 1, versionId);
        Terser.set(mshOut, 3, 0, 1, 1, Terser.get(mshIn, 5, 0, 1, 1));
        Terser.set(mshOut, 4, 0, 1, 1, Terser.get(mshIn, 6, 0, 1, 1));
        Terser.set(mshOut, 5, 0, 1, 1, Terser.get(mshIn, 3, 0, 1, 1));
        Terser.set(mshOut, 6, 0, 1, 1, Terser.get(mshIn, 4, 0, 1, 1));
        Segment msaOut = (Segment)out.get("MSA");
        Terser.set(msaOut, 1, 0, 1, 1, code.name());
        Terser.set(msaOut, 2, 0, 1, 1, Terser.get(mshIn, 10, 0, 1, 1));
        return out;
    }

    public String toString() {
        try {
            return this.encode();
        }
        catch (HL7Exception e) {
            return this.getClass().getName() + " - Failed to create toString(): " + e.getMessage();
        }
    }

    public String printStructure() throws HL7Exception {
        StringBuilder builder = new StringBuilder();
        this.appendStructureDescription(builder, 0, false, false, true, true, true);
        return builder.toString();
    }

    public String printStructure(boolean includeEmptyElements) throws HL7Exception {
        StringBuilder builder = new StringBuilder();
        this.appendStructureDescription(builder, 0, false, false, true, true, includeEmptyElements);
        return builder.toString();
    }

    public void initQuickstart(String messageCode, String messageTriggerEvent, String processingId) throws HL7Exception, IOException {
        Segment msh = (Segment)this.get("MSH");
        Terser.set(msh, 1, 0, 1, 1, "|");
        Terser.set(msh, 2, 0, 1, 1, "^~\\&");
        GregorianCalendar now = new GregorianCalendar();
        Terser.set(msh, 7, 0, 1, 1, CommonTS.toHl7TSFormat(now));
        Terser.set(msh, 9, 0, 1, 1, messageCode);
        Terser.set(msh, 9, 0, 2, 1, messageTriggerEvent);
        Terser.set(msh, 10, 0, 1, 1, this.getParser().getParserConfiguration().getIdGenerator().getID());
        Terser.set(msh, 11, 0, 1, 1, processingId);
        Terser.set(msh, 12, 0, 1, 1, this.getVersion());
        if (!Version.V24.isGreaterThan(Version.versionOf(this.getVersion()))) {
            if (this instanceof SuperStructure) {
                Version version = Version.versionOf(this.getVersion());
                Map<String, String> eventMap = new DefaultModelClassFactory().getEventMapForVersion(version);
                if (StringUtil.isNotBlank(messageCode) && StringUtil.isNotBlank(messageTriggerEvent)) {
                    String structure = eventMap.get(messageCode + "_" + messageTriggerEvent);
                    Terser.set(msh, 9, 0, 3, 1, structure);
                }
            } else {
                String className = this.getClass().getName();
                int lastIndexOf = className.lastIndexOf(46);
                if ((className = className.substring(lastIndexOf + 1)).matches("[A-Z]{3}_[A-Z0-9]{3}")) {
                    Terser.set(msh, 9, 0, 3, 1, className);
                }
            }
        }
    }
}

