/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MessageIterator
implements Iterator {
    private Structure currentStructure;
    private String direction;
    private Position next;
    private boolean handleUnexpectedSegments;
    private static final HapiLog log = HapiLogFactory.getHapiLog(MessageIterator.class);

    public MessageIterator(Structure start, String direction, boolean handleUnexpectedSegments) {
        this.currentStructure = start;
        this.direction = direction;
        this.handleUnexpectedSegments = handleUnexpectedSegments;
    }

    public boolean hasNext() {
        boolean has = true;
        if (this.next == null) {
            if (Group.class.isAssignableFrom(this.currentStructure.getClass())) {
                this.groupNext((Group)this.currentStructure);
            } else {
                Group parent = this.currentStructure.getParent();
                Index i = MessageIterator.getIndex(parent, this.currentStructure);
                Position currentPosition = new Position(parent, i);
                try {
                    if (parent.isRepeating(i.name) && this.currentStructure.getName().equals(this.direction)) {
                        this.nextRep(currentPosition);
                    } else {
                        has = this.nextPosition(currentPosition, this.direction, this.handleUnexpectedSegments);
                    }
                }
                catch (HL7Exception e) {
                    throw new Error("HL7Exception arising from bad index: " + e.getMessage());
                }
            }
        }
        log.debug("MessageIterator.hasNext() in direction " + this.direction + "? " + has);
        return has;
    }

    private void groupNext(Group current) {
        this.next = new Position(current, current.getNames()[0], 0);
    }

    private void nextRep(Position current) {
        this.next = new Position(current.parent, current.index.name, current.index.rep + 1);
    }

    private boolean nextPosition(Position currPos, String direction, boolean makeNewSegmentIfNeeded) throws HL7Exception {
        boolean nextExists = true;
        if (MessageIterator.isLast(currPos)) {
            nextExists = this.nextFromGroupEnd(currPos, direction, makeNewSegmentIfNeeded);
        } else {
            this.nextSibling(currPos);
        }
        return nextExists;
    }

    private boolean nextFromGroupEnd(Position currPos, String direction, boolean makeNewSegmentIfNeeded) throws HL7Exception {
        assert (MessageIterator.isLast(currPos));
        boolean nextExists = true;
        if (!makeNewSegmentIfNeeded && Message.class.isAssignableFrom(currPos.parent.getClass())) {
            nextExists = false;
        } else if (!makeNewSegmentIfNeeded || MessageIterator.matchExistsAfterPosition(currPos, direction, false, true)) {
            Group grandparent = currPos.parent.getParent();
            Index parentIndex = MessageIterator.getIndex(grandparent, currPos.parent);
            Position parentPos = new Position(grandparent, parentIndex);
            try {
                boolean parentRepeats = parentPos.parent.isRepeating(parentPos.index.name);
                if (parentRepeats && MessageIterator.contains(parentPos.parent.get(parentPos.index.name, 0), direction, false, true)) {
                    this.nextRep(parentPos);
                }
                nextExists = this.nextPosition(parentPos, direction, makeNewSegmentIfNeeded);
            }
            catch (HL7Exception e) {
                throw new Error("HL7Exception arising from bad index: " + e.getMessage());
            }
        } else {
            this.newSegment(currPos.parent, direction);
        }
        return nextExists;
    }

    public static boolean matchExistsAfterPosition(Position pos, String name, boolean firstDescendentsOnly, boolean upToFirstRequired) throws HL7Exception {
        boolean matchExists = false;
        if (pos.parent.isRepeating(pos.index.name)) {
            Structure s = pos.parent.get(pos.index.name, pos.index.rep);
            matchExists = MessageIterator.contains(s, name, firstDescendentsOnly, upToFirstRequired);
        }
        if (!matchExists) {
            String[] siblings = pos.parent.getNames();
            boolean after = false;
            for (int i = 0; i < siblings.length && !matchExists; ++i) {
                if (after) {
                    matchExists = MessageIterator.contains(pos.parent.get(siblings[i]), name, firstDescendentsOnly, upToFirstRequired);
                    if (upToFirstRequired && pos.parent.isRequired(siblings[i])) break;
                }
                if (!pos.index.name.equals(siblings[i])) continue;
                after = true;
            }
        }
        if (!matchExists && !Message.class.isAssignableFrom(pos.parent.getClass())) {
            Group grandparent = pos.parent.getParent();
            Position parentPos = new Position(grandparent, MessageIterator.getIndex(grandparent, pos.parent));
            matchExists = MessageIterator.matchExistsAfterPosition(parentPos, name, firstDescendentsOnly, upToFirstRequired);
        }
        log.debug("Match exists after position " + pos + " for " + name + "? " + matchExists);
        return matchExists;
    }

    private void newSegment(Group parent, String name) throws HL7Exception {
        log.info("MessageIterator creating new segment: " + name);
        parent.addNonstandardSegment(name);
        this.next = new Position(parent, parent.getNames()[parent.getNames().length - 1], 0);
    }

    public static boolean contains(Structure s, String name, boolean firstDescendentsOnly, boolean upToFirstRequired) {
        boolean contains = false;
        if (Segment.class.isAssignableFrom(s.getClass())) {
            if (s.getName().equals(name)) {
                contains = true;
            }
        } else {
            Group g = (Group)s;
            String[] names = g.getNames();
            for (int i = 0; i < names.length && !contains; ++i) {
                try {
                    contains = MessageIterator.contains(g.get(names[i], 0), name, firstDescendentsOnly, upToFirstRequired);
                    if (!firstDescendentsOnly && (!upToFirstRequired || !g.isRequired(names[i]))) continue;
                    break;
                }
                catch (HL7Exception e) {
                    throw new Error("HL7Exception due to bad index: " + e.getMessage());
                }
            }
        }
        return contains;
    }

    public static boolean isLast(Position p) {
        String[] names = p.parent.getNames();
        return names[names.length - 1].equals(p.index.name);
    }

    private void nextSibling(Position pos) {
        int i;
        String[] names = pos.parent.getNames();
        for (i = 0; i < names.length && !names[i].equals(pos.index.name); ++i) {
        }
        String nextName = names[i + 1];
        this.next = new Position(pos.parent, nextName, 0);
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more nodes in message");
        }
        try {
            this.currentStructure = this.next.parent.get(this.next.index.name, this.next.index.rep);
        }
        catch (HL7Exception e) {
            throw new NoSuchElementException("HL7Exception: " + e.getMessage());
        }
        this.clearNext();
        return this.currentStructure;
    }

    public void remove() {
        throw new UnsupportedOperationException("Can't remove a node from a message");
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.clearNext();
        this.direction = direction;
    }

    private void clearNext() {
        this.next = null;
    }

    public static Index getIndex(Group parent, Structure child) {
        Index index = null;
        String[] names = parent.getNames();
        block2: for (int i = 0; i < names.length; ++i) {
            if (!names[i].startsWith(child.getName())) continue;
            try {
                Structure[] reps = parent.getAll(names[i]);
                for (int j = 0; j < reps.length; ++j) {
                    if (child != reps[j]) continue;
                    index = new Index(names[i], j);
                    break block2;
                }
                continue;
            }
            catch (HL7Exception e) {
                log.error("", e);
                throw new Error("Internal HL7Exception finding structure index: " + e.getMessage());
            }
        }
        return index;
    }

    public static class Position {
        public Group parent;
        public Index index;

        public Position(Group parent, String name, int rep) {
            this.parent = parent;
            this.index = new Index(name, rep);
        }

        public Position(Group parent, Index i) {
            this.parent = parent;
            this.index = i;
        }

        public boolean equals(Object o) {
            boolean equals = false;
            if (o != null && o instanceof Position) {
                Position p = (Position)o;
                if (p.parent.equals(this.parent) && p.index.equals(this.index)) {
                    equals = true;
                }
            }
            return equals;
        }

        public int hashCode() {
            return this.parent.hashCode() + this.index.hashCode();
        }

        public String toString() {
            StringBuffer ret = new StringBuffer(this.parent.getName());
            ret.append(":");
            ret.append(this.index.name);
            ret.append("(");
            ret.append(this.index.rep);
            ret.append(")");
            return ret.toString();
        }
    }

    public static class Index {
        public String name;
        public int rep;

        public Index(String name, int rep) {
            this.name = name;
            this.rep = rep;
        }

        public boolean equals(Object o) {
            boolean equals = false;
            if (o != null && o instanceof Index) {
                Index i = (Index)o;
                if (i.rep == this.rep && i.name.equals(this.name)) {
                    equals = true;
                }
            }
            return equals;
        }

        public int hashCode() {
            return this.name.hashCode() + 700 * this.rep;
        }

        public String toString() {
            return this.name + ":" + this.rep;
        }
    }
}

