/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.llp;

import ca.uhn.hl7v2.llp.HL7Reader;
import ca.uhn.hl7v2.llp.HL7Writer;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.MinLowerLayerProtocol;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class LowerLayerProtocol {
    private static final HapiLog log = HapiLogFactory.getHapiLog(LowerLayerProtocol.class);
    private static boolean logChars = false;

    protected LowerLayerProtocol() {
        String logCharsProp = System.getProperty("ca.uhn.hl7v2.llp.logBytesRead");
        if (logCharsProp != null && logCharsProp.equalsIgnoreCase("TRUE")) {
            log.info("Setting ca.uhn.hl7v2.llp.logBytesRead to TRUE");
            logChars = true;
        }
    }

    public static LowerLayerProtocol makeLLP() {
        return new MinLowerLayerProtocol();
    }

    public abstract HL7Reader getReader(InputStream var1) throws LLPException;

    public abstract HL7Writer getWriter(OutputStream var1) throws LLPException;

    public static void logCharacterReceived(int c) {
        if (logChars) {
            System.out.println("Char received: " + c + " (" + (char)c + ")");
        }
    }
}

