/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

public final class TextUtils {
    public static boolean equals(boolean caseSensitive, CharSequence text1, CharSequence text2) {
        if (text1 == null) {
            throw new IllegalArgumentException("First text being compared cannot be null");
        }
        if (text2 == null) {
            throw new IllegalArgumentException("Second text being compared cannot be null");
        }
        if (text1 == text2) {
            return true;
        }
        if (text1 instanceof String && text2 instanceof String) {
            return caseSensitive ? text1.equals(text2) : ((String)text1).equalsIgnoreCase((String)text2);
        }
        return TextUtils.equals(caseSensitive, text1, 0, text1.length(), text2, 0, text2.length());
    }

    public static boolean equals(boolean caseSensitive, CharSequence text1, char[] text2) {
        return TextUtils.equals(caseSensitive, text1, 0, text1.length(), text2, 0, text2.length);
    }

    public static boolean equals(boolean caseSensitive, char[] text1, char[] text2) {
        return text1 == text2 || TextUtils.equals(caseSensitive, text1, 0, text1.length, text2, 0, text2.length);
    }

    public static boolean equals(boolean caseSensitive, char[] text1, int text1Offset, int text1Len, char[] text2, int text2Offset, int text2Len) {
        if (text1 == null) {
            throw new IllegalArgumentException("First text buffer being compared cannot be null");
        }
        if (text2 == null) {
            throw new IllegalArgumentException("Second text buffer being compared cannot be null");
        }
        if (text1Len != text2Len) {
            return false;
        }
        if (text1 == text2 && text1Offset == text2Offset && text1Len == text2Len) {
            return true;
        }
        int n = text1Len;
        int i = 0;
        while (n-- != 0) {
            char c1 = text1[text1Offset + i];
            char c2 = text2[text2Offset + i];
            if (c1 != c2) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(boolean caseSensitive, CharSequence text1, int text1Offset, int text1Len, char[] text2, int text2Offset, int text2Len) {
        if (text1 == null) {
            throw new IllegalArgumentException("First text being compared cannot be null");
        }
        if (text2 == null) {
            throw new IllegalArgumentException("Second text buffer being compared cannot be null");
        }
        if (text1Len != text2Len) {
            return false;
        }
        int n = text1Len;
        int i = 0;
        while (n-- != 0) {
            char c2;
            char c1 = text1.charAt(text1Offset + i);
            if (c1 != (c2 = text2[text2Offset + i])) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(boolean caseSensitive, CharSequence text1, int text1Offset, int text1Len, CharSequence text2, int text2Offset, int text2Len) {
        if (text1 == null) {
            throw new IllegalArgumentException("First text being compared cannot be null");
        }
        if (text2 == null) {
            throw new IllegalArgumentException("Second text being compared cannot be null");
        }
        if (text1Len != text2Len) {
            return false;
        }
        if (text1 == text2 && text1Offset == text2Offset && text1Len == text2Len) {
            return true;
        }
        int n = text1Len;
        int i = 0;
        while (n-- != 0) {
            char c2;
            char c1 = text1.charAt(text1Offset + i);
            if (c1 != (c2 = text2.charAt(text2Offset + i))) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean startsWith(boolean caseSensitive, CharSequence text, CharSequence prefix) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix cannot be null");
        }
        if (text instanceof String && prefix instanceof String) {
            return caseSensitive ? ((String)text).startsWith((String)prefix) : TextUtils.startsWith(caseSensitive, text, 0, text.length(), prefix, 0, prefix.length());
        }
        return TextUtils.startsWith(caseSensitive, text, 0, text.length(), prefix, 0, prefix.length());
    }

    public static boolean startsWith(boolean caseSensitive, CharSequence text, char[] prefix) {
        return TextUtils.startsWith(caseSensitive, text, 0, text.length(), prefix, 0, prefix.length);
    }

    public static boolean startsWith(boolean caseSensitive, char[] text, char[] prefix) {
        return TextUtils.startsWith(caseSensitive, text, 0, text.length, prefix, 0, prefix.length);
    }

    public static boolean startsWith(boolean caseSensitive, char[] text, int textOffset, int textLen, char[] prefix, int prefixOffset, int prefixLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix cannot be null");
        }
        if (textLen < prefixLen) {
            return false;
        }
        int n = prefixLen;
        int i = 0;
        while (n-- != 0) {
            char c1 = text[textOffset + i];
            char c2 = prefix[prefixOffset + i];
            if (c1 != c2) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean startsWith(boolean caseSensitive, CharSequence text, int textOffset, int textLen, char[] prefix, int prefixOffset, int prefixLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix cannot be null");
        }
        if (textLen < prefixLen) {
            return false;
        }
        int n = prefixLen;
        int i = 0;
        while (n-- != 0) {
            char c2;
            char c1 = text.charAt(textOffset + i);
            if (c1 != (c2 = prefix[prefixOffset + i])) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean startsWith(boolean caseSensitive, char[] text, int textOffset, int textLen, CharSequence prefix, int prefixOffset, int prefixLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix cannot be null");
        }
        if (textLen < prefixLen) {
            return false;
        }
        int n = prefixLen;
        int i = 0;
        while (n-- != 0) {
            char c1 = text[textOffset + i];
            char c2 = prefix.charAt(prefixOffset + i);
            if (c1 != c2) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean startsWith(boolean caseSensitive, CharSequence text, int textOffset, int textLen, CharSequence prefix, int prefixOffset, int prefixLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix cannot be null");
        }
        if (textLen < prefixLen) {
            return false;
        }
        int n = prefixLen;
        int i = 0;
        while (n-- != 0) {
            char c2;
            char c1 = text.charAt(textOffset + i);
            if (c1 != (c2 = prefix.charAt(prefixOffset + i))) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean endsWith(boolean caseSensitive, CharSequence text, CharSequence suffix) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Suffix cannot be null");
        }
        if (text instanceof String && suffix instanceof String) {
            return caseSensitive ? ((String)text).endsWith((String)suffix) : TextUtils.endsWith(caseSensitive, text, 0, text.length(), suffix, 0, suffix.length());
        }
        return TextUtils.endsWith(caseSensitive, text, 0, text.length(), suffix, 0, suffix.length());
    }

    public static boolean endsWith(boolean caseSensitive, CharSequence text, char[] suffix) {
        return TextUtils.endsWith(caseSensitive, text, 0, text.length(), suffix, 0, suffix.length);
    }

    public static boolean endsWith(boolean caseSensitive, char[] text, char[] suffix) {
        return TextUtils.endsWith(caseSensitive, text, 0, text.length, suffix, 0, suffix.length);
    }

    public static boolean endsWith(boolean caseSensitive, char[] text, int textOffset, int textLen, char[] suffix, int suffixOffset, int suffixLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Suffix cannot be null");
        }
        if (textLen < suffixLen) {
            return false;
        }
        int textReverseOffset = textOffset + textLen - 1;
        int suffixReverseOffset = suffixOffset + suffixLen - 1;
        int n = suffixLen;
        int i = 0;
        while (n-- != 0) {
            char c1 = text[textReverseOffset - i];
            char c2 = suffix[suffixReverseOffset - i];
            if (c1 != c2) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean endsWith(boolean caseSensitive, CharSequence text, int textOffset, int textLen, char[] suffix, int suffixOffset, int suffixLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Suffix cannot be null");
        }
        if (textLen < suffixLen) {
            return false;
        }
        int textReverseOffset = textOffset + textLen - 1;
        int suffixReverseOffset = suffixOffset + suffixLen - 1;
        int n = suffixLen;
        int i = 0;
        while (n-- != 0) {
            char c2;
            char c1 = text.charAt(textReverseOffset - i);
            if (c1 != (c2 = suffix[suffixReverseOffset - i])) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean endsWith(boolean caseSensitive, char[] text, int textOffset, int textLen, CharSequence suffix, int suffixOffset, int suffixLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Suffix cannot be null");
        }
        if (textLen < suffixLen) {
            return false;
        }
        int textReverseOffset = textOffset + textLen - 1;
        int suffixReverseOffset = suffixOffset + suffixLen - 1;
        int n = suffixLen;
        int i = 0;
        while (n-- != 0) {
            char c1 = text[textReverseOffset - i];
            char c2 = suffix.charAt(suffixReverseOffset - i);
            if (c1 != c2) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean endsWith(boolean caseSensitive, CharSequence text, int textOffset, int textLen, CharSequence suffix, int suffixOffset, int suffixLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Suffix cannot be null");
        }
        if (textLen < suffixLen) {
            return false;
        }
        int textReverseOffset = textOffset + textLen - 1;
        int suffixReverseOffset = suffixOffset + suffixLen - 1;
        int n = suffixLen;
        int i = 0;
        while (n-- != 0) {
            char c2;
            char c1 = text.charAt(textReverseOffset - i);
            if (c1 != (c2 = suffix.charAt(suffixReverseOffset - i))) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean contains(boolean caseSensitive, CharSequence text, CharSequence fragment) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (fragment == null) {
            throw new IllegalArgumentException("Fragment cannot be null");
        }
        if (text instanceof String && fragment instanceof String) {
            return caseSensitive ? ((String)text).contains(fragment) : TextUtils.contains(caseSensitive, text, 0, text.length(), fragment, 0, fragment.length());
        }
        return TextUtils.contains(caseSensitive, text, 0, text.length(), fragment, 0, fragment.length());
    }

    public static boolean contains(boolean caseSensitive, CharSequence text, char[] fragment) {
        return TextUtils.contains(caseSensitive, text, 0, text.length(), fragment, 0, fragment.length);
    }

    public static boolean contains(boolean caseSensitive, char[] text, char[] fragment) {
        return TextUtils.contains(caseSensitive, text, 0, text.length, fragment, 0, fragment.length);
    }

    public static boolean contains(boolean caseSensitive, char[] text, int textOffset, int textLen, char[] fragment, int fragmentOffset, int fragmentLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (fragment == null) {
            throw new IllegalArgumentException("Fragment cannot be null");
        }
        if (textLen < fragmentLen) {
            return false;
        }
        if (fragmentLen == 0) {
            return true;
        }
        int j = 0;
        for (int i = 0; i < textLen; ++i) {
            char c1 = text[textOffset + i];
            char c2 = fragment[fragmentOffset + j];
            if (c1 == c2) {
                if (++j != fragmentLen) continue;
                return true;
            }
            if (!caseSensitive) {
                if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) {
                    if (++j != fragmentLen) continue;
                    return true;
                }
                if (Character.toLowerCase(c1) == Character.toLowerCase(c2)) {
                    if (++j != fragmentLen) continue;
                    return true;
                }
            }
            if (j > 0) {
                i -= j;
            }
            j = 0;
        }
        return false;
    }

    public static boolean contains(boolean caseSensitive, CharSequence text, int textOffset, int textLen, char[] fragment, int fragmentOffset, int fragmentLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (fragment == null) {
            throw new IllegalArgumentException("Fragment cannot be null");
        }
        if (textLen < fragmentLen) {
            return false;
        }
        if (fragmentLen == 0) {
            return true;
        }
        int j = 0;
        for (int i = 0; i < textLen; ++i) {
            char c2;
            char c1 = text.charAt(textOffset + i);
            if (c1 == (c2 = fragment[fragmentOffset + j])) {
                if (++j != fragmentLen) continue;
                return true;
            }
            if (!caseSensitive) {
                if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) {
                    if (++j != fragmentLen) continue;
                    return true;
                }
                if (Character.toLowerCase(c1) == Character.toLowerCase(c2)) {
                    if (++j != fragmentLen) continue;
                    return true;
                }
            }
            if (j > 0) {
                i -= j;
            }
            j = 0;
        }
        return false;
    }

    public static boolean contains(boolean caseSensitive, char[] text, int textOffset, int textLen, CharSequence fragment, int fragmentOffset, int fragmentLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (fragment == null) {
            throw new IllegalArgumentException("Fragment cannot be null");
        }
        if (textLen < fragmentLen) {
            return false;
        }
        if (fragmentLen == 0) {
            return true;
        }
        int j = 0;
        for (int i = 0; i < textLen; ++i) {
            char c1 = text[textOffset + i];
            char c2 = fragment.charAt(fragmentOffset + j);
            if (c1 == c2) {
                if (++j != fragmentLen) continue;
                return true;
            }
            if (!caseSensitive) {
                if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) {
                    if (++j != fragmentLen) continue;
                    return true;
                }
                if (Character.toLowerCase(c1) == Character.toLowerCase(c2)) {
                    if (++j != fragmentLen) continue;
                    return true;
                }
            }
            if (j > 0) {
                i -= j;
            }
            j = 0;
        }
        return false;
    }

    public static boolean contains(boolean caseSensitive, CharSequence text, int textOffset, int textLen, CharSequence fragment, int fragmentOffset, int fragmentLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (fragment == null) {
            throw new IllegalArgumentException("Fragment cannot be null");
        }
        if (textLen < fragmentLen) {
            return false;
        }
        if (fragmentLen == 0) {
            return true;
        }
        int j = 0;
        for (int i = 0; i < textLen; ++i) {
            char c2;
            char c1 = text.charAt(textOffset + i);
            if (c1 == (c2 = fragment.charAt(fragmentOffset + j))) {
                if (++j != fragmentLen) continue;
                return true;
            }
            if (!caseSensitive) {
                if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) {
                    if (++j != fragmentLen) continue;
                    return true;
                }
                if (Character.toLowerCase(c1) == Character.toLowerCase(c2)) {
                    if (++j != fragmentLen) continue;
                    return true;
                }
            }
            if (j > 0) {
                i -= j;
            }
            j = 0;
        }
        return false;
    }

    public static int compareTo(boolean caseSensitive, CharSequence text1, CharSequence text2) {
        if (text1 == null) {
            throw new IllegalArgumentException("First text being compared cannot be null");
        }
        if (text2 == null) {
            throw new IllegalArgumentException("Second text being compared cannot be null");
        }
        if (text1 instanceof String && text2 instanceof String) {
            return caseSensitive ? ((String)text1).compareTo((String)text2) : ((String)text1).compareToIgnoreCase((String)text2);
        }
        return TextUtils.compareTo(caseSensitive, text1, 0, text1.length(), text2, 0, text2.length());
    }

    public static int compareTo(boolean caseSensitive, CharSequence text1, char[] text2) {
        return TextUtils.compareTo(caseSensitive, text1, 0, text1.length(), text2, 0, text2.length);
    }

    public static int compareTo(boolean caseSensitive, char[] text1, char[] text2) {
        return TextUtils.compareTo(caseSensitive, text1, 0, text1.length, text2, 0, text2.length);
    }

    public static int compareTo(boolean caseSensitive, char[] text1, int text1Offset, int text1Len, char[] text2, int text2Offset, int text2Len) {
        if (text1 == null) {
            throw new IllegalArgumentException("First text buffer being compared cannot be null");
        }
        if (text2 == null) {
            throw new IllegalArgumentException("Second text buffer being compared cannot be null");
        }
        if (text1 == text2 && text1Offset == text2Offset && text1Len == text2Len) {
            return 0;
        }
        int n = Math.min(text1Len, text2Len);
        int i = 0;
        while (n-- != 0) {
            char c1 = text1[text1Offset + i];
            char c2 = text2[text2Offset + i];
            if (c1 != c2) {
                if (caseSensitive) {
                    return c1 - c2;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                    return c1 - c2;
                }
            }
            ++i;
        }
        return text1Len - text2Len;
    }

    public static int compareTo(boolean caseSensitive, CharSequence text1, int text1Offset, int text1Len, char[] text2, int text2Offset, int text2Len) {
        if (text1 == null) {
            throw new IllegalArgumentException("First text being compared cannot be null");
        }
        if (text2 == null) {
            throw new IllegalArgumentException("Second text buffer being compared cannot be null");
        }
        int n = Math.min(text1Len, text2Len);
        int i = 0;
        while (n-- != 0) {
            char c2;
            char c1 = text1.charAt(text1Offset + i);
            if (c1 != (c2 = text2[text2Offset + i])) {
                if (caseSensitive) {
                    return c1 - c2;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                    return c1 - c2;
                }
            }
            ++i;
        }
        return text1Len - text2Len;
    }

    public static int compareTo(boolean caseSensitive, CharSequence text1, int text1Offset, int text1Len, CharSequence text2, int text2Offset, int text2Len) {
        if (text1 == null) {
            throw new IllegalArgumentException("First text being compared cannot be null");
        }
        if (text2 == null) {
            throw new IllegalArgumentException("Second text being compared cannot be null");
        }
        if (text1 == text2 && text1Offset == text2Offset && text1Len == text2Len) {
            return 0;
        }
        int n = Math.min(text1Len, text2Len);
        int i = 0;
        while (n-- != 0) {
            char c2;
            char c1 = text1.charAt(text1Offset + i);
            if (c1 != (c2 = text2.charAt(text2Offset + i))) {
                if (caseSensitive) {
                    return c1 - c2;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                    return c1 - c2;
                }
            }
            ++i;
        }
        return text1Len - text2Len;
    }

    public static int binarySearch(boolean caseSensitive, char[][] values, char[] text, int textOffset, int textLen) {
        if (values == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        return TextUtils.binarySearch(caseSensitive, values, 0, values.length, text, textOffset, textLen);
    }

    public static int binarySearch(boolean caseSensitive, char[][] values, CharSequence text, int textOffset, int textLen) {
        if (values == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        return TextUtils.binarySearch(caseSensitive, values, 0, values.length, text, textOffset, textLen);
    }

    public static int binarySearch(boolean caseSensitive, CharSequence[] values, char[] text, int textOffset, int textLen) {
        if (values == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        return TextUtils.binarySearch(caseSensitive, values, 0, values.length, text, textOffset, textLen);
    }

    public static int binarySearch(boolean caseSensitive, CharSequence[] values, CharSequence text, int textOffset, int textLen) {
        if (values == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        return TextUtils.binarySearch(caseSensitive, values, 0, values.length, text, textOffset, textLen);
    }

    public static int binarySearch(boolean caseSensitive, char[][] values, int valuesOffset, int valuesLen, char[] text, int textOffset, int textLen) {
        if (values == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        int low = valuesOffset;
        int high = valuesOffset + valuesLen - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            char[] midVal = values[mid];
            int cmp = TextUtils.compareTo(caseSensitive, midVal, 0, midVal.length, text, textOffset, textLen);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(boolean caseSensitive, char[][] values, int valuesOffset, int valuesLen, CharSequence text, int textOffset, int textLen) {
        if (values == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        int low = valuesOffset;
        int high = valuesOffset + valuesLen - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            char[] midVal = values[mid];
            int cmp = TextUtils.compareTo(caseSensitive, text, textOffset, textLen, midVal, 0, midVal.length);
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(boolean caseSensitive, CharSequence[] values, int valuesOffset, int valuesLen, char[] text, int textOffset, int textLen) {
        if (values == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        int low = valuesOffset;
        int high = valuesOffset + valuesLen - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            CharSequence midVal = values[mid];
            int cmp = TextUtils.compareTo(caseSensitive, midVal, 0, midVal.length(), text, textOffset, textLen);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(boolean caseSensitive, CharSequence[] values, int valuesOffset, int valuesLen, CharSequence text, int textOffset, int textLen) {
        if (values == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        int low = valuesOffset;
        int high = valuesOffset + valuesLen - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            CharSequence midVal = values[mid];
            int cmp = TextUtils.compareTo(caseSensitive, text, textOffset, textLen, midVal, 0, midVal.length());
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int hashCode(char[] text, int textOffset, int textLen) {
        int h2 = 0;
        int off = textOffset;
        for (int i = 0; i < textLen; ++i) {
            h2 = 31 * h2 + text[off++];
        }
        return h2;
    }

    public static int hashCode(CharSequence text) {
        return TextUtils.hashCodePart(0, text);
    }

    public static int hashCode(CharSequence text, int beginIndex, int endIndex) {
        return TextUtils.hashCodePart(0, text, beginIndex, endIndex);
    }

    public static int hashCode(CharSequence text0, CharSequence text1) {
        return TextUtils.hashCodePart(TextUtils.hashCodePart(0, text0), text1);
    }

    public static int hashCode(CharSequence text0, CharSequence text1, CharSequence text2) {
        return TextUtils.hashCodePart(TextUtils.hashCodePart(TextUtils.hashCodePart(0, text0), text1), text2);
    }

    public static int hashCode(CharSequence text0, CharSequence text1, CharSequence text2, CharSequence text3) {
        return TextUtils.hashCodePart(TextUtils.hashCodePart(TextUtils.hashCodePart(TextUtils.hashCodePart(0, text0), text1), text2), text3);
    }

    public static int hashCode(CharSequence text0, CharSequence text1, CharSequence text2, CharSequence text3, CharSequence text4) {
        return TextUtils.hashCodePart(TextUtils.hashCodePart(TextUtils.hashCodePart(TextUtils.hashCodePart(TextUtils.hashCodePart(0, text0), text1), text2), text3), text4);
    }

    private static int hashCodePart(int h2, CharSequence text) {
        return TextUtils.hashCodePart(h2, text, 0, text.length());
    }

    private static int hashCodePart(int h2, CharSequence text, int beginIndex, int endIndex) {
        if (h2 == 0 && beginIndex == 0 && endIndex == text.length() && text instanceof String) {
            return text.hashCode();
        }
        int hh = h2;
        for (int i = beginIndex; i < endIndex; ++i) {
            hh = 31 * hh + text.charAt(i);
        }
        return hh;
    }

    private TextUtils() {
    }
}

