/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.AbstractEngineContext;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.ILazyContextVariable;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.engine.TemplateData;
import org.thymeleaf.inline.IInliner;
import org.thymeleaf.inline.NoOpInliner;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.util.Validate;

public class WebEngineContext
extends AbstractEngineContext
implements IEngineContext,
IWebContext {
    private static final String PARAM_VARIABLE_NAME = "param";
    private static final String SESSION_VARIABLE_NAME = "session";
    private static final String APPLICATION_VARIABLE_NAME = "application";
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final HttpSession session;
    private final ServletContext servletContext;
    private final RequestAttributesVariablesMap requestAttributesVariablesMap;
    private final Map<String, Object> requestParametersVariablesMap;
    private final Map<String, Object> sessionAttributesVariablesMap;
    private final Map<String, Object> applicationAttributesVariablesMap;

    public WebEngineContext(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Locale locale, Map<String, Object> variables) {
        super(configuration, templateResolutionAttributes, locale);
        Validate.notNull(request, "Request cannot be null in web variables map");
        Validate.notNull(response, "Response cannot be null in web variables map");
        Validate.notNull(servletContext, "Servlet Context cannot be null in web variables map");
        this.request = request;
        this.response = response;
        this.session = request.getSession(false);
        this.servletContext = servletContext;
        this.requestAttributesVariablesMap = new RequestAttributesVariablesMap(configuration, templateData, templateResolutionAttributes, this.request, locale, variables);
        this.requestParametersVariablesMap = new RequestParametersMap(this.request);
        this.applicationAttributesVariablesMap = new ServletContextAttributesMap(this.servletContext);
        this.sessionAttributesVariablesMap = new SessionAttributesMap(this.session);
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public HttpSession getSession() {
        return this.session;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public boolean containsVariable(String name) {
        if (SESSION_VARIABLE_NAME.equals(name)) {
            return this.sessionAttributesVariablesMap != null;
        }
        if (PARAM_VARIABLE_NAME.equals(name)) {
            return true;
        }
        return APPLICATION_VARIABLE_NAME.equals(name) || this.requestAttributesVariablesMap.containsVariable(name);
    }

    @Override
    public Object getVariable(String key) {
        if (SESSION_VARIABLE_NAME.equals(key)) {
            return this.sessionAttributesVariablesMap;
        }
        if (PARAM_VARIABLE_NAME.equals(key)) {
            return this.requestParametersVariablesMap;
        }
        if (APPLICATION_VARIABLE_NAME.equals(key)) {
            return this.applicationAttributesVariablesMap;
        }
        return this.requestAttributesVariablesMap.getVariable(key);
    }

    @Override
    public Set<String> getVariableNames() {
        return this.requestAttributesVariablesMap.getVariableNames();
    }

    @Override
    public void setVariable(String name, Object value) {
        if (SESSION_VARIABLE_NAME.equals(name) || PARAM_VARIABLE_NAME.equals(name) || APPLICATION_VARIABLE_NAME.equals(name)) {
            throw new IllegalArgumentException("Cannot set variable called '" + name + "' into web variables map: such name is a reserved word");
        }
        this.requestAttributesVariablesMap.setVariable(name, value);
    }

    @Override
    public void setVariables(Map<String, Object> variables) {
        if (variables == null || variables.isEmpty()) {
            return;
        }
        for (String name : variables.keySet()) {
            if (!SESSION_VARIABLE_NAME.equals(name) && !PARAM_VARIABLE_NAME.equals(name) && !APPLICATION_VARIABLE_NAME.equals(name)) continue;
            throw new IllegalArgumentException("Cannot set variable called '" + name + "' into web variables map: such name is a reserved word");
        }
        this.requestAttributesVariablesMap.setVariables(variables);
    }

    @Override
    public void removeVariable(String name) {
        if (SESSION_VARIABLE_NAME.equals(name) || PARAM_VARIABLE_NAME.equals(name) || APPLICATION_VARIABLE_NAME.equals(name)) {
            throw new IllegalArgumentException("Cannot remove variable called '" + name + "' in web variables map: such name is a reserved word");
        }
        this.requestAttributesVariablesMap.removeVariable(name);
    }

    @Override
    public boolean isVariableLocal(String name) {
        return this.requestAttributesVariablesMap.isVariableLocal(name);
    }

    @Override
    public boolean hasSelectionTarget() {
        return this.requestAttributesVariablesMap.hasSelectionTarget();
    }

    @Override
    public Object getSelectionTarget() {
        return this.requestAttributesVariablesMap.getSelectionTarget();
    }

    @Override
    public void setSelectionTarget(Object selectionTarget) {
        this.requestAttributesVariablesMap.setSelectionTarget(selectionTarget);
    }

    @Override
    public IInliner getInliner() {
        return this.requestAttributesVariablesMap.getInliner();
    }

    @Override
    public void setInliner(IInliner inliner) {
        this.requestAttributesVariablesMap.setInliner(inliner);
    }

    @Override
    public TemplateData getTemplateData() {
        return this.requestAttributesVariablesMap.getTemplateData();
    }

    @Override
    public void setTemplateData(TemplateData templateData) {
        this.requestAttributesVariablesMap.setTemplateData(templateData);
    }

    @Override
    public List<TemplateData> getTemplateStack() {
        return this.requestAttributesVariablesMap.getTemplateStack();
    }

    @Override
    public void setElementTag(IProcessableElementTag elementTag) {
        this.requestAttributesVariablesMap.setElementTag(elementTag);
    }

    @Override
    public List<IProcessableElementTag> getElementStack() {
        return this.requestAttributesVariablesMap.getElementStack();
    }

    @Override
    public List<IProcessableElementTag> getElementStackAbove(int contextLevel) {
        return this.requestAttributesVariablesMap.getElementStackAbove(contextLevel);
    }

    @Override
    public int level() {
        return this.requestAttributesVariablesMap.level();
    }

    @Override
    public void increaseLevel() {
        this.requestAttributesVariablesMap.increaseLevel();
    }

    @Override
    public void decreaseLevel() {
        this.requestAttributesVariablesMap.decreaseLevel();
    }

    public String getStringRepresentationByLevel() {
        return this.requestAttributesVariablesMap.getStringRepresentationByLevel();
    }

    public String toString() {
        return this.requestAttributesVariablesMap.toString();
    }

    static Object resolveLazy(Object variable) {
        if (variable != null && variable instanceof ILazyContextVariable) {
            return ((ILazyContextVariable)variable).getValue();
        }
        return variable;
    }

    private static final class RequestParameterValues
    extends AbstractList<String> {
        private final String[] parameterValues;
        public final int length;

        RequestParameterValues(String[] parameterValues) {
            this.parameterValues = parameterValues;
            this.length = this.parameterValues.length;
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.parameterValues.clone();
        }

        @Override
        public <T> T[] toArray(T[] arr) {
            if (arr.length < this.length) {
                Object[] copy = (Object[])Array.newInstance(arr.getClass().getComponentType(), this.length);
                System.arraycopy(this.parameterValues, 0, copy, 0, this.length);
                return copy;
            }
            System.arraycopy(this.parameterValues, 0, arr, 0, this.length);
            if (arr.length > this.length) {
                arr[this.length] = null;
            }
            return arr;
        }

        @Override
        public String get(int index) {
            return this.parameterValues[index];
        }

        @Override
        public int indexOf(Object obj) {
            String[] a = this.parameterValues;
            if (obj == null) {
                for (int i = 0; i < a.length; ++i) {
                    if (a[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < a.length; ++i) {
                    if (!obj.equals(a[i])) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object obj) {
            return this.indexOf(obj) != -1;
        }

        @Override
        public String toString() {
            if (this.length == 0) {
                return "";
            }
            if (this.length == 1) {
                return this.parameterValues[0];
            }
            return super.toString();
        }
    }

    private static abstract class NoOpMapImpl
    implements Map<String, Object> {
        protected NoOpMapImpl() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException("Cannot add new entry: map is immutable");
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException("Cannot remove entry: map is immutable");
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m3) {
            throw new UnsupportedOperationException("Cannot add new entry: map is immutable");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Cannot clear: map is immutable");
        }

        @Override
        public Set<String> keySet() {
            return Collections.emptySet();
        }

        @Override
        public Collection<Object> values() {
            return Collections.emptyList();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return Collections.emptySet();
        }

        static final class MapEntry
        implements Map.Entry<String, Object> {
            private final String key;
            private final Object value;

            MapEntry(String key, Object value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public String getKey() {
                return this.key;
            }

            @Override
            public Object getValue() {
                return this.value;
            }

            @Override
            public Object setValue(Object value) {
                throw new UnsupportedOperationException("Cannot set value: map is immutable");
            }
        }
    }

    private static final class RequestAttributesVariablesMap
    extends AbstractEngineContext
    implements IEngineContext {
        private static final int DEFAULT_ELEMENT_HIERARCHY_SIZE = 20;
        private static final int DEFAULT_LEVELS_SIZE = 10;
        private static final int DEFAULT_LEVELARRAYS_SIZE = 5;
        private final HttpServletRequest request;
        private int level = 0;
        private int index = 0;
        private int[] levels;
        private String[][] names;
        private Object[][] oldValues;
        private Object[][] newValues;
        private int[] levelSizes;
        private SelectionTarget[] selectionTargets;
        private IInliner[] inliners;
        private TemplateData[] templateDatas;
        private IProcessableElementTag[] elementTags;
        private SelectionTarget lastSelectionTarget = null;
        private IInliner lastInliner = null;
        private TemplateData lastTemplateData = null;
        private final List<TemplateData> templateStack;

        RequestAttributesVariablesMap(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, HttpServletRequest request, Locale locale, Map<String, Object> variables) {
            super(configuration, templateResolutionAttributes, locale);
            this.request = request;
            this.levels = new int[10];
            this.names = new String[10][];
            this.oldValues = new Object[10][];
            this.newValues = new Object[10][];
            this.levelSizes = new int[10];
            this.selectionTargets = new SelectionTarget[10];
            this.inliners = new IInliner[10];
            this.templateDatas = new TemplateData[10];
            this.elementTags = new IProcessableElementTag[20];
            Arrays.fill(this.levels, Integer.MAX_VALUE);
            Arrays.fill((Object[])this.names, null);
            Arrays.fill((Object[])this.oldValues, null);
            Arrays.fill((Object[])this.newValues, null);
            Arrays.fill(this.levelSizes, 0);
            Arrays.fill(this.selectionTargets, null);
            Arrays.fill(this.inliners, null);
            Arrays.fill(this.templateDatas, null);
            Arrays.fill(this.elementTags, null);
            this.levels[0] = 0;
            this.templateDatas[0] = templateData;
            this.lastTemplateData = templateData;
            this.templateStack = new ArrayList<TemplateData>(10);
            this.templateStack.add(templateData);
            if (variables != null) {
                this.setVariables(variables);
            }
        }

        @Override
        public boolean containsVariable(String name) {
            return this.request.getAttribute(name) != null;
        }

        @Override
        public Object getVariable(String key) {
            return WebEngineContext.resolveLazy(this.request.getAttribute(key));
        }

        @Override
        public Set<String> getVariableNames() {
            HashSet<String> variableNames = new HashSet<String>(10);
            Enumeration attributeNamesEnum = this.request.getAttributeNames();
            while (attributeNamesEnum.hasMoreElements()) {
                variableNames.add((String)attributeNamesEnum.nextElement());
            }
            return variableNames;
        }

        private int searchNameInIndex(String name, int idx) {
            int n = this.levelSizes[idx];
            if (name == null) {
                while (n-- != 0) {
                    if (this.names[idx][n] != null) continue;
                    return n;
                }
                return -1;
            }
            while (n-- != 0) {
                if (!name.equals(this.names[idx][n])) continue;
                return n;
            }
            return -1;
        }

        @Override
        public void setVariable(String name, Object value) {
            this.ensureLevelInitialized(true);
            if (this.level > 0) {
                int levelIndex = this.searchNameInIndex(name, this.index);
                if (levelIndex >= 0) {
                    this.newValues[this.index][levelIndex] = value;
                } else {
                    if (this.names[this.index].length == this.levelSizes[this.index]) {
                        this.names[this.index] = Arrays.copyOf(this.names[this.index], this.names[this.index].length + 5);
                        this.newValues[this.index] = Arrays.copyOf(this.newValues[this.index], this.newValues[this.index].length + 5);
                        this.oldValues[this.index] = Arrays.copyOf(this.oldValues[this.index], this.oldValues[this.index].length + 5);
                    }
                    levelIndex = this.levelSizes[this.index];
                    this.names[this.index][levelIndex] = name;
                    this.oldValues[this.index][levelIndex] = this.request.getAttribute(name);
                    this.newValues[this.index][levelIndex] = value;
                    int n = this.index;
                    this.levelSizes[n] = this.levelSizes[n] + 1;
                }
            }
            this.request.setAttribute(name, value);
        }

        @Override
        public void setVariables(Map<String, Object> variables) {
            if (variables == null || variables.isEmpty()) {
                return;
            }
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                this.setVariable(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void removeVariable(String name) {
            this.setVariable(name, null);
        }

        @Override
        public boolean isVariableLocal(String name) {
            if (this.level == 0) {
                return false;
            }
            int n = this.index + 1;
            while (n-- > 1) {
                int idx = this.searchNameInIndex(name, n);
                if (idx < 0) continue;
                return this.newValues[n][idx] != null;
            }
            return false;
        }

        @Override
        public boolean hasSelectionTarget() {
            if (this.lastSelectionTarget != null) {
                return true;
            }
            int n = this.index + 1;
            while (n-- != 0) {
                if (this.selectionTargets[n] == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getSelectionTarget() {
            if (this.lastSelectionTarget != null) {
                return this.lastSelectionTarget.selectionTarget;
            }
            int n = this.index + 1;
            while (n-- != 0) {
                if (this.selectionTargets[n] == null) continue;
                this.lastSelectionTarget = this.selectionTargets[n];
                return this.lastSelectionTarget.selectionTarget;
            }
            return null;
        }

        @Override
        public void setSelectionTarget(Object selectionTarget) {
            this.ensureLevelInitialized(false);
            this.selectionTargets[this.index] = this.lastSelectionTarget = new SelectionTarget(selectionTarget);
        }

        @Override
        public IInliner getInliner() {
            if (this.lastInliner != null) {
                if (this.lastInliner == NoOpInliner.INSTANCE) {
                    return null;
                }
                return this.lastInliner;
            }
            int n = this.index + 1;
            while (n-- != 0) {
                if (this.inliners[n] == null) continue;
                this.lastInliner = this.inliners[n];
                if (this.lastInliner == NoOpInliner.INSTANCE) {
                    return null;
                }
                return this.lastInliner;
            }
            return null;
        }

        @Override
        public void setInliner(IInliner inliner) {
            this.ensureLevelInitialized(false);
            this.inliners[this.index] = this.lastInliner = inliner == null ? NoOpInliner.INSTANCE : inliner;
        }

        @Override
        public TemplateData getTemplateData() {
            if (this.lastTemplateData != null) {
                return this.lastTemplateData;
            }
            int n = this.index + 1;
            while (n-- != 0) {
                if (this.templateDatas[n] == null) continue;
                this.lastTemplateData = this.templateDatas[n];
                return this.lastTemplateData;
            }
            return null;
        }

        @Override
        public void setTemplateData(TemplateData templateData) {
            Validate.notNull(templateData, "Template Data cannot be null");
            this.ensureLevelInitialized(false);
            this.templateDatas[this.index] = this.lastTemplateData = templateData;
            this.templateStack.clear();
        }

        @Override
        public List<TemplateData> getTemplateStack() {
            if (!this.templateStack.isEmpty()) {
                return Collections.unmodifiableList(new ArrayList<TemplateData>(this.templateStack));
            }
            for (int i = 0; i <= this.index; ++i) {
                if (this.templateDatas[i] == null) continue;
                this.templateStack.add(this.templateDatas[i]);
            }
            return Collections.unmodifiableList(new ArrayList<TemplateData>(this.templateStack));
        }

        @Override
        public void setElementTag(IProcessableElementTag elementTag) {
            if (this.elementTags.length <= this.level) {
                this.elementTags = Arrays.copyOf(this.elementTags, Math.max(this.level, this.elementTags.length + 20));
            }
            this.elementTags[this.level] = elementTag;
        }

        @Override
        public List<IProcessableElementTag> getElementStack() {
            ArrayList<IProcessableElementTag> elementStack = new ArrayList<IProcessableElementTag>(this.level);
            for (int i = 0; i <= this.level && i < this.elementTags.length; ++i) {
                if (this.elementTags[i] == null) continue;
                elementStack.add(this.elementTags[i]);
            }
            return Collections.unmodifiableList(elementStack);
        }

        @Override
        public List<IProcessableElementTag> getElementStackAbove(int contextLevel) {
            ArrayList<IProcessableElementTag> elementStack = new ArrayList<IProcessableElementTag>(this.level);
            for (int i = contextLevel + 1; i <= this.level && i < this.elementTags.length; ++i) {
                if (this.elementTags[i] == null) continue;
                elementStack.add(this.elementTags[i]);
            }
            return Collections.unmodifiableList(elementStack);
        }

        private void ensureLevelInitialized(boolean initVariables) {
            if (this.levels[this.index] != this.level) {
                ++this.index;
                if (this.levels.length == this.index) {
                    this.levels = Arrays.copyOf(this.levels, this.levels.length + 10);
                    Arrays.fill(this.levels, this.index, this.levels.length, Integer.MAX_VALUE);
                    this.names = (String[][])Arrays.copyOf(this.names, this.names.length + 10);
                    this.newValues = (Object[][])Arrays.copyOf(this.newValues, this.newValues.length + 10);
                    this.oldValues = (Object[][])Arrays.copyOf(this.oldValues, this.oldValues.length + 10);
                    this.levelSizes = Arrays.copyOf(this.levelSizes, this.levelSizes.length + 10);
                    this.selectionTargets = Arrays.copyOf(this.selectionTargets, this.selectionTargets.length + 10);
                    this.inliners = Arrays.copyOf(this.inliners, this.inliners.length + 10);
                    this.templateDatas = Arrays.copyOf(this.templateDatas, this.templateDatas.length + 10);
                }
                this.levels[this.index] = this.level;
            }
            if (this.level > 0 && initVariables && this.names[this.index] == null) {
                this.names[this.index] = new String[5];
                Arrays.fill(this.names[this.index], null);
                this.newValues[this.index] = new Object[5];
                Arrays.fill(this.newValues[this.index], null);
                this.oldValues[this.index] = new Object[5];
                Arrays.fill(this.oldValues[this.index], null);
                this.levelSizes[this.index] = 0;
            }
        }

        @Override
        public int level() {
            return this.level;
        }

        @Override
        public void increaseLevel() {
            ++this.level;
        }

        @Override
        public void decreaseLevel() {
            Validate.isTrue(this.level > 0, "Cannot decrease variable map level below 0");
            if (this.levels[this.index] == this.level) {
                this.levels[this.index] = Integer.MAX_VALUE;
                if (this.names[this.index] != null && this.levelSizes[this.index] > 0) {
                    int n = this.levelSizes[this.index];
                    while (n-- != 0) {
                        String name = this.names[this.index][n];
                        Object newValue = this.newValues[this.index][n];
                        Object oldValue = this.oldValues[this.index][n];
                        Object currentValue = this.request.getAttribute(name);
                        if (newValue != currentValue) continue;
                        this.request.setAttribute(name, oldValue);
                    }
                    this.levelSizes[this.index] = 0;
                }
                this.selectionTargets[this.index] = null;
                this.inliners[this.index] = null;
                this.templateDatas[this.index] = null;
                --this.index;
                this.lastSelectionTarget = null;
                this.lastInliner = null;
                this.lastTemplateData = null;
                this.templateStack.clear();
            }
            if (this.level < this.elementTags.length) {
                this.elementTags[this.level] = null;
            }
            --this.level;
        }

        public String getStringRepresentationByLevel() {
            String name;
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append('{');
            LinkedHashMap<String, Object> oldValuesSum = new LinkedHashMap<String, Object>();
            int n = this.index + 1;
            while (n-- != 1) {
                LinkedHashMap<String, Object> levelVars = new LinkedHashMap<String, Object>();
                if (this.names[n] != null && this.levelSizes[n] > 0) {
                    for (int i = 0; i < this.levelSizes[n]; ++i) {
                        name = this.names[n][i];
                        Object newValue = this.newValues[n][i];
                        Object oldValue = this.oldValues[n][i];
                        if (newValue == oldValue || (!oldValuesSum.containsKey(name) ? newValue != this.request.getAttribute(name) : newValue != oldValuesSum.get(name))) continue;
                        levelVars.put(name, newValue);
                        oldValuesSum.put(name, oldValue);
                    }
                }
                if (levelVars.isEmpty() && this.selectionTargets[n] == null && this.inliners[n] == null) continue;
                if (strBuilder.length() > 1) {
                    strBuilder.append(',');
                }
                strBuilder.append(this.levels[n]).append(":");
                if (!levelVars.isEmpty() || n == 0) {
                    strBuilder.append(levelVars);
                }
                if (this.selectionTargets[n] != null) {
                    strBuilder.append("<").append(this.selectionTargets[n].selectionTarget).append(">");
                }
                if (this.inliners[n] != null) {
                    strBuilder.append("[").append(this.inliners[n].getName()).append("]");
                }
                if (this.templateDatas[n] == null) continue;
                strBuilder.append("(").append(this.templateDatas[n].getTemplate()).append(")");
            }
            LinkedHashMap<String, Object> requestAttributes = new LinkedHashMap<String, Object>();
            Enumeration attrNames = this.request.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                name = (String)attrNames.nextElement();
                if (oldValuesSum.containsKey(name)) {
                    Object oldValue = oldValuesSum.get(name);
                    if (oldValue != null) {
                        requestAttributes.put(name, oldValuesSum.get(name));
                    }
                    oldValuesSum.remove(name);
                    continue;
                }
                requestAttributes.put(name, this.request.getAttribute(name));
            }
            for (Map.Entry oldValuesSumEntry : oldValuesSum.entrySet()) {
                Object oldValue;
                String name2 = (String)oldValuesSumEntry.getKey();
                if (requestAttributes.containsKey(name2) || (oldValue = oldValuesSumEntry.getValue()) == null) continue;
                requestAttributes.put(name2, oldValue);
            }
            if (strBuilder.length() > 1) {
                strBuilder.append(',');
            }
            strBuilder.append(this.levels[n]).append(":");
            strBuilder.append(((Object)requestAttributes).toString());
            if (this.selectionTargets[0] != null) {
                strBuilder.append("<").append(this.selectionTargets[0].selectionTarget).append(">");
            }
            if (this.inliners[0] != null) {
                strBuilder.append("[").append(this.inliners[0].getName()).append("]");
            }
            if (this.templateDatas[0] != null) {
                strBuilder.append("(").append(this.templateDatas[0].getTemplate()).append(")");
            }
            strBuilder.append("}[");
            strBuilder.append(this.level);
            strBuilder.append(']');
            return strBuilder.toString();
        }

        public String toString() {
            LinkedHashMap<String, Object> equivalentMap = new LinkedHashMap<String, Object>();
            Enumeration attributeNamesEnum = this.request.getAttributeNames();
            while (attributeNamesEnum.hasMoreElements()) {
                String name = (String)attributeNamesEnum.nextElement();
                equivalentMap.put(name, this.request.getAttribute(name));
            }
            String textInliningStr = this.getInliner() != null ? "[" + this.getInliner().getName() + "]" : "";
            String templateDataStr = "(" + this.getTemplateData().getTemplate() + ")";
            return ((Object)equivalentMap).toString() + (this.hasSelectionTarget() ? "<" + this.getSelectionTarget() + ">" : "") + textInliningStr + templateDataStr;
        }

        private static final class SelectionTarget {
            final Object selectionTarget;

            SelectionTarget(Object selectionTarget) {
                this.selectionTarget = selectionTarget;
            }
        }
    }

    private static final class RequestParametersMap
    extends NoOpMapImpl {
        private final HttpServletRequest request;

        RequestParametersMap(HttpServletRequest request) {
            this.request = request;
        }

        @Override
        public int size() {
            return this.request.getParameterMap().size();
        }

        @Override
        public boolean isEmpty() {
            return this.request.getParameterMap().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return true;
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException("Map does not support #containsValue()");
        }

        @Override
        public Object get(Object key) {
            String[] parameterValues = this.request.getParameterValues(key != null ? key.toString() : null);
            if (parameterValues == null) {
                return null;
            }
            return new RequestParameterValues(parameterValues);
        }

        @Override
        public Set<String> keySet() {
            return this.request.getParameterMap().keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.request.getParameterMap().values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.request.getParameterMap().entrySet();
        }
    }

    private static final class ServletContextAttributesMap
    extends NoOpMapImpl {
        private final ServletContext servletContext;

        ServletContextAttributesMap(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        @Override
        public int size() {
            int size = 0;
            Enumeration attributeNames = this.servletContext.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                attributeNames.nextElement();
                ++size;
            }
            return size;
        }

        @Override
        public boolean isEmpty() {
            Enumeration attributeNames = this.servletContext.getAttributeNames();
            return !attributeNames.hasMoreElements();
        }

        @Override
        public boolean containsKey(Object key) {
            return true;
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException("Map does not support #containsValue()");
        }

        @Override
        public Object get(Object key) {
            return WebEngineContext.resolveLazy(this.servletContext.getAttribute(key != null ? key.toString() : null));
        }

        @Override
        public Set<String> keySet() {
            LinkedHashSet<String> keySet = new LinkedHashSet<String>(5);
            Enumeration attributeNames = this.servletContext.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                keySet.add((String)attributeNames.nextElement());
            }
            return keySet;
        }

        @Override
        public Collection<Object> values() {
            ArrayList<Object> values = new ArrayList<Object>(5);
            Enumeration attributeNames = this.servletContext.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                values.add(this.servletContext.getAttribute((String)attributeNames.nextElement()));
            }
            return values;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            LinkedHashSet<Map.Entry<String, Object>> entrySet = new LinkedHashSet<Map.Entry<String, Object>>(5);
            Enumeration attributeNames = this.servletContext.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String key = (String)attributeNames.nextElement();
                Object value = this.servletContext.getAttribute(key);
                entrySet.add(new NoOpMapImpl.MapEntry(key, value));
            }
            return entrySet;
        }
    }

    private static final class SessionAttributesMap
    extends NoOpMapImpl {
        private final HttpSession session;

        SessionAttributesMap(HttpSession session) {
            this.session = session;
        }

        @Override
        public int size() {
            if (this.session == null) {
                return 0;
            }
            int size = 0;
            Enumeration attributeNames = this.session.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                attributeNames.nextElement();
                ++size;
            }
            return size;
        }

        @Override
        public boolean isEmpty() {
            if (this.session == null) {
                return true;
            }
            Enumeration attributeNames = this.session.getAttributeNames();
            return !attributeNames.hasMoreElements();
        }

        @Override
        public boolean containsKey(Object key) {
            return true;
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException("Map does not support #containsValue()");
        }

        @Override
        public Object get(Object key) {
            if (this.session == null) {
                return null;
            }
            return WebEngineContext.resolveLazy(this.session.getAttribute(key != null ? key.toString() : null));
        }

        @Override
        public Set<String> keySet() {
            if (this.session == null) {
                return Collections.emptySet();
            }
            LinkedHashSet<String> keySet = new LinkedHashSet<String>(5);
            Enumeration attributeNames = this.session.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                keySet.add((String)attributeNames.nextElement());
            }
            return keySet;
        }

        @Override
        public Collection<Object> values() {
            if (this.session == null) {
                return Collections.emptySet();
            }
            ArrayList<Object> values = new ArrayList<Object>(5);
            Enumeration attributeNames = this.session.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                values.add(this.session.getAttribute((String)attributeNames.nextElement()));
            }
            return values;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            if (this.session == null) {
                return Collections.emptySet();
            }
            LinkedHashSet<Map.Entry<String, Object>> entrySet = new LinkedHashSet<Map.Entry<String, Object>>(5);
            Enumeration attributeNames = this.session.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String key = (String)attributeNames.nextElement();
                Object value = this.session.getAttribute(key);
                entrySet.add(new NoOpMapImpl.MapEntry(key, value));
            }
            return entrySet;
        }
    }
}

