/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.hashcode;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.plugin.Customizations;
import org.jvnet.jaxb2_commons.plugin.CustomizedIgnoring;
import org.jvnet.jaxb2_commons.plugin.Ignoring;
import org.jvnet.jaxb2_commons.plugin.util.FieldOutlineUtils;
import org.jvnet.jaxb2_commons.plugin.util.StrategyClassUtils;
import org.jvnet.jaxb2_commons.util.ClassUtils;
import org.jvnet.jaxb2_commons.util.FieldAccessorFactory;
import org.jvnet.jaxb2_commons.util.PropertyFieldAccessorFactory;
import org.jvnet.jaxb2_commons.xjc.outline.FieldAccessorEx;
import org.xml.sax.ErrorHandler;

public class HashCodePlugin
extends AbstractParameterizablePlugin {
    private FieldAccessorFactory fieldAccessorFactory = PropertyFieldAccessorFactory.INSTANCE;
    private String hashCodeStrategyClass = JAXBHashCodeStrategy.class.getName();
    private Ignoring ignoring = new CustomizedIgnoring(org.jvnet.jaxb2_commons.plugin.hashcode.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);

    public String getOptionName() {
        return "XhashCode";
    }

    public String getUsage() {
        return "TBD";
    }

    public FieldAccessorFactory getFieldAccessorFactory() {
        return this.fieldAccessorFactory;
    }

    public void setFieldAccessorFactory(FieldAccessorFactory fieldAccessorFactory) {
        this.fieldAccessorFactory = fieldAccessorFactory;
    }

    public void setHashCodeStrategyClass(String hashCodeStrategy) {
        this.hashCodeStrategyClass = hashCodeStrategy;
    }

    public String getHashCodeStrategyClass() {
        return this.hashCodeStrategyClass;
    }

    public JExpression createHashCodeStrategy(JCodeModel codeModel) {
        return StrategyClassUtils.createStrategyInstanceExpression(codeModel, HashCodeStrategy2.class, this.getHashCodeStrategyClass());
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    @Override
    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(org.jvnet.jaxb2_commons.plugin.hashcode.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    }

    @Override
    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        for (ClassOutline classOutline : outline.getClasses()) {
            if (this.getIgnoring().isIgnored(classOutline)) continue;
            this.processClassOutline(classOutline);
        }
        return true;
    }

    protected void processClassOutline(ClassOutline classOutline) {
        JDefinedClass theClass = classOutline.implClass;
        ClassUtils._implements(theClass, theClass.owner().ref(HashCode2.class));
        JMethod hashCode$hashCode = this.generateHashCode$hashCode(classOutline, theClass);
        JMethod object$hashCode = this.generateObject$hashCode(classOutline, theClass);
    }

    protected JMethod generateObject$hashCode(ClassOutline classOutline, JDefinedClass theClass) {
        return this.generateObject$hashCode(theClass);
    }

    private JMethod generateObject$hashCode(JDefinedClass theClass) {
        JMethod object$hashCode = theClass.method(1, (JType)theClass.owner().INT, "hashCode");
        JBlock body = object$hashCode.body();
        JVar hashCodeStrategy = body.decl(8, (JType)theClass.owner().ref(HashCodeStrategy2.class), "strategy", this.createHashCodeStrategy(theClass.owner()));
        body._return((JExpression)JExpr._this().invoke("hashCode").arg(JExpr._null()).arg((JExpression)hashCodeStrategy));
        return object$hashCode;
    }

    protected JMethod generateHashCode$hashCode(ClassOutline classOutline, JDefinedClass theClass) {
        JCodeModel codeModel = theClass.owner();
        JMethod hashCode$hashCode = theClass.method(1, (JType)codeModel.INT, "hashCode");
        JVar locator = hashCode$hashCode.param(ObjectLocator.class, "locator");
        JVar hashCodeStrategy = hashCode$hashCode.param(HashCodeStrategy2.class, "strategy");
        JBlock body = hashCode$hashCode.body();
        Boolean superClassImplementsHashCode = StrategyClassUtils.superClassImplements(classOutline, this.ignoring, HashCode2.class);
        Object currentHashCodeExpression = superClassImplementsHashCode == null ? JExpr.lit((int)1) : (superClassImplementsHashCode != false ? JExpr._super().invoke("hashCode").arg((JExpression)locator).arg((JExpression)hashCodeStrategy) : JExpr._super().invoke("hashCode"));
        JVar currentHashCode = body.decl((JType)codeModel.INT, "currentHashCode", currentHashCodeExpression);
        FieldOutline[] declaredFields = FieldOutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring());
        if (declaredFields.length > 0) {
            for (FieldOutline fieldOutline : declaredFields) {
                FieldAccessorEx fieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, JExpr._this());
                if (fieldAccessor.isConstant()) continue;
                JBlock block = body.block();
                JVar theValue = block.decl(fieldAccessor.getType(), "the" + fieldOutline.getPropertyInfo().getName(true));
                JExpression valueIsSet = fieldAccessor.isAlwaysSet() || fieldAccessor.hasSetValue() == null ? JExpr.TRUE : fieldAccessor.hasSetValue();
                fieldAccessor.toRawValue(block, theValue);
                block.assign((JAssignmentTarget)currentHashCode, (JExpression)hashCodeStrategy.invoke("hashCode").arg((JExpression)codeModel.ref(LocatorUtils.class).staticInvoke("property").arg((JExpression)locator).arg(fieldOutline.getPropertyInfo().getName(false)).arg((JExpression)theValue)).arg((JExpression)currentHashCode).arg((JExpression)theValue).arg(valueIsSet));
            }
        }
        body._return((JExpression)currentHashCode);
        return hashCode$hashCode;
    }
}

