/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.utils;

import java.util.HashMap;
import java.util.Map;

public enum SnomedVersion {
    INTL("intl", "900000000000207008"),
    US("us", "731000124108"),
    UK("uk", "999000041000000102"),
    AU("au", "32506021000036107"),
    CA("ca", "20611000087101"),
    NL("nl", "11000146104"),
    SE("se", "45991000052106"),
    ES("es", "449081005"),
    DK("dk", "554471000005108");

    private static final String DEFAULT_CODE = "900000000000207008";
    private final String lang;
    private final String code;
    private static final Map<String, SnomedVersion> lookup;

    private SnomedVersion(String lang, String code) {
        this.lang = lang;
        this.code = code;
    }

    public String getLang() {
        return this.lang;
    }

    public String getCode() {
        return this.code;
    }

    public static SnomedVersion getFromCode(String code) {
        return lookup.get(code);
    }

    static {
        lookup = new HashMap<String, SnomedVersion>();
        for (SnomedVersion s2 : SnomedVersion.values()) {
            lookup.put(s2.getCode(), s2);
        }
    }
}

