/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.utils;

import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.validation.Validator;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.utils.Common;

public class Params {
    public static final String GUI = "-gui";
    public static final String VERSION = "-version";
    public static final String OUTPUT = "-output";
    public static final String PROXY = "-proxy";
    public static final String PROFILE = "-profile";
    public static final String QUESTIONNAIRE = "-questionnaire";
    public static final String NATIVE = "-native";
    public static final String ASSUME_VALID_REST_REF = "-assumeValidRestReferences";
    public static final String DEBUG = "-debug";
    public static final String SCT = "-sct";
    public static final String RECURSE = "-recurse";
    public static final String LOCALE = "-locale";
    public static final String STRICT_EXTENSIONS = "-strictExtensions";
    public static final String HINT_ABOUT_NON_MUST_SUPPORT = "-hintAboutNonMustSupport";
    public static final String TO_VERSION = "-to-version";
    public static final String DO_NATIVE = "-do-native";
    public static final String NO_NATIVE = "-no-native";
    public static final String TRANSFORM = "-transform";
    public static final String NARRATIVE = "-narrative";
    public static final String SNAPSHOT = "-snapshot";
    public static final String SCAN = "-scan";
    public static final String TERMINOLOGY = "-tx";
    public static final String TERMINOLOGY_LOG = "-txLog";
    public static final String LOG = "-log";
    public static final String LANGUAGE = "-language";
    public static final String IMPLEMENTATION_GUIDE = "-ig";
    public static final String DEFINITION = "defn";
    public static final String MAP = "-map";
    public static final String X = "-x";
    public static final String CONVERT = "-convert";
    public static final String FHIRPATH = "-fhirpath";
    public static final String TEST = "-tests";
    public static final String HELP = "help";
    public static final String COMPARE = "-compare";
    public static final String DESTINATION = "-dest";
    public static final String LEFT = "-left";
    public static final String RIGHT = "-right";
    public static final String NO_INTERNAL_CACHING = "-no-internal-caching";
    public static final String NO_EXTENSIBLE_BINDING_WARNINGS = "-no-extensible-binding-warnings";

    public static boolean hasParam(String[] args, String param) {
        return Arrays.asList(args).contains(param);
    }

    public static String getParam(String[] args, String param) {
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equals(param)) continue;
            return args[i + 1];
        }
        return null;
    }

    public static CliContext loadCliContext(String[] args) throws Exception {
        CliContext cliContext = new CliContext();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(VERSION)) {
                cliContext.setSv(VersionUtilities.getCurrentPackageVersion(args[++i]));
                continue;
            }
            if (args[i].equals(OUTPUT)) {
                if (i + 1 == args.length) {
                    throw new Error("Specified -output without indicating output file");
                }
                cliContext.setOutput(args[++i]);
                continue;
            }
            if (args[i].equals(PROXY)) {
                ++i;
                continue;
            }
            if (args[i].equals(PROFILE)) {
                String p = null;
                if (i + 1 == args.length) {
                    throw new Error("Specified -profile without indicating profile source");
                }
                p = args[++i];
                cliContext.addProfile(args[i++]);
                if (p == null || i + 1 >= args.length || !args[i + 1].equals("@")) continue;
                if (++i + 1 == args.length) {
                    throw new Error("Specified -profile with @ without indicating profile location");
                }
                cliContext.addLocation(p, args[++i]);
                continue;
            }
            if (args[i].equals(QUESTIONNAIRE)) {
                if (i + 1 == args.length) {
                    throw new Error("Specified -questionnaire without indicating questionnaire file");
                }
                cliContext.addQuestionnaire(args[++i]);
                continue;
            }
            if (args[i].equals(NATIVE)) {
                cliContext.setDoNative(true);
                continue;
            }
            if (args[i].equals(ASSUME_VALID_REST_REF)) {
                cliContext.setAssumeValidRestReferences(true);
                continue;
            }
            if (args[i].equals(DEBUG)) {
                cliContext.setDoDebug(true);
                continue;
            }
            if (args[i].equals(SCT)) {
                cliContext.setSnomedCT(args[++i]);
                continue;
            }
            if (args[i].equals(RECURSE)) {
                cliContext.setRecursive(true);
                continue;
            }
            if (args[i].equals(LOCALE)) {
                if (i + 1 == args.length) {
                    throw new Error("Specified -locale without indicating locale");
                }
                cliContext.setLocale(new Locale(args[++i]));
                continue;
            }
            if (args[i].equals(STRICT_EXTENSIONS)) {
                cliContext.setAnyExtensionsAllowed(false);
                continue;
            }
            if (args[i].equals(NO_INTERNAL_CACHING)) {
                cliContext.setNoInternalCaching(true);
                continue;
            }
            if (args[i].equals(NO_EXTENSIBLE_BINDING_WARNINGS)) {
                cliContext.setNoExtensibleBindingMessages(true);
                continue;
            }
            if (args[i].equals(HINT_ABOUT_NON_MUST_SUPPORT)) {
                cliContext.setHintAboutNonMustSupport(true);
                continue;
            }
            if (args[i].equals(TO_VERSION)) {
                cliContext.setTargetVer(args[++i]);
                cliContext.setMode(Validator.EngineMode.VERSION);
                continue;
            }
            if (args[i].equals(DO_NATIVE)) {
                cliContext.setCanDoNative(true);
                continue;
            }
            if (args[i].equals(NO_NATIVE)) {
                cliContext.setCanDoNative(false);
                continue;
            }
            if (args[i].equals(TRANSFORM)) {
                cliContext.setMap(args[++i]);
                cliContext.setMode(Validator.EngineMode.TRANSFORM);
                continue;
            }
            if (args[i].equals(NARRATIVE)) {
                cliContext.setMode(Validator.EngineMode.NARRATIVE);
                continue;
            }
            if (args[i].equals(SNAPSHOT)) {
                cliContext.setMode(Validator.EngineMode.SNAPSHOT);
                continue;
            }
            if (args[i].equals(SCAN)) {
                cliContext.setMode(Validator.EngineMode.SCAN);
                continue;
            }
            if (args[i].equals(TERMINOLOGY)) {
                if (i + 1 == args.length) {
                    throw new Error("Specified -tx without indicating terminology server");
                }
                cliContext.setTxServer("n/a".equals(args[++i]) ? null : args[i]);
                continue;
            }
            if (args[i].equals(TERMINOLOGY_LOG)) {
                if (i + 1 == args.length) {
                    throw new Error("Specified -txLog without indicating file");
                }
                cliContext.setTxLog(args[++i]);
                continue;
            }
            if (args[i].equals(LOG)) {
                if (i + 1 == args.length) {
                    throw new Error("Specified -log without indicating file");
                }
                cliContext.setMapLog(args[++i]);
                continue;
            }
            if (args[i].equals(LANGUAGE)) {
                if (i + 1 == args.length) {
                    throw new Error("Specified -language without indicating language");
                }
                cliContext.setLang(args[++i]);
                continue;
            }
            if (args[i].equals(IMPLEMENTATION_GUIDE) || args[i].equals(DEFINITION)) {
                String s2;
                String version;
                if (i + 1 == args.length) {
                    throw new Error("Specified " + args[i] + " without indicating ig file");
                }
                if ((version = Common.getVersionFromIGName(null, s2 = args[++i])) == null) {
                    cliContext.addIg(s2);
                    continue;
                }
                cliContext.setSv(version);
                continue;
            }
            if (args[i].equals(MAP)) {
                if (cliContext.getMap() == null) {
                    if (i + 1 == args.length) {
                        throw new Error("Specified -map without indicating map file");
                    }
                    cliContext.setMap(args[++i]);
                    continue;
                }
                throw new Exception("Can only nominate a single -map parameter");
            }
            if (args[i].startsWith(X)) {
                ++i;
                continue;
            }
            if (args[i].equals(CONVERT)) {
                cliContext.setMode(Validator.EngineMode.CONVERT);
                continue;
            }
            if (args[i].equals(FHIRPATH)) {
                cliContext.setMode(Validator.EngineMode.FHIRPATH);
                if (cliContext.getFhirpath() == null) {
                    if (i + 1 == args.length) {
                        throw new Error("Specified -fhirpath without indicating a FHIRPath expression");
                    }
                    cliContext.setFhirpath(args[++i]);
                    continue;
                }
                throw new Exception("Can only nominate a single -fhirpath parameter");
            }
            cliContext.addSource(args[i]);
        }
        if (cliContext.getSources().isEmpty()) {
            throw new Exception("Must provide at least one source file");
        }
        return cliContext;
    }

    public static String getTerminologyServerLog(String[] args) {
        String txLog = null;
        if (Params.hasParam(args, TERMINOLOGY_LOG)) {
            txLog = Params.getParam(args, TERMINOLOGY_LOG);
            new File(txLog).delete();
        }
        return txLog;
    }

    public static void checkIGFileReferences(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String s2;
            if (!IMPLEMENTATION_GUIDE.equals(args[i])) continue;
            if (i + 1 == args.length) {
                throw new Error("Specified -ig without indicating ig file");
            }
            if ((s2 = args[++i]).startsWith("hl7.fhir.core-")) continue;
            System.out.println("Load Package: " + s2);
        }
    }
}

