/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.TimeTracker;

public class BaseValidator {
    protected ValidationMessage.Source source;
    protected IWorkerContext context;
    protected TimeTracker timeTracker = new TimeTracker();

    public BaseValidator(IWorkerContext context) {
        this.context = context;
    }

    @Deprecated
    protected boolean fail(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg) {
        if (!thePass) {
            this.addValidationMessage(errors, type, line, col, path, msg, ValidationMessage.IssueSeverity.FATAL, null);
        }
        return thePass;
    }

    protected boolean fail(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String msg = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, line, col, path, msg, ValidationMessage.IssueSeverity.FATAL, theMessage);
        }
        return thePass;
    }

    @Deprecated
    protected boolean fail(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String msg) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            this.addValidationMessage(errors, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.FATAL, null);
        }
        return thePass;
    }

    @Deprecated
    protected boolean fail(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            this.addValidationMessage(errors, type, -1, -1, path, this.context.formatMessage(theMessage, theMessageArguments), ValidationMessage.IssueSeverity.FATAL, theMessage);
        }
        return thePass;
    }

    @Deprecated
    protected boolean fail(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass) {
            this.addValidationMessage(errors, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.FATAL, null);
        }
        return thePass;
    }

    protected boolean grammarWord(String w) {
        return w.equals("and") || w.equals("or") || w.equals("a") || w.equals("the") || w.equals("for") || w.equals("this") || w.equals("that") || w.equals("of");
    }

    protected boolean hint(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg) {
        if (!thePass) {
            String message = this.context.formatMessage(msg, new Object[0]);
            this.addValidationMessage(errors, type, line, col, path, message, ValidationMessage.IssueSeverity.INFORMATION, msg);
        }
        return thePass;
    }

    protected boolean slicingHint(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, String html) {
        if (!thePass) {
            this.addValidationMessage(errors, type, line, col, path, msg, ValidationMessage.IssueSeverity.INFORMATION, null).setSlicingHint(true).setSliceHtml(html);
        }
        return thePass;
    }

    protected boolean hint(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, line, col, path, message, ValidationMessage.IssueSeverity.INFORMATION, theMessage);
        }
        return thePass;
    }

    protected boolean txHint(List<ValidationMessage> errors, String txLink, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, line, col, path, message, ValidationMessage.IssueSeverity.INFORMATION, ValidationMessage.Source.TerminologyEngine, theMessage).setTxLink(txLink);
        }
        return thePass;
    }

    protected boolean hint(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, -1, -1, path, message, ValidationMessage.IssueSeverity.INFORMATION, theMessage);
        }
        return thePass;
    }

    protected boolean hint(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass) {
            this.addValidationMessage(errors, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.INFORMATION, null);
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, line, col, path, message, ValidationMessage.IssueSeverity.ERROR, theMessage);
        }
        return thePass;
    }

    protected boolean txRule(List<ValidationMessage> errors, String txLink, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            errors.add(new ValidationMessage(ValidationMessage.Source.TerminologyEngine, type, line, col, path, message, ValidationMessage.IssueSeverity.ERROR).setTxLink(txLink));
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String msg) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            this.addValidationMessage(errors, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.ERROR, null);
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, -1, -1, path, message, ValidationMessage.IssueSeverity.ERROR, theMessage);
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass) {
            this.addValidationMessage(errors, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.ERROR, null);
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, -1, -1, path, message, ValidationMessage.IssueSeverity.ERROR, theMessage);
        }
        return thePass;
    }

    public boolean rule(List<ValidationMessage> errors, ValidationMessage.Source source, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass) {
            this.addValidationMessage(errors, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.ERROR, source, null);
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html) {
        if (!thePass) {
            msg = this.context.formatMessage(msg, null);
            html = this.context.formatMessage(html, null);
            this.addValidationMessage(errors, type, path, msg, html, ValidationMessage.IssueSeverity.ERROR, null);
        }
        return thePass;
    }

    protected String splitByCamelCase(String s2) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (Character.isUpperCase(c) && i != 0 && !Character.isUpperCase(s2.charAt(i - 1))) {
                b.append(' ');
            }
            b.append(c);
        }
        return b.toString();
    }

    protected String stripPunctuation(String s2, boolean numbers) {
        StringBuilder b = new StringBuilder();
        for (char c : s2.toCharArray()) {
            int t = Character.getType(c);
            if (!(t == 1 || t == 2 || t == 3 || t == 4 || t == 5 || t == 9 && numbers || t == 10 && numbers) && c != ' ') continue;
            b.append(c);
        }
        return b.toString();
    }

    private String toPath(List<String> pathParts) {
        if (pathParts == null || pathParts.isEmpty()) {
            return "";
        }
        return "//" + StringUtils.join(pathParts, '/');
    }

    protected boolean warning(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            ValidationMessage.IssueSeverity severity = ValidationMessage.IssueSeverity.WARNING;
            this.addValidationMessage(errors, type, line, col, path, nmsg, severity, msg);
        }
        return thePass;
    }

    protected ValidationMessage addValidationMessage(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, String msg, ValidationMessage.IssueSeverity theSeverity, String id) {
        ValidationMessage.Source source = this.source;
        return this.addValidationMessage(errors, type, line, col, path, msg, theSeverity, source, id);
    }

    protected ValidationMessage addValidationMessage(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, String msg, ValidationMessage.IssueSeverity theSeverity, ValidationMessage.Source theSource, String id) {
        ValidationMessage validationMessage = new ValidationMessage(theSource, type, line, col, path, msg, theSeverity).setMessageId(id);
        errors.add(validationMessage);
        return validationMessage;
    }

    protected boolean txWarning(List<ValidationMessage> errors, String txLink, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            errors.add(new ValidationMessage(ValidationMessage.Source.TerminologyEngine, type, line, col, path, nmsg, ValidationMessage.IssueSeverity.WARNING).setTxLink(txLink).setMessageId(msg));
        }
        return thePass;
    }

    protected boolean warningOrError(boolean isError, List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            this.addValidationMessage(errors, type, line, col, path, nmsg, isError ? ValidationMessage.IssueSeverity.ERROR : ValidationMessage.IssueSeverity.WARNING, msg);
        }
        return thePass;
    }

    protected boolean warning(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, -1, -1, path, message, ValidationMessage.IssueSeverity.WARNING, theMessage);
        }
        return thePass;
    }

    protected boolean warning(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass) {
            this.addValidationMessage(errors, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.WARNING, null);
        }
        return thePass;
    }

    protected boolean warning(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html) {
        if (!thePass) {
            this.addValidationMessage(errors, type, path, msg, html, ValidationMessage.IssueSeverity.WARNING, null);
        }
        return thePass;
    }

    protected boolean warning(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html, Object ... theMessageArguments) {
        if (!thePass) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            this.addValidationMessage(errors, type, path, nmsg, html, ValidationMessage.IssueSeverity.WARNING, msg);
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            this.addValidationMessage(errors, type, line, col, path, nmsg, ValidationMessage.IssueSeverity.INFORMATION, msg);
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, -1, -1, path, message, ValidationMessage.IssueSeverity.INFORMATION, theMessage);
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass) {
            this.addValidationMessage(errors, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.INFORMATION, null);
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html) {
        if (!thePass) {
            ValidationMessage.IssueSeverity severity = ValidationMessage.IssueSeverity.INFORMATION;
            this.addValidationMessage(errors, type, path, msg, html, severity, null);
        }
        return thePass;
    }

    protected void addValidationMessage(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, String msg, String html, ValidationMessage.IssueSeverity theSeverity, String id) {
        errors.add(new ValidationMessage(this.source, type, -1, -1, path, msg, html, theSeverity).setMessageId(id));
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html, Object ... theMessageArguments) {
        if (!thePass) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            this.addValidationMessage(errors, type, path, nmsg, html, ValidationMessage.IssueSeverity.INFORMATION, msg);
        }
        return thePass;
    }

    protected ValueSet resolveBindingReference(DomainResource ctxt, String reference, String uri) {
        if (reference != null) {
            if (reference.startsWith("#")) {
                for (Resource c : ctxt.getContained()) {
                    if (!c.getId().equals(reference.substring(1)) || !(c instanceof ValueSet)) continue;
                    return (ValueSet)c;
                }
                return null;
            }
            long t = System.nanoTime();
            ValueSet fr = this.context.fetchResource(ValueSet.class, reference);
            if (fr == null && !Utilities.isAbsoluteUrl(reference)) {
                reference = this.resolve(uri, reference);
                fr = this.context.fetchResource(ValueSet.class, reference);
            }
            if (fr == null) {
                fr = ValueSetUtilities.generateImplicitValueSet(reference);
            }
            this.timeTracker.tx(t, System.nanoTime());
            return fr;
        }
        return null;
    }

    private String resolve(String uri, String ref) {
        if (StringUtils.isBlank(uri)) {
            return ref;
        }
        String[] up = uri.split("\\/");
        String[] rp = ref.split("\\/");
        if (this.context.getResourceNames().contains(up[up.length - 2]) && this.context.getResourceNames().contains(rp[0])) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < up.length - 2; ++i) {
                b.append(up[i]);
                b.append("/");
            }
            b.append(ref);
            return b.toString();
        }
        return ref;
    }

    protected String describeReference(String reference) {
        if (reference == null) {
            return "null";
        }
        return reference;
    }
}

