/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.graphql;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.graphql.Argument;
import org.hl7.fhir.utilities.graphql.EGraphEngine;
import org.hl7.fhir.utilities.graphql.EGraphQLException;
import org.hl7.fhir.utilities.graphql.Value;

public class ObjectValue
extends Value {
    private List<Argument> fields = new ArrayList<Argument>();

    public ObjectValue() {
    }

    public ObjectValue(JsonObject json) throws EGraphQLException {
        for (Map.Entry<String, JsonElement> n : json.entrySet()) {
            this.fields.add(new Argument(n.getKey(), n.getValue()));
        }
    }

    public List<Argument> getFields() {
        return this.fields;
    }

    public Argument addField(String name, Argument.ArgumentListStatus listStatus) throws FHIRException {
        Argument result = null;
        for (Argument t : this.fields) {
            if (!t.name.equals(name)) continue;
            result = t;
        }
        if (result == null) {
            result = new Argument();
            result.setName(name);
            result.setListStatus(listStatus);
            this.fields.add(result);
        } else {
            if (result.getListStatus() == Argument.ArgumentListStatus.SINGLETON) {
                throw new FHIRException("Error: Attempt to make '+name+' into a repeating field when it is constrained by @singleton");
            }
            result.setListStatus(Argument.ArgumentListStatus.REPEATING);
        }
        return result;
    }

    @Override
    public void write(StringBuilder b, int indent) throws EGraphQLException, EGraphEngine {
        this.write(b, indent, System.lineSeparator());
    }

    @Override
    public String getValue() {
        return null;
    }

    public void write(StringBuilder b, Integer indent, String lineSeparator) throws EGraphQLException, EGraphEngine {
        b.append("{");
        String s2 = "";
        String se = "";
        if (indent > -1) {
            se = lineSeparator + Utilities.padLeft("", ' ', indent * 2);
            Integer n = indent;
            indent = indent + 1;
            Integer n2 = indent;
            s2 = lineSeparator + Utilities.padLeft("", ' ', indent * 2);
        }
        boolean first = true;
        for (Argument a : this.fields) {
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            b.append(s2);
            a.write(b, indent);
        }
        b.append(se);
        b.append("}");
    }
}

